/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase;", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "length1", "", "length2", "<init>", "(II)V", "getLength1", "()I", "getLength2", "changes", "", "Lcom/intellij/diff/util/Range;", "unchanged", "createChangeIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "ChangedIterator", "UnchangedIterator", "ChangeIterable", "intellij.platform.util.diff"})
@ApiStatus.Internal
public abstract class ChangeDiffIterableBase
implements DiffIterable {
    private final int length1;
    private final int length2;

    public ChangeDiffIterableBase(int length1, int length2) {
        this.length1 = length1;
        this.length2 = length2;
    }

    @Override
    public int getLength1() {
        return this.length1;
    }

    @Override
    public int getLength2() {
        return this.length2;
    }

    @Override
    @NotNull
    public Iterator<Range> changes() {
        return new ChangedIterator(this.createChangeIterable());
    }

    @Override
    @NotNull
    public Iterator<Range> unchanged() {
        return new UnchangedIterator(this.createChangeIterable(), this.getLength1(), this.getLength2());
    }

    @NotNull
    protected abstract ChangeIterable createChangeIterable();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\bd\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "", "valid", "", "next", "", "start1", "", "getStart1", "()I", "start2", "getStart2", "end1", "getEnd1", "end2", "getEnd2", "intellij.platform.util.diff"})
    protected static interface ChangeIterable {
        public boolean valid();

        public void next();

        public int getStart1();

        public int getStart2();

        public int getEnd1();

        public int getEnd2();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u00020\bH\u0096\u0082\u0004J\n\u0010\t\u001a\u00020\u0002H\u0096\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangedIterator;", "", "Lcom/intellij/diff/util/Range;", "myIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "<init>", "(Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;)V", "hasNext", "", "next", "intellij.platform.util.diff"})
    private static final class ChangedIterator
    implements Iterator<Range>,
    KMappedMarker {
        @NotNull
        private final ChangeIterable myIterable;

        public ChangedIterator(@NotNull ChangeIterable myIterable) {
            Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
            this.myIterable = myIterable;
        }

        @Override
        public boolean hasNext() {
            return this.myIterable.valid();
        }

        @Override
        @NotNull
        public Range next() {
            Range range = new Range(this.myIterable.getStart1(), this.myIterable.getEnd1(), this.myIterable.getStart2(), this.myIterable.getEnd2());
            this.myIterable.next();
            return range;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u00020\rH\u0096\u0082\u0004J\n\u0010\u000e\u001a\u00020\u0002H\u0096\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$UnchangedIterator;", "", "Lcom/intellij/diff/util/Range;", "myIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "myLength1", "", "myLength2", "<init>", "(Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;II)V", "lastIndex1", "lastIndex2", "hasNext", "", "next", "intellij.platform.util.diff"})
    private static final class UnchangedIterator
    implements Iterator<Range>,
    KMappedMarker {
        @NotNull
        private final ChangeIterable myIterable;
        private final int myLength1;
        private final int myLength2;
        private int lastIndex1;
        private int lastIndex2;

        public UnchangedIterator(@NotNull ChangeIterable myIterable, int myLength1, int myLength2) {
            Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
            this.myIterable = myIterable;
            this.myLength1 = myLength1;
            this.myLength2 = myLength2;
            if (this.myIterable.valid() && this.myIterable.getStart1() == 0 && this.myIterable.getStart2() == 0) {
                this.lastIndex1 = this.myIterable.getEnd1();
                this.lastIndex2 = this.myIterable.getEnd2();
                this.myIterable.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.myIterable.valid() || this.lastIndex1 != this.myLength1 || this.lastIndex2 != this.myLength2;
        }

        @Override
        @NotNull
        public Range next() {
            if (this.myIterable.valid()) {
                if (!(this.myIterable.getStart1() >= this.lastIndex1 || this.myIterable.getStart2() >= this.lastIndex2)) {
                    throw new IllegalStateException("Check failed.");
                }
                Range chunk = new Range(this.lastIndex1, this.myIterable.getStart1(), this.lastIndex2, this.myIterable.getStart2());
                this.lastIndex1 = this.myIterable.getEnd1();
                this.lastIndex2 = this.myIterable.getEnd2();
                this.myIterable.next();
                return chunk;
            }
            if (!(this.myLength1 - this.lastIndex1 != 0 || this.myLength2 - this.lastIndex2 != 0)) {
                throw new IllegalStateException("Check failed.");
            }
            Range chunk = new Range(this.lastIndex1, this.myLength1, this.lastIndex2, this.myLength2);
            this.lastIndex1 = this.myLength1;
            this.lastIndex2 = this.myLength2;
            return chunk;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

