/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.lines.BaseLineFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class TryWithResourcesLineFilter
extends BaseLineFilter {
    private State myState = State.INITIAL;
    private int myJumpsToRemove = 0;
    private int myExceptionVarIndex = -1;

    @Override
    public boolean isApplicable(InstrumentationData context) {
        return true;
    }

    @Override
    protected boolean shouldRemoveLine() {
        return this.myState == State.GOTO || this.myState == State.THROW || this.myState == State.CALL_CLOSE || this.myState == State.STORE_INITIAL_EXCEPTION_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        this.myState = State.INITIAL;
        this.myJumpsToRemove = 0;
        this.myExceptionVarIndex = -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVarInsn(int opcode, int var) {
        void var1_1;
        this.mv.visitVarInsn(opcode, var);
        if (opcode == 58) {
            if (this.myState == State.INITIAL) {
                this.myState = State.STORE_INITIAL_EXCEPTION;
                this.myExceptionVarIndex = var;
                return;
            }
            if (this.myState == State.THROW) {
                this.myState = State.STORE_INITIAL_EXCEPTION_2;
                this.myExceptionVarIndex = var;
                return;
            }
            if (this.myState == State.GOTO) {
                this.myState = State.STORE_ADDITIONAL_EXCEPTION;
                return;
            }
            this.setHasInstructions();
            this.myState = State.INITIAL;
            return;
        }
        if (var1_1 == 25) {
            void var2_2;
            if (this.myExceptionVarIndex == var2_2 && this.myState == State.CALL_CLOSE) {
                this.myState = State.LOAD_INITIAL_EXCEPTION_2;
                return;
            }
            if (this.myState == State.INITIAL || this.myState == State.STORE_INITIAL_EXCEPTION || this.myState == State.STORE_INITIAL_EXCEPTION_2 || this.myState == State.CHECK_RESOURCE_NULL || this.myState == State.GOTO_2 || this.myState == State.CALL_CLOSE) {
                this.myState = State.LOAD_RESOURCE;
                return;
            }
            if (this.myState == State.STORE_ADDITIONAL_EXCEPTION) {
                this.myState = State.LOAD_INITIAL_EXCEPTION;
                return;
            }
            if (this.myState == State.LOAD_INITIAL_EXCEPTION) {
                this.myState = State.LOAD_ADDITIONAL_EXCEPTION;
                return;
            }
            if (this.myState == State.CALL_ADD_SUPPRESSED) {
                this.myState = State.LOAD_INITIAL_EXCEPTION_2;
                return;
            }
            this.setHasInstructions();
            this.myState = State.INITIAL;
            return;
        }
        this.setHasInstructions();
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        this.mv.visitJumpInsn(opcode, (Label)var2_2);
        if (this.myState == State.LOAD_RESOURCE && opcode == 198) {
            this.myState = State.CHECK_RESOURCE_NULL;
            ++this.myJumpsToRemove;
            return;
        }
        if (this.myState == State.CALL_CLOSE && opcode == 167) {
            this.myState = State.GOTO;
            while (this.myJumpsToRemove-- > 0) {
                this.myContext.removeLastJump();
            }
        } else {
            void var1_1;
            if (this.myState == State.CALL_ADD_SUPPRESSED && var1_1 == 167) {
                this.myState = State.GOTO_2;
                return;
            }
            this.setHasInstructions();
            this.myState = State.INITIAL;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mv.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if ((opcode == 185 || opcode == 182) && "close".equals(name) && "()V".equals(descriptor) && this.myState == State.LOAD_RESOURCE) {
            this.myState = State.CALL_CLOSE;
            return;
        }
        if (this.myState == State.LOAD_ADDITIONAL_EXCEPTION && var1_1 == 182 && "java/lang/Throwable".equals(var2_2) && "addSuppressed".equals(var3_3) && "(Ljava/lang/Throwable;)V".equals(descriptor)) {
            this.myState = State.CALL_ADD_SUPPRESSED;
            return;
        }
        this.setHasInstructions();
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInsn(int opcode) {
        void var1_1;
        this.mv.visitInsn(opcode);
        if (this.myState == State.LOAD_INITIAL_EXCEPTION_2 && var1_1 == 191) {
            this.myState = State.THROW;
            return;
        }
        this.setHasInstructions();
        this.myState = State.INITIAL;
    }

    private static enum State {
        INITIAL,
        STORE_INITIAL_EXCEPTION,
        STORE_INITIAL_EXCEPTION_2,
        LOAD_RESOURCE,
        CHECK_RESOURCE_NULL,
        CALL_CLOSE,
        GOTO,
        STORE_ADDITIONAL_EXCEPTION,
        LOAD_INITIAL_EXCEPTION,
        LOAD_ADDITIONAL_EXCEPTION,
        CALL_ADD_SUPPRESSED,
        GOTO_2,
        LOAD_INITIAL_EXCEPTION_2,
        THROW;

    }
}

