/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0006"}, d2={"fastRemoveCppFunctionArgs", "", "line", "dropArgs", "", "removeTemplates", "intellij.profiler.common"})
public final class ParserUtilKt {
    @NotNull
    public static final String fastRemoveCppFunctionArgs(@NotNull String line, boolean dropArgs) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.startsWith$default((String)line, (String)"0x", (boolean)false, (int)2, null)) {
            return line;
        }
        if (StringsKt.contains$default((CharSequence)line, (char)'[', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (char)']', (boolean)false, (int)2, null)) {
            return line;
        }
        String noTemplates = ParserUtilKt.removeTemplates(line);
        return dropArgs ? StringsKt.substringBeforeLast$default((String)noTemplates, (char)'(', null, (int)2, null) : noTemplates;
    }

    private static final String removeTemplates(String line) {
        int templateStartIndex = -1;
        int templateEndIndex = -1;
        int templateBalance = 0;
        int n = ((CharSequence)line).length();
        for (int index = 0; index < n; ++index) {
            if (line.charAt(index) == '<') {
                if (templateBalance == 0) {
                    templateStartIndex = index;
                }
                ++templateBalance;
                continue;
            }
            if (line.charAt(index) != '>' || templateBalance <= 0 || --templateBalance != 0) continue;
            templateEndIndex = index;
            break;
        }
        if (templateEndIndex == -1) {
            return line;
        }
        StringBuilder result2 = new StringBuilder();
        String string = line.substring(0, templateStartIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        result2.append(string);
        String string2 = line.substring(templateEndIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        result2.append(ParserUtilKt.removeTemplates(string2));
        String string3 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }
}

