/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.FontUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\u0012\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u0017\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0014J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007H\u0004J4\u0010\u001d\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u001e\u001a\u00020\u0019H\u0014J$\u0010\u001f\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0014J&\u0010 \u001a\u0004\u0018\u00010\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer;", "T", "", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphRenderer;", "<init>", "()V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "setBackground", "(Ljava/awt/Color;)V", "beforePaint", "", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "g", "Ljava/awt/Graphics2D;", "paint", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "calculateBounds", "Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer$NodeBounds;", "paintInnerRectangle", "innerRectangle", "Ljava/awt/geom/RectangularShape;", "fillRect", "rect", "color", "paintText", "realShape", "getBackgroundColor", "getBorderColor", "NodeBounds", "intellij.profiler.common"})
public class DefaultFlameGraphRenderer<T>
implements FlameGraphRenderer<T> {
    @NotNull
    private Color background;

    public DefaultFlameGraphRenderer() {
        Color color = JBColor.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        this.background = color;
    }

    @NotNull
    protected final Color getBackground() {
        return this.background;
    }

    protected final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    @Override
    public void beforePaint(@NotNull FlameGraphPanel<T> component, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (SystemInfo.isMac) {
            g.setFont(FontUtil.disableKerning((Font)g.getFont()));
        }
    }

    @Override
    public void paint(@NotNull FlameGraphPanel<T> component, @NotNull Graphics2D g, @NotNull FlameGraphNode<T> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        this.background = this.getBackgroundColor(component, bounds);
        NodeBounds nodeBounds = this.calculateBounds(g);
        RectangularShape outerBounds = nodeBounds.component1();
        RectangularShape innerBounds = nodeBounds.component2();
        g.setClip(outerBounds);
        if (!ProfilerUIUtilsKt.isNewFlameGraphView()) {
            Color color = this.getBorderColor(component, bounds);
            if (color == null) {
                color = (Color)JBColor.BLACK;
            }
            Color mainBorder = color;
            Color border = new Color(ColorUtil.mix((Color)this.background, (Color)mainBorder, (double)((double)mainBorder.getAlpha() / (double)255)).getRGB());
            this.fillRect(g, outerBounds, border);
        }
        this.paintInnerRectangle(component, g, innerBounds, bounds);
        this.paintText(component, g, bounds, innerBounds);
    }

    private final NodeBounds calculateBounds(Graphics2D g) {
        AffineTransform transform = g.getTransform();
        double scaleX = 1.0 / transform.getScaleX();
        double scaleY = 1.0 / transform.getScaleY();
        Rectangle $this$calculateBounds_u24lambda_u240 = g.getClipBounds();
        boolean bl = false;
        Rectangle2D.Double outerRect = new Rectangle2D.Double((double)$this$calculateBounds_u24lambda_u240.x - scaleX, $this$calculateBounds_u24lambda_u240.y, (double)$this$calculateBounds_u24lambda_u240.width + scaleX, (double)$this$calculateBounds_u24lambda_u240.height + scaleY);
        boolean expStyle = ProfilerUIUtilsKt.isNewFlameGraphView();
        double x = outerRect.x + scaleX;
        double y = outerRect.y + scaleY;
        double width = outerRect.width - scaleX * (double)2;
        double height = outerRect.height - scaleY * (double)2;
        RectangularShape innerRect = expStyle ? (RectangularShape)new RoundRectangle2D.Double(x + scaleX, y + scaleY, width - (double)2 * scaleX, height - (double)2 * scaleY, 10.0, 10.0) : (RectangularShape)new Rectangle2D.Double(x, y, width, height);
        return new NodeBounds(outerRect, innerRect);
    }

    protected void paintInnerRectangle(@NotNull FlameGraphPanel<T> component, @NotNull Graphics2D g, @NotNull RectangularShape innerRectangle, @NotNull FlameGraphNode<T> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)innerRectangle, (String)"innerRectangle");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        this.fillRect(g, innerRectangle, this.background);
    }

    protected final void fillRect(@NotNull Graphics2D g, @NotNull RectangularShape rect, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        g.setColor(color);
        g.fill(rect);
    }

    protected void paintText(@NotNull FlameGraphPanel<T> component, @NotNull Graphics2D g, @NotNull FlameGraphNode<T> bounds, @NotNull RectangularShape realShape) {
        block0: {
            Intrinsics.checkNotNullParameter(component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)realShape, (String)"realShape");
            g.setColor(g.getColor().darker());
            String string = this.getDisplayableText(component.getModel(), bounds.getContent());
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int y = component.getRowHeight() / 2 + fm.getAscent() * 2 / 5;
            g.drawString(it, 0, y);
        }
    }

    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<T> component, @NotNull FlameGraphNode<T> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        JBColor jBColor = JBColor.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"DARK_GRAY");
        return (Color)jBColor;
    }

    @Nullable
    protected Color getBorderColor(@NotNull FlameGraphPanel<T> component, @NotNull FlameGraphNode<T> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer$NodeBounds;", "", "outerBounds", "Ljava/awt/geom/RectangularShape;", "innerBounds", "<init>", "(Ljava/awt/geom/RectangularShape;Ljava/awt/geom/RectangularShape;)V", "getOuterBounds", "()Ljava/awt/geom/RectangularShape;", "getInnerBounds", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
    protected static final class NodeBounds {
        @NotNull
        private final RectangularShape outerBounds;
        @NotNull
        private final RectangularShape innerBounds;

        public NodeBounds(@NotNull RectangularShape outerBounds, @NotNull RectangularShape innerBounds) {
            Intrinsics.checkNotNullParameter((Object)outerBounds, (String)"outerBounds");
            Intrinsics.checkNotNullParameter((Object)innerBounds, (String)"innerBounds");
            this.outerBounds = outerBounds;
            this.innerBounds = innerBounds;
        }

        @NotNull
        public final RectangularShape getOuterBounds() {
            return this.outerBounds;
        }

        @NotNull
        public final RectangularShape getInnerBounds() {
            return this.innerBounds;
        }

        @NotNull
        public final RectangularShape component1() {
            return this.outerBounds;
        }

        @NotNull
        public final RectangularShape component2() {
            return this.innerBounds;
        }

        @NotNull
        public final NodeBounds copy(@NotNull RectangularShape outerBounds, @NotNull RectangularShape innerBounds) {
            Intrinsics.checkNotNullParameter((Object)outerBounds, (String)"outerBounds");
            Intrinsics.checkNotNullParameter((Object)innerBounds, (String)"innerBounds");
            return new NodeBounds(outerBounds, innerBounds);
        }

        public static /* synthetic */ NodeBounds copy$default(NodeBounds nodeBounds, RectangularShape rectangularShape, RectangularShape rectangularShape2, int n, Object object) {
            if ((n & 1) != 0) {
                rectangularShape = nodeBounds.outerBounds;
            }
            if ((n & 2) != 0) {
                rectangularShape2 = nodeBounds.innerBounds;
            }
            return nodeBounds.copy(rectangularShape, rectangularShape2);
        }

        @NotNull
        public String toString() {
            return "NodeBounds(outerBounds=" + this.outerBounds + ", innerBounds=" + this.innerBounds + ")";
        }

        public int hashCode() {
            int result2 = this.outerBounds.hashCode();
            result2 = result2 * 31 + this.innerBounds.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeBounds)) {
                return false;
            }
            NodeBounds nodeBounds = (NodeBounds)other;
            if (!Intrinsics.areEqual((Object)this.outerBounds, (Object)nodeBounds.outerBounds)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.innerBounds, (Object)nodeBounds.innerBounds);
        }
    }
}

