/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.modifier;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.processor.modifier.ModifierProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.UtilityClassModifierProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDefaultsModifierProcessor
implements ModifierProcessor {
    private static ConfigDiscovery getConfigDiscovery() {
        return ConfigDiscovery.getInstance();
    }

    @Override
    public boolean isSupported(@NotNull PsiModifierList modifierList) {
        PsiElement psiElement;
        if (modifierList == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(0);
        }
        if (!((psiElement = modifierList.getParent()) instanceof PsiField) || psiElement instanceof PsiEnumConstant || psiElement instanceof LombokLightFieldBuilder) {
            return false;
        }
        PsiClass searchableClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifierList, PsiClass.class, (boolean)true);
        return null != searchableClass && FieldDefaultsModifierProcessor.canBeAffected(searchableClass);
    }

    @Override
    public void transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(1);
        }
        if (modifiers == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(2);
        }
        if (modifiers.contains("static") || UtilityClassModifierProcessor.isModifierListSupported(modifierList)) {
            return;
        }
        PsiClass searchableClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifierList, PsiClass.class, (boolean)true);
        if (searchableClass == null) {
            return;
        }
        @Nullable PsiAnnotation fieldDefaultsAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)searchableClass, "lombok.experimental.FieldDefaults");
        boolean isConfigDefaultFinal = FieldDefaultsModifierProcessor.isConfigDefaultFinal(searchableClass);
        boolean isConfigDefaultPrivate = FieldDefaultsModifierProcessor.isConfigDefaultPrivate(searchableClass);
        PsiField parentField = (PsiField)modifierList.getParent();
        if (FieldDefaultsModifierProcessor.shouldMakeFinal(parentField, fieldDefaultsAnnotation, isConfigDefaultFinal)) {
            modifiers.add("final");
        }
        if (FieldDefaultsModifierProcessor.canChangeVisibility(parentField, modifierList)) {
            String defaultAccessLevel = FieldDefaultsModifierProcessor.detectDefaultAccessLevel(fieldDefaultsAnnotation, isConfigDefaultPrivate);
            if ("private".equals(defaultAccessLevel)) {
                modifiers.add("private");
                modifiers.remove("packageLocal");
            } else if ("protected".equals(defaultAccessLevel)) {
                modifiers.add("protected");
                modifiers.remove("packageLocal");
            } else if ("public".equals(defaultAccessLevel)) {
                modifiers.add("public");
                modifiers.remove("packageLocal");
            }
        }
    }

    private static boolean canBeAffected(PsiClass searchableClass) {
        return PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)searchableClass, "lombok.experimental.FieldDefaults") || FieldDefaultsModifierProcessor.isConfigDefaultFinal(searchableClass) || FieldDefaultsModifierProcessor.isConfigDefaultPrivate(searchableClass);
    }

    private static boolean isConfigDefaultFinal(PsiClass searchableClass) {
        return FieldDefaultsModifierProcessor.getConfigDiscovery().getBooleanLombokConfigProperty(ConfigKey.FIELDDEFAULTS_FINAL, searchableClass);
    }

    private static boolean isConfigDefaultPrivate(PsiClass searchableClass) {
        return FieldDefaultsModifierProcessor.getConfigDiscovery().getBooleanLombokConfigProperty(ConfigKey.FIELDDEFAULTS_PRIVATE, searchableClass);
    }

    private static boolean shouldMakeFinal(@NotNull PsiField parentField, @Nullable PsiAnnotation fieldDefaultsAnnotation, boolean isConfigDefaultFinal) {
        if (parentField == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(3);
        }
        return FieldDefaultsModifierProcessor.shouldMakeFinalByDefault(fieldDefaultsAnnotation, isConfigDefaultFinal) && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)parentField, "lombok.experimental.NonFinal");
    }

    private static boolean shouldMakeFinalByDefault(@Nullable PsiAnnotation fieldDefaultsAnnotation, boolean isConfigDefaultFinal) {
        if (fieldDefaultsAnnotation != null) {
            return PsiAnnotationUtil.getBooleanAnnotationValue(fieldDefaultsAnnotation, "makeFinal", false);
        }
        return isConfigDefaultFinal;
    }

    private static boolean canChangeVisibility(@NotNull PsiField parentField, @NotNull PsiModifierList modifierList) {
        if (parentField == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(4);
        }
        if (modifierList == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(5);
        }
        return !FieldDefaultsModifierProcessor.hasExplicitAccessModifier(modifierList) && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)parentField, "lombok.experimental.PackagePrivate");
    }

    private static String detectDefaultAccessLevel(@Nullable PsiAnnotation fieldDefaultsAnnotation, boolean isConfigDefaultPrivate) {
        String accessLevelFromAnnotation;
        String string = accessLevelFromAnnotation = fieldDefaultsAnnotation != null ? LombokProcessorUtil.getAccessLevel(fieldDefaultsAnnotation, "level") : null;
        if (accessLevelFromAnnotation == null && isConfigDefaultPrivate) {
            return "private";
        }
        return accessLevelFromAnnotation;
    }

    private static boolean hasExplicitAccessModifier(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            FieldDefaultsModifierProcessor.$$$reportNull$$$0(6);
        }
        return modifierList.hasExplicitModifier("public") || modifierList.hasExplicitModifier("private") || modifierList.hasExplicitModifier("protected");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentField";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/modifier/FieldDefaultsModifierProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "transformModifiers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldMakeFinal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExplicitAccessModifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

