/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnreachableSwitchBranchesInspection
extends JSInspection {
    public boolean ignoreInDynamicTypeContext = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInDynamicTypeContext", (String)JavaScriptBundle.message((String)"js.unreachable.switch.branches.ignore.with.dynamic", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSUnreachableSwitchBranchesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnreachableSwitchBranchesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnreachableSwitchBranchesInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){
            private static final Key<CachedValue<Set<Object>>> POSSIBLE_VALUES_STRICT = Key.create((String)"js.possible.switch.values.strict");
            private static final Key<CachedValue<Set<Object>>> POSSIBLE_VALUES_DYNAMIC = Key.create((String)"js.possible.switch.values.dynamic");

            public void visitJSCaseClause(@NotNull JSCaseClause node) {
                JSSwitchStatement switchStatement;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((switchStatement = node.getSwitchStatement()) == null) {
                    return;
                }
                Set<Object> possibleValues = 1.getPossibleValues(switchStatement, JSUnreachableSwitchBranchesInspection.this.ignoreInDynamicTypeContext);
                if (possibleValues == null || possibleValues.isEmpty()) {
                    return;
                }
                List existingVariants = JSSwitchBranchesProcessor.getExistingVariants((JSCaseClause)node, null);
                if (existingVariants.isEmpty()) {
                    return;
                }
                if (!ContainerUtil.exists((Iterable)existingVariants, it -> possibleValues.contains(it.value()))) {
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.unreachable.switch.branches.inspection.desc", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveUnreachableCaseBranch()});
                }
            }

            @Nullable
            private static Set<Object> getPossibleValues(@NotNull JSSwitchStatement switchStatement, boolean ignoreInDynamicTypeContext) {
                if (switchStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                Key<CachedValue<Set<Object>>> key = ignoreInDynamicTypeContext ? POSSIBLE_VALUES_STRICT : POSSIBLE_VALUES_DYNAMIC;
                return (Set)CachedValuesManager.getCachedValue((PsiElement)switchStatement, key, () -> {
                    JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases((JSSwitchStatement)switchStatement);
                    Set possibleValues = typeForCases == null || ignoreInDynamicTypeContext && (!typeForCases.isSourceStrict() || JSTypeUtils.isAnyType((JSType)typeForCases)) ? null : JSSwitchBranchesProcessor.getAllCaseVariants((JSType)typeForCases, (boolean)true).stream().map(JSSwitchBranchesProcessor.JSEnumValue::value).collect(Collectors.toSet());
                    return new CachedValueProvider.Result(possibleValues, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchStatement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSCaseClause";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getPossibleValues";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class RemoveUnreachableCaseBranch
    implements LocalQuickFix {
        private RemoveUnreachableCaseBranch() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.unreachable.switch.branches.remove", (Object[])new Object[0]);
            if (string == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            assert (element instanceof JSCaseClause);
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection$RemoveUnreachableCaseBranch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection$RemoveUnreachableCaseBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

