/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.ES6DestructuringVariablesMergeInspection;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.InspectionBasedCodeOptimization;
import com.intellij.lang.javascript.intentions.JSPromiseToAsyncIntention;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntentionKt;
import com.intellij.lang.javascript.intentions.destructuring.JSStatementDestructuringIntentionBase;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class JSDestructuringPropagationIntentionBase
extends JSStatementDestructuringIntentionBase {
    private static final String REST_NAME_PLACEHOLDER = "~~";

    protected void invokeForVariable(@NotNull Project project, @NotNull Editor editor, @NotNull JSVariable targetVar) {
        if (project == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(1);
        }
        if (targetVar == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(2);
        }
        MultiMap nameRefs = MultiMap.createLinkedSet();
        Kind kind = JSDestructuringPropagationIntentionBase.validateRefs(ReferencesSearch.search((PsiElement)targetVar).findAll(), (MultiMap<Key, RefUsage>)nameRefs, project, editor, true, (PsiElement)targetVar);
        if (kind == Kind.None) {
            return;
        }
        HashSet<String> introducedUnpleasantNames = new HashSet<String>();
        PsiElement result2 = JSDestructuringPropagationIntentionBase.replaceRefs((MultiMap<Key, RefUsage>)nameRefs, targetVar, kind, introducedUnpleasantNames);
        if (result2 != null && result2.isValid()) {
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)result2);
            JSDestructuringPropagationIntentionBase.moveToResult(editor, result2);
            JSDestructuringPropagationIntentionBase.optimizeCode(project, result2.getContainingFile(), result2);
            this.startRecursiveStep(project, editor, introducedUnpleasantNames, pointer.getElement());
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSDestructuringPropagationIntentionBase.startNamesTemplate(project, editor, introducedUnpleasantNames, pointer.getElement()));
        }
    }

    private static void startNamesTemplate(@NotNull Project project, @NotNull Editor editor, @NotNull Set<String> introducedUnpleasantNames, @Nullable PsiElement result2) {
        if (project == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(4);
        }
        if (introducedUnpleasantNames == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(5);
        }
        if (result2 == null || !result2.isValid()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        if (introducedUnpleasantNames.isEmpty()) {
            JSDestructuringPropagationIntentionBase.moveToResult(editor, result2);
            return;
        }
        Set allVariables = SyntaxTraverser.psiTraverser((PsiElement)result2).filter(JSVariable.class).toSet();
        PsiElement scope = ((JSVariable)allVariables.iterator().next()).getDeclarationScope();
        IntRef counter = new IntRef(0);
        HashMap variables = new HashMap();
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(scope);
        SyntaxTraverser.psiTraverser((PsiElement)scope).filter(JSReferenceExpression.class).forEach(r -> {
            String referenceName = r.getReferenceName();
            if (referenceName != null && r.getQualifier() == null && introducedUnpleasantNames.contains(referenceName) && allVariables.contains(r.resolve())) {
                Object newName;
                boolean hasKey = variables.containsKey(referenceName);
                Object object = newName = hasKey ? (String)variables.get(referenceName) : "v" + counter.get();
                if (!hasKey) {
                    variables.put(referenceName, newName);
                    counter.inc();
                }
                builder.replaceElement((PsiElement)r, (String)newName, null, false, false);
            }
        });
        allVariables.forEach(v -> {
            String vName = v.getName();
            if (introducedUnpleasantNames.contains(vName)) {
                builder.replaceElement(v.getNameIdentifier(), (String)variables.get(vName), (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro(vName)), true, false);
            }
        });
        if (counter.get() == 0) {
            JSDestructuringPropagationIntentionBase.moveToResult(editor, result2);
            return;
        }
        builder.run(editor, true);
    }

    private static void moveToResult(@NotNull Editor editor, @NotNull PsiElement result2) {
        if (editor == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(7);
        }
        editor.getCaretModel().moveToOffset(result2.getTextRange().getEndOffset());
    }

    private void startRecursiveStep(@NotNull Project project, @NotNull Editor editor, @NotNull Set<String> introducedUnpleasantNames, @Nullable PsiElement result2) {
        if (project == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(9);
        }
        if (introducedUnpleasantNames == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(10);
        }
        if (result2 != null && result2.isValid() && this.isRecursivePropagation()) {
            SyntaxTraverser.psiTraverser((PsiElement)result2).filter(JSVariable.class).forEach(v -> {
                if (v.getParent() instanceof JSDestructuringArrayRestElement) {
                    return;
                }
                JSType jsType = TypeScriptTypeRelations.expandAndOptimizeElementTypeRecursive((PsiElement)v);
                if (!JSGenerateDestructuringPatternIntentionKt.isApplicableType(jsType, false)) {
                    return;
                }
                MultiMap refs = MultiMap.createLinkedSet();
                Kind refsKind = JSDestructuringPropagationIntentionBase.validateRefs(ReferencesSearch.search((PsiElement)v).findAll(), (MultiMap<Key, RefUsage>)refs, project, editor, false, result2);
                if (refsKind != Kind.None) {
                    JSDestructuringPropagationIntentionBase.replaceRefs((MultiMap<Key, RefUsage>)refs, v, refsKind, introducedUnpleasantNames);
                }
            });
        }
    }

    protected boolean isRecursivePropagation() {
        return true;
    }

    private static void optimizeCode(Project project, PsiFile file, PsiElement result2) {
        new InspectionBasedCodeOptimization((LocalInspectionTool)new ES6DestructuringVariablesMergeInspection(), ES6DestructuringVariablesMergeInspection.MergeDestructuringPropertiesFix.class, (Condition<? super PsiElement>)Conditions.alwaysTrue()).perform(project, file, result2);
    }

    private static void showError(@NotNull Project project, Editor editor, @NlsContexts.DialogMessage String message, boolean reportErrors) {
        if (project == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(11);
        }
        if (!reportErrors) {
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"dialog.message.cannot.propagate.variable", (Object[])new Object[]{message}), (String)JavaScriptBundle.message((String)"dialog.title.cannot.propagate", (Object[])new Object[0]), null);
    }

    private static PsiElement replaceRefs(MultiMap<Key, RefUsage> nameRefs, JSVariable variable, Kind kind, Set<String> introducedUnpleasantNames) {
        PsiElement parent = variable.getParent();
        StringBuilder destruct = new StringBuilder();
        if (parent instanceof JSDestructuringProperty) {
            destruct.append("{").append(JSDestructuringPropagationIntentionBase.getPropertyName((JSDestructuringProperty)parent)).append(": ");
        } else if (parent instanceof JSDestructuringArray) {
            destruct.append("[");
        }
        destruct.append(kind == Kind.Prop ? "{" : "[");
        StringBuilder nameSequence = new StringBuilder();
        JSDestructuringPropagationIntentionBase.appendNameRefs(nameRefs, variable, nameSequence, kind, introducedUnpleasantNames);
        destruct.append((CharSequence)nameSequence);
        destruct.append(kind == Kind.Prop ? "}" : "]");
        if (parent instanceof JSDestructuringArray) {
            destruct.append("]");
        } else if (parent instanceof JSDestructuringProperty) {
            destruct.append("}");
        }
        JSDestructuringPropagationIntentionBase.appendTypeAndInitializer(variable, destruct);
        return JSDestructuringPropagationIntentionBase.replaceWithDestructuring((PsiElement)variable, parent, JSPsiElementFactory.createParameterOrVariableItem((String)destruct.toString(), (PsiElement)parent, (boolean)(parent instanceof JSCatchBlock), (boolean)(variable instanceof JSParameter)), true);
    }

    protected static void appendTypeAndInitializer(JSVariable variable, StringBuilder builder) {
        JSExpression initializer;
        PsiElement typeElement = variable.getTypeElement();
        if (typeElement != null) {
            builder.append(": ").append(typeElement.getText());
        }
        if ((initializer = variable.getInitializer()) != null) {
            builder.append(" = ").append(initializer.getText());
        }
    }

    protected static PsiElement replaceWithDestructuring(PsiElement variable, PsiElement parent, PsiElement declaration, boolean innerScopes) {
        JSDestructuringContainer target;
        Ref resultingElement = Ref.create(null);
        JSDestructuringContainer jSDestructuringContainer = target = declaration instanceof JSDestructuringElement ? ((JSDestructuringElement)declaration).getTarget() : null;
        if (parent instanceof JSParameterList) {
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> resultingElement.set((Object)JSDestructuringPropagationIntentionBase.expandForParameter((JSParameterList)parent, variable, declaration)));
        } else if (parent instanceof JSVarStatement || parent instanceof JSCatchBlock) {
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> resultingElement.set((Object)variable.replace(declaration)));
        } else if (innerScopes && target instanceof JSDestructuringObject) {
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> resultingElement.set((Object)parent.replace((PsiElement)((JSDestructuringObject)target).getProperties()[0])));
        } else if (innerScopes && target instanceof JSDestructuringArray) {
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> resultingElement.set((Object)variable.replace((PsiElement)((JSDestructuringArray)target).getElementsWithRest()[0])));
        } else {
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> resultingElement.set((Object)variable.replace(declaration)));
        }
        return (PsiElement)resultingElement.get();
    }

    static PsiElement expandForParameter(JSParameterList parent, PsiElement variable, PsiElement declaration) {
        Object text = parent.getText();
        if (variable instanceof JSParameterItem && ((String)text).startsWith("(")) {
            return variable.replace(declaration);
        }
        text = "(" + declaration.getText() + ")";
        JSFunction jsFunction = (JSFunction)JSPsiElementFactory.createJSSourceElement((String)("function " + (String)text + "{}"), (PsiElement)parent, JSFunction.class);
        return parent.replace((PsiElement)Objects.requireNonNull(jsFunction.getParameterList()));
    }

    private static void appendNameRefs(MultiMap<Key, RefUsage> nameRefs, JSVariable variable, StringBuilder nameSequence, Kind kind, Set<String> introducedUnpleasantNames) {
        List<Key> sortedKeys = JSDestructuringPropagationIntentionBase.sortKeys(nameRefs.keySet(), kind);
        boolean hasSpareComma = false;
        for (int i = 0; i < sortedKeys.size(); ++i) {
            Key key = sortedKeys.get(i);
            Collection refs = nameRefs.get((Object)key);
            if (refs.isEmpty()) {
                assert (kind == Kind.Index);
                nameSequence.append(",");
                if (i != 0 && !hasSpareComma && !nameSequence.isEmpty()) {
                    nameSequence.append(",");
                }
                hasSpareComma = true;
                continue;
            }
            String name = null;
            for (RefUsage ref : ContainerUtil.sorted((Collection)refs, Comparator.comparing(e -> JSDestructuringPropagationIntentionBase.getUsagePriority(e, key)).thenComparing(e -> e.container == null ? 0 : e.container.getTextOffset()))) {
                name = JSDestructuringPropagationIntentionBase.transformRef(variable, nameSequence, name, ref, key, hasSpareComma, introducedUnpleasantNames);
            }
            hasSpareComma = false;
        }
    }

    private static int getUsagePriority(RefUsage e, Key key) {
        JSDestructuringContainer container;
        JSQualifiedExpression reference = e.reference;
        if (reference != null) {
            PsiElement parent = reference.getParent();
            if (!(parent instanceof JSVariable)) {
                return 3;
            }
            if (reference instanceof JSReferenceExpression && Objects.equals(((JSVariable)parent).getName(), ((JSReferenceExpression)reference).getReferenceName())) {
                return -2;
            }
        }
        if ((container = e.container) != null) {
            JSDestructuringProperty property;
            if (container instanceof JSDestructuringObject && key.stringKey != null && (property = JSDestructuringPropagationIntentionBase.findProperty(key, (JSDestructuringObject)container)) instanceof JSDestructuringShorthandedProperty) {
                return -1;
            }
            return 2;
        }
        return e.initializer != null ? 1 : 0;
    }

    private static JSDestructuringProperty findProperty(Key key, JSDestructuringObject container) {
        for (JSDestructuringProperty property : container.getProperties()) {
            if (!JSDestructuringPropagationIntentionBase.getPropertyName(property).equals(key.stringKey)) continue;
            return property;
        }
        return null;
    }

    @NotNull
    private static List<Key> sortKeys(Set<Key> nameRefs, Kind kind) {
        if (kind == Kind.Prop) {
            List list = ContainerUtil.sorted(nameRefs, Comparator.comparing(k -> k.isRest ? REST_NAME_PLACEHOLDER : k.toString()));
            if (list == null) {
                JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(12);
            }
            return list;
        }
        int max = nameRefs.stream().mapToInt(k -> k.numericKey).max().orElse(-1);
        ArrayList<Key> newKeys = new ArrayList<Key>();
        Map byKey = ContainerUtil.map2Map(nameRefs, n -> Pair.create((Object)n.numericKey, (Object)n));
        for (int i = 0; i <= max; ++i) {
            newKeys.add(Key.from(i, byKey.containsKey(i) && ((Key)byKey.get((Object)Integer.valueOf((int)i))).isRest));
        }
        ArrayList<Key> arrayList = newKeys;
        if (arrayList == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static String transformRef(JSVariable variable, StringBuilder nameSequence, String name, RefUsage ref, Key key, boolean hasSpareComma, Set<String> introducedUnpleasantNames) {
        JSQualifiedExpression reference = ref.reference;
        return reference != null ? JSDestructuringPropagationIntentionBase.transformRef(variable, nameSequence, name, reference, key, hasSpareComma, introducedUnpleasantNames) : JSDestructuringPropagationIntentionBase.transformRef(variable, nameSequence, name, ref.container, key, hasSpareComma, introducedUnpleasantNames);
    }

    private static String transformRef(JSVariable variable, StringBuilder sequence, String name, JSDestructuringContainer container, Key key, boolean hasSpareComma, Set<String> introducedUnpleasantNames) {
        if (container instanceof JSDestructuringObject) {
            JSExpression initializer;
            JSDestructuringProperty property = JSDestructuringPropagationIntentionBase.findProperty(key, (JSDestructuringObject)container);
            if (!hasSpareComma && !sequence.isEmpty()) {
                sequence.append(", ");
            }
            assert (property != null);
            JSInitializerOwner element = property.getDestructuringElement();
            if (!(element instanceof JSVariable)) {
                sequence.append(key.stringKey).append(": ");
            } else if (key.isRest) {
                sequence.append("...");
            }
            name = JSDestructuringPropagationIntentionBase.propagateDestructuring(variable, sequence, name, container, (JSElement)element, true, introducedUnpleasantNames);
            JSExpression jSExpression = initializer = element == null ? null : element.getInitializer();
            if (initializer != null) {
                sequence.append(" = ").append(initializer.getText());
            }
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSDestructuringPropagationIntentionBase.deleteDestructuringItem((PsiElement)property, container));
        } else if (container instanceof JSDestructuringArray) {
            JSElement[] elements = ((JSDestructuringArray)container).getElementsWithRest();
            int numericKey = key.numericKey;
            if (numericKey >= 0 && numericKey < elements.length) {
                JSExpression initializer;
                JSElement element = elements[numericKey];
                if (name != null && element instanceof JSVariable) {
                    Collection allRefs = ReferencesSearch.search((PsiElement)element).findAll();
                    for (PsiReference ref : allRefs) {
                        PsiElement refElement = ref.getElement();
                        if (!(refElement instanceof JSReferenceExpression)) continue;
                        String finalName = name;
                        JSDestructuringPropagationIntentionBase.runWriteAction(() -> refElement.replace((PsiElement)JSPsiElementFactory.createJSExpression((String)finalName, (PsiElement)container)));
                    }
                }
                if (name == null) {
                    if (!hasSpareComma && !sequence.isEmpty()) {
                        sequence.append(", ");
                    }
                    name = JSDestructuringPropagationIntentionBase.propagateDestructuring(variable, sequence, null, container, element, false, introducedUnpleasantNames);
                }
                JSExpression jSExpression = initializer = element instanceof JSInitializerOwner ? ((JSInitializerOwner)element).getInitializer() : null;
                if (initializer != null) {
                    sequence.append(" = ").append(initializer.getText());
                }
                if (!(element instanceof JSEmptyExpression)) {
                    JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSDestructuringPropagationIntentionBase.deleteDestructuringItem((PsiElement)element, container));
                }
            }
        }
        return name;
    }

    private static String propagateDestructuring(JSVariable variable, StringBuilder sequence, String name, JSDestructuringContainer container, JSElement element, boolean isObjDestructuring, Set<String> introducedUnpleasantNames) {
        List allVariables = SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSVariable.class).toList();
        Map namesMap = ContainerUtil.map2Map((Collection)allVariables, v -> Pair.create((Object)v.getName(), (Object)JSDestructuringPropagationIntentionBase.createUniqueName(variable, (PsiElement)container, Objects.requireNonNull(v.getName()), introducedUnpleasantNames)));
        sequence.append(JSPromiseToAsyncIntention.replaceNamesInDestructuring(element, namesMap, isObjDestructuring));
        if (element instanceof JSVariable && name == null) {
            name = (String)namesMap.get(element.getName());
        }
        for (JSVariable jsVariable : allVariables) {
            JSDestructuringPropagationIntentionBase.replaceAllRefs(namesMap, jsVariable);
        }
        return name;
    }

    @NotNull
    private static String createUniqueName(@NotNull JSVariable variable, @Nullable PsiElement container, @NotNull String name, @NotNull Set<String> introducedUnpleasantNames) {
        String newName;
        if (variable == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(14);
        }
        if (name == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(15);
        }
        if (introducedUnpleasantNames == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(16);
        }
        if (!name.equals(newName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)name, (PsiElement)variable.getParent(), (Collection)ContainerUtil.emptyList(), (boolean)false, (PsiElement)container))) {
            introducedUnpleasantNames.add(newName);
        }
        String string = newName;
        if (string == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void replaceAllRefs(@Unmodifiable Map<String, String> namesMap, JSVariable jsVariable) {
        String ownName = jsVariable.getName();
        String newName = namesMap.get(ownName);
        if (newName.equals(ownName)) {
            return;
        }
        Collection refs = ReferencesSearch.search((PsiElement)jsVariable).findAll();
        for (PsiReference ref : refs) {
            if (!(ref instanceof JSReferenceExpression)) continue;
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSPromiseToAsyncIntention.doReplaceSingleRef((JSReferenceExpression)ref, newName, (PsiElement)jsVariable));
        }
    }

    private static String transformRef(JSVariable variable, StringBuilder nameSequence, String name, JSQualifiedExpression reference, Key key, boolean hasSpareComma, Set<String> introducedUnpleasantNames) {
        PsiElement grandParent = reference.getParent();
        if (grandParent instanceof JSVariable && name == null) {
            JSVarStatement statement;
            String newName;
            name = ((JSVariable)grandParent).getName();
            if (!Objects.equals(name, newName = JSDestructuringPropagationIntentionBase.createUniqueName(variable, (PsiElement)(statement = ((JSVariable)grandParent).getStatement()), Objects.requireNonNull(name), introducedUnpleasantNames))) {
                JSDestructuringPropagationIntentionBase.replaceAllRefs(JSPromiseToAsyncIntention.createSingleValueMap(name, newName), (JSVariable)grandParent);
                name = newName;
            }
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSDestructuringPropagationIntentionBase.deleteVarWithWhitespaces(grandParent, statement));
            if (!hasSpareComma && !nameSequence.isEmpty()) {
                nameSequence.append(", ");
            }
            JSDestructuringPropagationIntentionBase.appendName(nameSequence, name, reference);
        } else {
            if (name == null) {
                boolean isAlwaysUnpleasant = false;
                if (key.stringKey != null) {
                    name = key.stringKey;
                } else {
                    name = JSNameSuggestionsUtil.generateOrdinal((int)key.numericKey);
                    isAlwaysUnpleasant = true;
                }
                name = JSDestructuringPropagationIntentionBase.createUniqueName(variable, null, name, introducedUnpleasantNames);
                if (isAlwaysUnpleasant) {
                    introducedUnpleasantNames.add(name);
                }
                if (!hasSpareComma && !nameSequence.isEmpty()) {
                    nameSequence.append(", ");
                }
                JSDestructuringPropagationIntentionBase.appendName(nameSequence, name, reference);
            }
            String finalName = name;
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> reference.replace(JSPsiElementFactory.createJSExpression((String)finalName, (PsiElement)variable)));
        }
        return name;
    }

    private static void deleteVarWithWhitespaces(PsiElement grandParent, JSVarStatement statement) {
        NewLineEraser eraser = null;
        if (statement != null && statement.getVariables().length == 1) {
            eraser = new NewLineEraser((PsiElement)statement);
        }
        grandParent.delete();
        if (eraser != null) {
            eraser.process();
        }
    }

    protected static void deleteDestructuringItem(PsiElement element, JSDestructuringContainer container) {
        PsiElement grandParent;
        PsiElement parent;
        if (container instanceof JSDestructuringObject && ((JSDestructuringObject)container).getProperties().length > 1) {
            element.delete();
            return;
        }
        if (container instanceof JSDestructuringArray && Arrays.stream(((JSDestructuringArray)container).getElementsWithRest()).filter(e -> !(e instanceof JSEmptyExpression)).count() > 1L) {
            element.delete();
            return;
        }
        PsiElement psiElement = parent = container == null ? element : container.getParent();
        if (parent instanceof JSDestructuringElement && (grandParent = parent.getParent()) instanceof JSVarStatement && ((JSVarStatement)grandParent).getDeclarations().length == 1) {
            NewLineEraser eraser = new NewLineEraser(grandParent);
            grandParent.delete();
            eraser.process();
            return;
        }
        element.delete();
    }

    private static void appendName(StringBuilder nameSequence, String name, JSQualifiedExpression reference) {
        if (reference instanceof JSReferenceExpression) {
            String refName = ((JSReferenceExpression)reference).getReferenceName();
            if (Objects.equals(refName, name)) {
                nameSequence.append(name);
            } else {
                nameSequence.append(refName).append(": ").append(name);
            }
        } else {
            nameSequence.append(name);
        }
    }

    private static boolean isComplexPattern(JSDestructuringContainer container) {
        boolean isComplex;
        block2: {
            block3: {
                isComplex = false;
                if (!(container instanceof JSDestructuringObject)) break block3;
                for (JSDestructuringProperty property : ((JSDestructuringObject)container).getProperties()) {
                    if (property.getDestructuringElement() instanceof JSVariable) continue;
                    isComplex = true;
                    break block2;
                }
                break block2;
            }
            if (!(container instanceof JSDestructuringArray)) break block2;
            for (JSElement element : ((JSDestructuringArray)container).getElementsWithRest()) {
                if (element instanceof JSVariable || element instanceof JSEmptyExpression) continue;
                isComplex = true;
                break;
            }
        }
        return isComplex;
    }

    protected static Kind validateRefs(Collection<PsiReference> references, MultiMap<Key, RefUsage> propNames, Project project, Editor editor, boolean reportErrors, PsiElement context) {
        boolean hasIndexers = false;
        boolean hasPropAccess = false;
        PsiFile contextFile = context.getContainingFile();
        for (PsiReference reference : references) {
            PsiElement fileContext;
            PsiElement element = reference.getElement();
            if (!(element instanceof JSReferenceExpression)) {
                JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.some.usages.cannot.be.updated.properly", (Object[])new Object[0]), reportErrors);
                return Kind.None;
            }
            PsiFile file = element.getContainingFile();
            if (file != contextFile && ((fileContext = file.getContext()) == null || fileContext.getContainingFile() != contextFile)) {
                JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.cannot.propagate.when.having.usages.declarations.in.different.files", (Object[])new Object[0]), reportErrors);
                return Kind.None;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpression && JSReadWriteAccessDetector.ourInstance.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
                JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.write.usages.cannot.be.updated.with.destructuring", (Object[])new Object[0]), reportErrors);
                return Kind.None;
            }
            if (parent instanceof JSIndexedPropertyAccessExpression) {
                if (!JSDestructuringPropagationIntentionBase.isValidIndexer((JSIndexedPropertyAccessExpression)parent)) {
                    JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.expression.indexed.by.non.numeric.value", (Object[])new Object[0]), reportErrors);
                    return Kind.None;
                }
                propNames.putValue((Object)Key.from((int)JSDestructuringPropagationIntentionBase.toDouble((JSLiteralExpression)Objects.requireNonNull(((JSIndexedPropertyAccessExpression)parent).getIndexExpression())), false), (Object)new RefUsage((JSQualifiedExpression)parent, null));
                hasIndexers = true;
                continue;
            }
            if (parent instanceof JSReferenceExpression) {
                propNames.putValue((Object)Key.from(((JSReferenceExpression)parent).getReferenceName(), false), (Object)new RefUsage((JSQualifiedExpression)parent, null));
                hasPropAccess = true;
                continue;
            }
            if (parent instanceof JSDestructuringElement) {
                int i;
                JSDestructuringContainer target = ((JSDestructuringElement)parent).getTarget();
                if (target instanceof JSDestructuringArray) {
                    hasIndexers = true;
                    JSElement[] elements = ((JSDestructuringArray)target).getElementsWithRest();
                    for (i = 0; i < elements.length; ++i) {
                        if (elements[i] instanceof JSEmptyExpression) continue;
                        propNames.putValue((Object)Key.from(i, elements[i] instanceof JSDestructuringArrayRestElement), (Object)new RefUsage(target));
                    }
                    continue;
                }
                if (target instanceof JSDestructuringObject) {
                    hasPropAccess = true;
                    JSDestructuringProperty[] jSDestructuringPropertyArray = ((JSDestructuringObject)target).getProperties();
                    i = jSDestructuringPropertyArray.length;
                    for (int j = 0; j < i; ++j) {
                        JSDestructuringProperty property = jSDestructuringPropertyArray[j];
                        propNames.putValue((Object)Key.from(JSDestructuringPropagationIntentionBase.getPropertyName(property), property.isRest()), (Object)new RefUsage(target));
                    }
                    continue;
                }
                JSDestructuringPropagationIntentionBase.showError(project, editor, target == null ? JavaScriptBundle.message((String)"dialog.message.incomplete.destructuring.pattern.encountered.in.code", (Object[])new Object[0]) : JavaScriptBundle.message((String)"dialog.message.unsupported.destructuring.container", (Object[])new Object[]{target.getClass().getName()}), reportErrors);
                return Kind.None;
            }
            JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.some.usages.cannot.be.updated.properly.wrong.access", (Object[])new Object[0]), reportErrors);
            return Kind.None;
        }
        if (hasIndexers == hasPropAccess) {
            if (hasIndexers) {
                JSDestructuringPropagationIntentionBase.showError(project, editor, JavaScriptBundle.message((String)"dialog.message.cannot.transform.object.array.destructuring.patterns.for.same.element", (Object[])new Object[0]), reportErrors);
            }
            return Kind.None;
        }
        if (!hasIndexers) {
            return Kind.Prop;
        }
        String tooComplexPatternError = JavaScriptBundle.message((String)"dialog.message.transforming.multiple.nested.patterns.not.supported", (Object[])new Object[0]);
        for (Map.Entry entry : propNames.entrySet()) {
            boolean hasComplexPattern = false;
            boolean hasNamedPattern = false;
            boolean hasInit = false;
            for (RefUsage usage : (Collection)entry.getValue()) {
                if (usage.container != null) {
                    if (JSDestructuringPropagationIntentionBase.isComplexPattern(usage.container)) {
                        if (hasInit || hasComplexPattern || hasNamedPattern) {
                            JSDestructuringPropagationIntentionBase.showError(project, editor, tooComplexPatternError, reportErrors);
                            return Kind.None;
                        }
                        hasComplexPattern = true;
                        continue;
                    }
                    if (hasComplexPattern) {
                        JSDestructuringPropagationIntentionBase.showError(project, editor, tooComplexPatternError, reportErrors);
                        return Kind.None;
                    }
                    hasInit = true;
                    continue;
                }
                if (usage.initializer != null) {
                    if (hasComplexPattern) {
                        JSDestructuringPropagationIntentionBase.showError(project, editor, tooComplexPatternError, reportErrors);
                        return Kind.None;
                    }
                    hasInit = true;
                }
                hasNamedPattern = true;
            }
        }
        return Kind.Index;
    }

    protected static String getPropertyName(JSDestructuringProperty property) {
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)property, (boolean)false);
        if (name != null) {
            return name;
        }
        ES6ComputedName computedName = property.getComputedPropertyName();
        return computedName == null ? "<anonymous>" : computedName.getText();
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getDescription();
        if (string == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getDescription();
        if (string == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    @IntentionName
    protected abstract String getDescription();

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(20);
        }
        if (element == null) {
            JSDestructuringPropagationIntentionBase.$$$reportNull$$$0(21);
        }
        return super.isAvailable(project, editor, element) && this.isAvailableOnElement(element, project, editor);
    }

    protected abstract boolean isAvailableOnElement(@NotNull PsiElement var1, Project var2, Editor var3);

    protected static boolean isAcceptableVariable(PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        if (element instanceof JSParameter && ((JSParameter)element).isRest()) {
            return false;
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)((JSParameter)element))) {
            return false;
        }
        PsiElement context = element.getContext();
        if (context instanceof JSDestructuringProperty && ((JSDestructuringProperty)context).isRest()) {
            return false;
        }
        if (context instanceof JSDestructuringArrayRestElement) {
            return false;
        }
        return !(context instanceof ES6FieldStatementImpl);
    }

    @Override
    protected void appendDestructuringInitializer(DoubleList indices, List<String> leftHandSides, List<Triple<String, String, String>> propertyData, StringBuilder destructuringString) {
    }

    @Override
    @Nullable
    protected JSExpression checkValidExpressionInValue(@Nullable JSExpression initializer) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVar";
                break;
            }
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedUnpleasantNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringPropagationIntentionBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringPropagationIntentionBase";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sortKeys";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeForVariable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startNamesTemplate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveToResult";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startRecursiveStep";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    protected static enum Kind {
        Index,
        Prop,
        None;

    }

    protected static final class Key {
        String stringKey;
        int numericKey;
        boolean isRest;

        private Key(String stringKey, int numericKey, boolean isRest) {
            this.stringKey = stringKey;
            this.numericKey = numericKey;
            this.isRest = isRest;
        }

        static Key from(int key, boolean isRest) {
            return new Key(null, key, isRest);
        }

        static Key from(String key, boolean isRest) {
            return new Key(key, -1, isRest);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.numericKey == key.numericKey && this.isRest == key.isRest && Objects.equals(this.stringKey, key.stringKey);
        }

        public int hashCode() {
            return Objects.hash(this.stringKey, this.numericKey, this.isRest);
        }

        public String toString() {
            return this.stringKey != null ? (this.isRest ? "..." + this.stringKey : this.stringKey) : String.valueOf(this.numericKey);
        }
    }

    private static final class RefUsage {
        JSQualifiedExpression reference;
        JSExpression initializer;
        JSDestructuringContainer container;

        private RefUsage(JSQualifiedExpression reference, JSExpression initializer) {
            this.reference = reference;
            this.initializer = initializer;
        }

        private RefUsage(JSDestructuringContainer container) {
            this.container = container;
        }
    }
}

