/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.jetbrains.ide.model.uiautomation.BeAlignment;
import com.jetbrains.ide.model.uiautomation.BeButton;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeListMenu;
import com.jetbrains.ide.model.uiautomation.BeTreeGridLine;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.views.listControl.renderers.RdCellRenderer;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J4\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JD\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/MenuListViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeListMenu;", "<init>", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createListContent", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "listItems", "Lcom/jetbrains/rd/util/reactive/IViewableList;", "menu", "enableInfiniteCycleScroll", "", "showChildPopup", "", "lt", "line", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGridLine;", "index", "", "mergingQueue", "Lcom/intellij/util/Alarm;", "parentList", "MenuListModel", "intellij.rd.ui"})
public final class MenuListViewControl
implements ViewBinder<BeListMenu> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeListMenu viewModel, @NotNull Lifetime lifetime) {
        JBList<BeControl> jBList;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        IMutableViewableList iMutableViewableList = viewModel.getMenuItems();
        Intrinsics.checkNotNull((Object)iMutableViewableList, (String)"null cannot be cast to non-null type com.jetbrains.rd.util.reactive.IViewableList<com.jetbrains.ide.model.uiautomation.BeControl>");
        JBList<BeControl> $this$bind_u24lambda_u240 = jBList = this.createListContent((IViewableList<? extends BeControl>)((IViewableList)iMutableViewableList), lifetime, viewModel, (Boolean)InterfacesKt.valueOrDefault((IOptProperty)viewModel.getInfiniteCycleScroll(), (Object)false));
        boolean bl = false;
        viewModel.getMenuItems().view(lifetime, (arg_0, arg_1, arg_2) -> MenuListViewControl.bind$lambda$0$0($this$bind_u24lambda_u240, arg_0, arg_1, arg_2));
        JBList<BeControl> list = jBList;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)list), (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    private final JBList<BeControl> createListContent(IViewableList<? extends BeControl> listItems, Lifetime lifetime, BeListMenu menu, boolean enableInfiniteCycleScroll) {
        Alarm mergingQueue = new Alarm();
        Alarm resizeQueue = new Alarm();
        Intrinsics.checkNotNull(listItems, (String)"null cannot be cast to non-null type com.jetbrains.rd.util.reactive.IViewableList<com.jetbrains.ide.model.uiautomation.BeTreeGridLine>");
        MenuListModel originalModel = new MenuListModel(lifetime, listItems);
        JBList jbList = new JBList((ListModel)originalModel);
        jbList.setVisibleRowCount(((Number)InterfacesKt.valueOrDefault((IOptProperty)menu.getVisibleRowsCount(), (Object)-1)).intValue());
        listItems.view(lifetime, (arg_0, arg_1, arg_2) -> MenuListViewControl.createListContent$lambda$0(resizeQueue, this, mergingQueue, jbList, enableInfiniteCycleScroll, menu, arg_0, arg_1, arg_2));
        Ref.ObjectRef previousSelectedLine = new Ref.ObjectRef();
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)jbList));
        jbList.getSelectionModel().addListSelectionListener(arg_0 -> MenuListViewControl.createListContent$lambda$1(jbList, previousSelectedLine, arg_0));
        RdCellRenderer treeTableCellRenderer = new RdCellRenderer(CollectionsKt.listOf((Object)BeAlignment.Stretch), false);
        jbList.setCellRenderer((ListCellRenderer)treeTableCellRenderer);
        MouseAdapter listener2 = new MouseAdapter((JBList<BeControl>)jbList, listItems){
            final /* synthetic */ JBList<BeControl> $jbList;
            final /* synthetic */ IViewableList<BeControl> $listItems;
            {
                this.$jbList = $jbList;
                this.$listItems = $listItems;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void mouseClicked(MouseEvent e) {
                if (e == null) {
                    return;
                }
                e.consume();
                int index = this.$jbList.locationToIndex(e.getPoint());
                Rectangle bounds = this.$jbList.getCellBounds(this.$jbList.locationToIndex(e.getPoint()), this.$jbList.locationToIndex(e.getPoint()));
                Object object = this.$listItems.get(index);
                if (!(object instanceof BeTreeGridLine)) return;
                BeTreeGridLine beTreeGridLine = (BeTreeGridLine)object;
                if (beTreeGridLine == null) {
                    return;
                }
                BeTreeGridLine line = beTreeGridLine;
                BeControl value2 = (BeControl)CollectionsKt.first((List)line.getColumnElements());
                Component rendererComponent = this.$jbList.getCellRenderer().getListCellRendererComponent((JList)this.$jbList, value2, index, false, false);
                Container container = (Container)this.$jbList;
                Intrinsics.checkNotNull((Object)rendererComponent);
                Intrinsics.checkNotNull((Object)bounds);
                JComponent elementUnderClick = SwingTreeUtilsKt.getDeepestRendererComponentByEvent(container, rendererComponent, bounds, e);
                if (elementUnderClick instanceof SimpleColoredComponent && ((SimpleColoredComponent)elementUnderClick).getIcon() != null) {
                    String string = ((SimpleColoredComponent)elementUnderClick).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    if (((CharSequence)string).length() == 0) {
                        Object beControl = ((SimpleColoredComponent)elementUnderClick).getClientProperty((Object)"BE_CONTROL");
                        if (!(beControl instanceof BeButton)) return;
                        ((BeButton)beControl).getAction().getClick().fire((Object)Unit.INSTANCE);
                        return;
                    }
                }
                line.getSignal().fire((Object)Unit.INSTANCE);
            }
        };
        jbList.addMouseListener((MouseListener)listener2);
        jbList.registerKeyboardAction(arg_0 -> MenuListViewControl.createListContent$lambda$2(jbList, arg_0), KeyStroke.getKeyStroke(10, 0), 0);
        AbstractAction childPopupAction2 = new AbstractAction((JBList<BeControl>)jbList){
            final /* synthetic */ JBList<BeControl> $jbList;
            {
                this.$jbList = $jbList;
            }

            public void actionPerformed(ActionEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Object object = this.$jbList.getSelectedValue();
                    BeTreeGridLine beTreeGridLine = object instanceof BeTreeGridLine ? (BeTreeGridLine)object : null;
                    if (beTreeGridLine == null) break block1;
                    BeTreeGridLine it = beTreeGridLine;
                    boolean bl = false;
                    BeButton first = (BeButton)SequencesKt.firstOrNull(BeGetterExtensionsKt.descendantsOfType((BeControl)it, BeButton.class));
                    BeButton beButton = first;
                    if (beButton != null && (beButton = beButton.getAction()) != null && (beButton = beButton.getClick()) != null) {
                        beButton.fire((Object)Unit.INSTANCE);
                    }
                }
            }
        };
        jbList.getActionMap().put("selectNextColumn", childPopupAction2);
        jbList.getActionMap().put("selectPreviousColumn", childPopupAction2);
        return jbList;
    }

    private final void showChildPopup(Lifetime lt, BeTreeGridLine line, int index, Alarm mergingQueue, JBList<?> parentList, boolean enableInfiniteCycleScroll, BeListMenu menu) {
        Ref.ObjectRef childPopup = new Ref.ObjectRef();
        mergingQueue.cancelAllRequests();
        mergingQueue.addRequest(() -> MenuListViewControl.showChildPopup$lambda$0(childPopup, parentList, index, this, line, lt, menu, enableInfiniteCycleScroll), 200);
    }

    private static final Unit bind$lambda$0$0(JBList $this_apply, Lifetime lifetime, int i, BeTreeGridLine line) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (((Boolean)line.isSelected().getValue()).booleanValue()) {
            $this_apply.setSelectedIndex(i);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createListContent$lambda$0$0(MenuListViewControl this$0, Lifetime $lt, BeTreeGridLine $line, int $i, Alarm $mergingQueue, JBList $jbList, boolean $enableInfiniteCycleScroll, BeListMenu $menu, boolean it) {
        if (it) {
            this$0.showChildPopup($lt, $line, $i, $mergingQueue, $jbList, $enableInfiniteCycleScroll, $menu);
        }
        return Unit.INSTANCE;
    }

    private static final void createListContent$lambda$0$1(JBList $jbList) {
        BeUtilKt.resizeParentPopup((JComponent)$jbList, true, true);
    }

    private static final Unit createListContent$lambda$0(Alarm $resizeQueue, MenuListViewControl this$0, Alarm $mergingQueue, JBList $jbList, boolean $enableInfiniteCycleScroll, BeListMenu $menu, Lifetime lt, int i, BeTreeGridLine control) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        BeTreeGridLine beTreeGridLine = control;
        if (beTreeGridLine == null) {
            return Unit.INSTANCE;
        }
        BeTreeGridLine line = beTreeGridLine;
        line.isExpanded().advise(lt, arg_0 -> MenuListViewControl.createListContent$lambda$0$0(this$0, lt, line, i, $mergingQueue, $jbList, $enableInfiniteCycleScroll, $menu, arg_0));
        $resizeQueue.cancelAllRequests();
        $resizeQueue.addRequest(() -> MenuListViewControl.createListContent$lambda$0$1($jbList), 200);
        return Unit.INSTANCE;
    }

    private static final void createListContent$lambda$1(JBList $jbList, Ref.ObjectRef $previousSelectedLine, ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object object = $jbList.getSelectedValue();
        BeTreeGridLine beTreeGridLine = object instanceof BeTreeGridLine ? (BeTreeGridLine)object : null;
        if (beTreeGridLine == null) {
            return;
        }
        BeTreeGridLine selectedLine = beTreeGridLine;
        if ($previousSelectedLine.element != null) {
            Object object2 = $previousSelectedLine.element;
            Intrinsics.checkNotNull((Object)object2);
            ((BeTreeGridLine)object2).isSelected().set((Object)false);
        }
        selectedLine.isSelected().set((Object)true);
        $previousSelectedLine.element = selectedLine;
    }

    private static final void createListContent$lambda$2(JBList $jbList, ActionEvent it) {
        block0: {
            Object object = $jbList.getSelectedValue();
            BeTreeGridLine beTreeGridLine = object instanceof BeTreeGridLine ? (BeTreeGridLine)object : null;
            if (beTreeGridLine == null || (beTreeGridLine = beTreeGridLine.getSignal()) == null) break block0;
            beTreeGridLine.fire((Object)Unit.INSTANCE);
        }
    }

    private static final Unit showChildPopup$lambda$0$2$0(BeTreeGridLine $line) {
        $line.isExpanded().setValue((Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit showChildPopup$lambda$0$3$0(boolean $it, Ref.ObjectRef $childPopup) {
        block1: {
            if ($it) break block1;
            JBPopup jBPopup = (JBPopup)$childPopup.element;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit showChildPopup$lambda$0$0(BeControl it) {
        block0: {
            BeTreeGridLine beTreeGridLine = it instanceof BeTreeGridLine ? (BeTreeGridLine)it : null;
            if (beTreeGridLine == null || (beTreeGridLine = beTreeGridLine.getSignal()) == null) break block0;
            beTreeGridLine.fire((Object)Unit.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    private static final void showChildPopup$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean showChildPopup$lambda$0$2(UpdateFlag $reentrancyCookie, BeTreeGridLine $line) {
        LocalChangeKt.ignoreOnReentrancy($reentrancyCookie, (Function0<Unit>)((Function0)() -> MenuListViewControl.showChildPopup$lambda$0$2$0($line)));
        return true;
    }

    private static final boolean showChildPopup$lambda$0$3(UpdateFlag $reentrancyCookie, Ref.ObjectRef $childPopup, boolean it) {
        LocalChangeKt.ignoreOnReentrancy($reentrancyCookie, (Function0<Unit>)((Function0)() -> MenuListViewControl.showChildPopup$lambda$0$3$0(it, $childPopup)));
        return !it;
    }

    private static final void showChildPopup$lambda$0(Ref.ObjectRef $childPopup, JBList $parentList, int $index, MenuListViewControl this$0, BeTreeGridLine $line, Lifetime $lt, BeListMenu $menu, boolean $enableInfiniteCycleScroll) {
        JBPopup jBPopup = (JBPopup)$childPopup.element;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        Point point = $parentList.indexToLocation($index);
        if (point == null) {
            return;
        }
        JBList<BeControl> subPopupJbList = this$0.createListContent((IViewableList<? extends BeControl>)((IViewableList)$line.getChildren()), $lt, $menu, $enableInfiniteCycleScroll);
        subPopupJbList.getActionMap().put("selectPreviousColumn", new AbstractAction((Ref.ObjectRef<JBPopup>)$childPopup){
            final /* synthetic */ Ref.ObjectRef<JBPopup> $childPopup;
            {
                this.$childPopup = $childPopup;
            }

            public void actionPerformed(ActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JBPopup jBPopup = (JBPopup)this.$childPopup.element;
                    if (jBPopup == null) break block0;
                    jBPopup.cancel();
                }
            }
        });
        SwingUtilities.convertPointToScreen(point, (Component)$parentList);
        UpdateFlag reentrancyCookie = new UpdateFlag();
        $childPopup.element = JBPopupFactory.getInstance().createListPopupBuilder((JList)subPopupJbList).setVisibleRowCount(subPopupJbList.getVisibleRowCount()).setResizable(false).setItemChosenCallback(arg_0 -> MenuListViewControl.showChildPopup$lambda$0$1(MenuListViewControl::showChildPopup$lambda$0$0, arg_0)).setCancelCallback(() -> MenuListViewControl.showChildPopup$lambda$0$2(reentrancyCookie, $line)).createPopup();
        if (!$parentList.isShowing() || $childPopup.element == null) {
            return;
        }
        int n = subPopupJbList.getInsets().top;
        Object object = $childPopup.element;
        Intrinsics.checkNotNull((Object)object);
        int topInsets = n + ((JBPopup)object).getContent().getInsets().top;
        int n2 = subPopupJbList.getInsets().left;
        Object object2 = $childPopup.element;
        Intrinsics.checkNotNull((Object)object2);
        int leftInsets = n2 + ((JBPopup)object2).getContent().getInsets().left;
        JBPopup jBPopup2 = (JBPopup)$childPopup.element;
        if (jBPopup2 != null) {
            jBPopup2.showInScreenCoordinates((Component)$parentList, new Point($parentList.getLocationOnScreen().x + $parentList.getWidth() + leftInsets, point.y - topInsets));
        }
        SourceExKt.adviseUntil((ISource)((ISource)$line.isExpanded()), (Lifetime)$lt, arg_0 -> MenuListViewControl.showChildPopup$lambda$0$3(reentrancyCookie, $childPopup, arg_0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/MenuListViewControl$MenuListModel;", "Ljavax/swing/AbstractListModel;", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "items", "Lcom/jetbrains/rd/util/reactive/IViewableList;", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGridLine;", "<init>", "(Lcom/jetbrains/rd/ui/bindable/views/MenuListViewControl;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IViewableList;)V", "getSize", "", "getElementAt", "index", "intellij.rd.ui"})
    private final class MenuListModel
    extends AbstractListModel<BeControl> {
        @NotNull
        private final IViewableList<BeTreeGridLine> items;

        public MenuListModel(@NotNull Lifetime lifetime, IViewableList<? extends BeTreeGridLine> items) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
            this.items.getChange().advise(lifetime, arg_0 -> MenuListModel._init_$lambda$0(this, arg_0));
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        @NotNull
        public BeControl getElementAt(int index) {
            return (BeControl)this.items.get(index);
        }

        private static final Unit _init_$lambda$0(MenuListModel this$0, IViewableList.Event it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IViewableList.Event event = it;
            if (event instanceof IViewableList.Event.Add) {
                this$0.fireIntervalAdded(this$0, ((IViewableList.Event.Add)it).getIndex(), ((IViewableList.Event.Add)it).getIndex());
            } else if (event instanceof IViewableList.Event.Update) {
                this$0.fireContentsChanged(this$0, ((IViewableList.Event.Update)it).getIndex(), ((IViewableList.Event.Update)it).getIndex());
            } else if (event instanceof IViewableList.Event.Remove) {
                this$0.fireIntervalRemoved(this$0, ((IViewableList.Event.Remove)it).getIndex(), ((IViewableList.Event.Remove)it).getIndex());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return Unit.INSTANCE;
        }
    }
}

