/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;

public class MavenModelBase
implements Serializable {
    private Properties myProperties;
    @NotNull
    private @NotNull List<@NotNull MavenPlugin> myPlugins;
    @NotNull
    private @NotNull List<@NotNull MavenArtifact> myExtensions;
    @NotNull
    private @NotNull List<@NotNull MavenArtifact> myDependencies;
    @NotNull
    private @NotNull List<@NotNull MavenArtifactNode> myDependencyTree;
    @NotNull
    private @NotNull List<@NotNull MavenRemoteRepository> myRemoteRepositories;
    @NotNull
    private @NotNull List<@NotNull MavenRemoteRepository> myRemotePluginRepositories;
    @NotNull
    private @NotNull List<@NotNull String> myModules;

    public MavenModelBase() {
        this.myPlugins = new CopyOnWriteArrayList<MavenPlugin>();
        this.myExtensions = new CopyOnWriteArrayList<MavenArtifact>();
        this.myDependencies = new CopyOnWriteArrayList<MavenArtifact>();
        this.myDependencyTree = new CopyOnWriteArrayList<MavenArtifactNode>();
        this.myRemoteRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>();
        this.myRemotePluginRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>();
        this.myModules = new CopyOnWriteArrayList<String>();
    }

    protected MavenModelBase(@NotNull MavenModelBase other) {
        if (other == null) {
            MavenModelBase.$$$reportNull$$$0(0);
        }
        this.myPlugins = new CopyOnWriteArrayList<MavenPlugin>();
        this.myExtensions = new CopyOnWriteArrayList<MavenArtifact>();
        this.myDependencies = new CopyOnWriteArrayList<MavenArtifact>();
        this.myDependencyTree = new CopyOnWriteArrayList<MavenArtifactNode>();
        this.myRemoteRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>();
        this.myRemotePluginRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>();
        this.myModules = new CopyOnWriteArrayList<String>();
        if (other.myProperties != null) {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)other.myProperties);
            this.myProperties = p;
        }
        this.myPlugins = new CopyOnWriteArrayList<MavenPlugin>(other.myPlugins);
        this.myExtensions = new CopyOnWriteArrayList<MavenArtifact>(other.myExtensions);
        this.myDependencies = new CopyOnWriteArrayList<MavenArtifact>(other.myDependencies);
        this.myDependencyTree = new CopyOnWriteArrayList<MavenArtifactNode>(other.myDependencyTree);
        this.myRemoteRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>(other.myRemoteRepositories);
        this.myRemotePluginRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>(other.myRemotePluginRepositories);
        this.myModules = new CopyOnWriteArrayList<String>(other.myModules);
    }

    public MavenModelBase copy() {
        return new MavenModelBase(this);
    }

    public Properties getProperties() {
        if (this.myProperties == null) {
            this.myProperties = new Properties();
        }
        return this.myProperties;
    }

    public void setProperties(Properties newProperties) {
        Properties properties = this.getProperties();
        properties.clear();
        if (null == newProperties) {
            return;
        }
        Enumeration<?> newPropertyNames = newProperties.propertyNames();
        while (newPropertyNames.hasMoreElements()) {
            String key = newPropertyNames.nextElement().toString();
            String value = newProperties.getProperty(key);
            properties.setProperty(key, value);
        }
    }

    public void setProperties(Map<String, String> newMap) {
        Properties newProperties = new Properties();
        newProperties.putAll(newMap);
        this.setProperties(newProperties);
    }

    @NotNull
    public @NotNull List<@NotNull MavenPlugin> getPlugins() {
        List<MavenPlugin> list = Collections.unmodifiableList(this.myPlugins);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setPlugins(@NotNull @NotNull List<@NotNull MavenPlugin> plugins) {
        if (plugins == null) {
            MavenModelBase.$$$reportNull$$$0(2);
        }
        this.myPlugins = new CopyOnWriteArrayList<MavenPlugin>(plugins);
    }

    @NotNull
    public @NotNull List<@NotNull MavenArtifact> getExtensions() {
        List<MavenArtifact> list = Collections.unmodifiableList(this.myExtensions);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setExtensions(@NotNull @NotNull List<@NotNull MavenArtifact> extensions) {
        if (extensions == null) {
            MavenModelBase.$$$reportNull$$$0(4);
        }
        this.myExtensions = new CopyOnWriteArrayList<MavenArtifact>(extensions);
    }

    @NotNull
    public @NotNull List<@NotNull MavenArtifact> getDependencies() {
        List<MavenArtifact> list = Collections.unmodifiableList(this.myDependencies);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setDependencies(@NotNull @NotNull List<@NotNull MavenArtifact> dependencies) {
        if (dependencies == null) {
            MavenModelBase.$$$reportNull$$$0(6);
        }
        this.myDependencies = new CopyOnWriteArrayList<MavenArtifact>(dependencies);
    }

    @NotNull
    public @NotNull List<@NotNull MavenArtifactNode> getDependencyTree() {
        List<MavenArtifactNode> list = Collections.unmodifiableList(this.myDependencyTree);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setDependencyTree(@NotNull @NotNull List<@NotNull MavenArtifactNode> dependencyTree) {
        if (dependencyTree == null) {
            MavenModelBase.$$$reportNull$$$0(8);
        }
        this.myDependencyTree = new CopyOnWriteArrayList<MavenArtifactNode>(dependencyTree);
    }

    @NotNull
    public @NotNull List<@NotNull MavenRemoteRepository> getRemoteRepositories() {
        List<MavenRemoteRepository> list = Collections.unmodifiableList(this.myRemoteRepositories);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void setRemoteRepositories(@NotNull @NotNull List<@NotNull MavenRemoteRepository> remoteRepositories) {
        if (remoteRepositories == null) {
            MavenModelBase.$$$reportNull$$$0(10);
        }
        this.myRemoteRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>(remoteRepositories);
    }

    @NotNull
    public @NotNull List<@NotNull MavenRemoteRepository> getRemotePluginRepositories() {
        List<MavenRemoteRepository> list = Collections.unmodifiableList(this.myRemotePluginRepositories);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setRemotePluginRepositories(@NotNull @NotNull List<@NotNull MavenRemoteRepository> remotePluginRepositories) {
        if (remotePluginRepositories == null) {
            MavenModelBase.$$$reportNull$$$0(12);
        }
        this.myRemotePluginRepositories = new CopyOnWriteArrayList<MavenRemoteRepository>(remotePluginRepositories);
    }

    @NotNull
    public @NotNull List<@NotNull String> getModules() {
        List<String> list = Collections.unmodifiableList(this.myModules);
        if (list == null) {
            MavenModelBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setModules(@NotNull @NotNull List<@NotNull String> modules) {
        if (modules == null) {
            MavenModelBase.$$$reportNull$$$0(14);
        }
        this.myModules = new CopyOnWriteArrayList<String>(modules);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/model/MavenModelBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePluginRepositories";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/model/MavenModelBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePluginRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setExtensions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDependencyTree";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteRepositories";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRemotePluginRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

