/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerComposeStatus;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.docker.runtimes.presentation.api.DockerRuntimePresentationInterface;
import com.intellij.docker.runtimes.presentation.api.Presentable;
import com.intellij.execution.services.ServiceViewItemState;
import com.intellij.ide.projectView.PresentationData;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/runtimes/ComposePresentableDelegate;", "Lcom/intellij/docker/runtimes/presentation/api/Presentable;", "runtime", "Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;", "<init>", "(Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;)V", "getNodePresentation", "Lcom/intellij/ide/projectView/PresentationData;", "state", "Lcom/intellij/execution/services/ServiceViewItemState;", "intellij.clouds.docker.shared"})
public final class ComposePresentableDelegate
implements Presentable {
    @NotNull
    private final DockerRuntimePresentationInterface runtime;

    public ComposePresentableDelegate(@NotNull DockerRuntimePresentationInterface runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
    }

    @Override
    @NotNull
    public PresentationData getNodePresentation(@NotNull ServiceViewItemState state) {
        String description;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PresentationData data = new PresentationData();
        DockerStatus dockerStatus = this.runtime.getStatus();
        DockerComposeStatus dockerComposeStatus = dockerStatus instanceof DockerComposeStatus ? (DockerComposeStatus)dockerStatus : null;
        ComposeServiceStatus composeStatus = dockerComposeStatus != null ? dockerComposeStatus.getStatus() : null;
        data.setIcon(this.runtime.getStatus().getIcon());
        data.setPresentableText(this.runtime.getPresentableName());
        data.setTooltip(this.runtime.getStatus().getText().get());
        Supplier<String> supplier = this.runtime.getStatus().getDescription();
        String string = description = supplier != null ? supplier.get() : null;
        if (description != null) {
            if ((composeStatus == ComposeServiceStatus.HEALTHY || composeStatus == ComposeServiceStatus.UNHEALTHY) && state.getExpanded()) {
                data.setLocationString(null);
            } else {
                data.setLocationString(description);
            }
        }
        return data;
    }
}

