/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6KeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    public ES6KeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, (JSHighlighter)new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(DialectOptionHolder.JS_WITH_JSX));
    }

    public ES6KeywordHighlighterVisitor(HighlightInfoHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    @Override
    public void visitJSForInStatement(@NotNull JSForInStatement element2) {
        if (element2 == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.OF_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSForInStatement(element2);
    }

    public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
        if (exportDeclaration == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        this.highlightChildKeywordOfType((PsiElement)exportDeclaration, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.highlightChildKeywordOfType((PsiElement)importDeclaration, JSTokenTypes.TYPE_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)importDeclaration, JSTokenTypes.DEFER_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)importDeclaration, JSTokenTypes.SOURCE_KEYWORD);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression element2) {
        if (element2 == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSPrefixExpression(element2);
    }

    @Override
    public void visitJSAttributeList(@NotNull JSAttributeList element2) {
        if (element2 == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.ASYNC_KEYWORD);
        super.visitJSAttributeList(element2);
    }

    public void visitES6Decorator(@NotNull ES6Decorator decorator) {
        PsiElement element2;
        JSExpression expression;
        ASTNode at;
        if (decorator == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        if ((at = decorator.getNode().findChildByType(JSTokenTypes.AT)) != null) {
            this.lineMarker(at.getPsi(), this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR), "decorator");
        }
        if ((expression = decorator.getExpression()) instanceof JSCallExpression) {
            expression = ((JSCallExpression)expression).getMethodExpression();
        }
        if (expression instanceof JSReferenceExpression && (element2 = ((JSReferenceExpression)expression).getReferenceNameElement()) != null) {
            this.lineMarker(element2, this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR), "decorator");
        }
        super.visitES6Decorator(decorator);
    }

    public void visitTypeScriptSingleType(@NotNull TypeScriptSingleType singleType) {
        JSReferenceExpression referenceExpression;
        JSReferenceExpression parent;
        ASTNode node;
        ASTNode keyword;
        if (singleType == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        if ((keyword = (node = (parent = (referenceExpression = singleType.getReferenceExpression()) != null ? referenceExpression : singleType).getNode()).findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter)) != null) {
            TextAttributesKey key = this.annotatePrimitiveType(keyword);
            this.myHolder.add(ES6KeywordHighlighterVisitor.highlightKeyword(keyword, key));
        }
        super.visitTypeScriptSingleType(singleType);
    }

    @NotNull
    protected TextAttributesKey annotatePrimitiveType(ASTNode keyword) {
        TextAttributesKey textAttributesKey = JSHighlighter.JS_PRIMITIVE_TYPE;
        if (textAttributesKey == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        return textAttributesKey;
    }

    public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
        if (varStatement == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        this.highlightChildKeywordOfType((PsiElement)varStatement, JSTokenTypes.USING_KEYWORD);
        super.visitJSVarStatement(varStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/ES6KeywordHighlighterVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/ES6KeywordHighlighterVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatePrimitiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForInStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitES6Decorator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptSingleType";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVarStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

