/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.liveTemplates;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/liveTemplates/JSAutoImportsOptionProcessor;", "Lcom/intellij/codeInsight/template/impl/TemplateOptionalProcessor;", "<init>", "()V", "processText", "", "project", "Lcom/intellij/openapi/project/Project;", "template", "Lcom/intellij/codeInsight/template/Template;", "document", "Lcom/intellij/openapi/editor/Document;", "templateRange", "Lcom/intellij/openapi/editor/RangeMarker;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOptionName", "", "setEnabled", "value", "", "isEnabled", "isVisible", "context", "Lcom/intellij/codeInsight/template/impl/TemplateContext;", "intellij.javascript.backend"})
public final class JSAutoImportsOptionProcessor
implements TemplateOptionalProcessor {
    public void processText(@NotNull Project project, @NotNull Template template, @NotNull Document document, @NotNull RangeMarker templateRange, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)templateRange, (String)"templateRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            return;
        }
        TextRange textRange = templateRange.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        JSimportUtilKt.applyUnambiguousImportsAsync(project, textRange, document, editor);
    }

    @NotNull
    public String getOptionName() {
        String string = JavaScriptBundle.message((String)"template.add.imports", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void setEnabled(@NotNull Template template, boolean value) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, value);
    }

    public boolean isEnabled(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        return template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE);
    }

    public boolean isVisible(@NotNull Template template, @NotNull TemplateContext context2) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (TemplateContextType contextType : TemplateContextTypes.getAllContextTypes()) {
            if (!context2.isEnabled(contextType) || !JSMacroUtil.isJSLikeContext(contextType)) continue;
            return true;
        }
        return false;
    }
}

