/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.StatusText;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable {
    private static final int IGNORE_CODE = -1;
    @NotNull
    protected final Project myProject;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    @Nullable
    protected volatile ToolWindow myToolWindow;
    @NotNull
    protected final String myHelpId;
    @NlsContexts.TabTitle
    @NotNull
    private final String myToolWindowName;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NlsContexts.TabTitle @NotNull String toolWindowName, @NotNull String helpId) {
        if (project == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        if (toolWindowName == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        if (helpId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public synchronized void init() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myInitialized || this.myToolWindow == null) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.getToolWindow(this.myToolWindowName);
            if (toolWindow == null && !ApplicationManager.getApplication().isUnitTestMode()) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Tool window with id " + this.myToolWindowName + " isn't registered");
                this.myInitialized = true;
                return;
            }
            this.myToolWindow = toolWindow;
            this.myInitialized = true;
            JSLanguageServiceQueue.Holder.LOGGER.debug("Initialized tool window " + this.myToolWindowName);
            this.initDefaultPanels(toolWindow);
        }
    }

    protected void initDefaultPanels(ToolWindow toolWindow) {
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getProjectErrorsTitle() {
        String string = JavaScriptBundle.message((String)"tab.title.project.errors", (Object[])new Object[0]);
        if (string == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        NewErrorTreeViewPanel panel2 = this.myProjectErrorTreeViewPanel;
        if (panel2 != null) {
            return panel2;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            this.init();
            toolWindow = this.myToolWindow;
        }
        if (toolWindow == null) {
            return null;
        }
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createProjectErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getProjectErrorsTitle(), false);
        contentImpl.setHelpId(this.myHelpId);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createProjectErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        return new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
    }

    public void logProjectErrors(@NotNull List<JSAnnotationError> results, boolean setActive) {
        NewErrorTreeViewPanel panel2;
        if (results == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        if ((panel2 = this.createProjectErrorsPanel()) == null) {
            return;
        }
        this.logErrorsImpl(panel2, results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel2, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel2, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel2) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    private void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, @NotNull List<JSAnnotationError> list) {
        if (list == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(5);
        }
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (int i = 0; i < list.size(); ++i) {
            int category;
            JSAnnotationError compilerResult = list.get(i);
            String path2 = compilerResult.getAbsoluteFilePath();
            VirtualFile file = null;
            if (path2 != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
            }
            if ((category = JSLanguageServiceToolWindowManager.parseCategory(compilerResult)) == -1) continue;
            this.doAddMessage(errorTreeViewPanel, compilerResult, file, category);
        }
        errorTreeViewPanel.updateTree();
    }

    private static int parseCategory(@NotNull JSAnnotationError compilerResult) {
        String category;
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(6);
        }
        if ((category = compilerResult.getCategory()) == null) {
            return 4;
        }
        return switch (StringUtil.toLowerCase((String)category)) {
            case "info", "suggestion" -> 3;
            case "warning" -> 5;
            default -> 4;
        };
    }

    protected void doAddMessage(@NotNull NewErrorTreeViewPanel errorTreeViewPanel, @NotNull JSAnnotationError compilerResult, @Nullable VirtualFile file, int category) {
        if (errorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(7);
        }
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(8);
        }
        String description = StringUtil.notNullize((String)compilerResult.getDescription());
        String[] messages = description.split("\n");
        errorTreeViewPanel.addMessage(category, messages, file, compilerResult.getLine(), compilerResult.getColumn(), null);
    }

    public synchronized void dispose() {
        this.resetToolWindow();
    }

    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel2) {
        if (panel2 == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        JSLanguageServiceToolWindowManager.setNotStartedText(panel2);
    }

    private static void setNotStartedText(@NotNull NewErrorTreeViewPanel panel2) {
        if (panel2 == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(10);
        }
        StatusText text = panel2.getEmptyText();
        text.clear();
        text.setText(JavaScriptBundle.message((String)"javascript.language.service.tracking.is.not.started", (Object[])new Object[0]));
    }

    public synchronized void resetToolWindow() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ThreadingAssertions.assertEventDispatchThread();
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
    }

    @Nullable
    public ErrorTreeElement getSelectedElement() {
        JComponent contentComponent;
        Content selectedContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null && (selectedContent = toolWindow.getContentManager().getSelectedContent()) != null && (contentComponent = selectedContent.getComponent()) instanceof JSLanguageServiceErrorTreeViewPanel) {
            return ((JSLanguageServiceErrorTreeViewPanel)((Object)contentComponent)).getSelectedErrorTreeElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTreeViewPanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logProjectErrors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logErrorsImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseCategory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNotStartedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

