/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.util.text.CharSequenceSubSequence;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\u000b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0007\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\t*\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\t*\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0002\u00a8\u0006\u0010"}, d2={"stringHashCode", "", "", "from", "to", "prefixHash", "", "stringHashCodeIgnoreWhitespaces", "equalsIgnoreWhitespaces", "", "other", "equalsTrimWhitespaces", "trimWhitespace", "isSpaceEnterOrTab", "", "equalsByContents", "intellij.platform.util.base.multiplatform"})
@ApiStatus.Experimental
@JvmName(name="StringsKmp")
public final class StringsKmp {
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode) {
        Intrinsics.checkNotNullParameter($this$stringHashCode, "<this>");
        if ($this$stringHashCode instanceof String || $this$stringHashCode instanceof CharSequenceWithStringHash) {
            return $this$stringHashCode.hashCode();
        }
        return StringsKmp.stringHashCode$default($this$stringHashCode, 0, $this$stringHashCode.length(), 0, 4, null);
    }

    @JvmOverloads
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode, int from, int to, int prefixHash) {
        Intrinsics.checkNotNullParameter($this$stringHashCode, "<this>");
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + $this$stringHashCode.charAt(off);
        }
        return h;
    }

    public static /* synthetic */ int stringHashCode$default(CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return StringsKmp.stringHashCode(charSequence, n, n2, n3);
    }

    @Contract(pure=true)
    public static final int stringHashCode(@NotNull char[] $this$stringHashCode, int from, int to) {
        Intrinsics.checkNotNullParameter($this$stringHashCode, "<this>");
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + $this$stringHashCode[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static final int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence $this$stringHashCodeIgnoreWhitespaces) {
        Intrinsics.checkNotNullParameter($this$stringHashCodeIgnoreWhitespaces, "<this>");
        int h = 0;
        int n = $this$stringHashCodeIgnoreWhitespaces.length();
        for (int off = 0; off < n; ++off) {
            char c = $this$stringHashCodeIgnoreWhitespaces.charAt(off);
            if (StringsKmp.isSpaceEnterOrTab(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static final boolean equalsIgnoreWhitespaces(@NotNull CharSequence $this$equalsIgnoreWhitespaces, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter($this$equalsIgnoreWhitespaces, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        int len1 = $this$equalsIgnoreWhitespaces.length();
        int len2 = other.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if ($this$equalsIgnoreWhitespaces.charAt(index1) == other.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringsKmp.isSpaceEnterOrTab($this$equalsIgnoreWhitespaces.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringsKmp.isSpaceEnterOrTab(other.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringsKmp.isSpaceEnterOrTab($this$equalsIgnoreWhitespaces.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringsKmp.isSpaceEnterOrTab(other.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static final boolean equalsTrimWhitespaces(@NotNull CharSequence $this$equalsTrimWhitespaces, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter($this$equalsTrimWhitespaces, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return StringsKmp.equalsByContents(StringsKmp.trimWhitespace($this$equalsTrimWhitespaces), StringsKmp.trimWhitespace(other));
    }

    private static final CharSequence trimWhitespace(CharSequence $this$trimWhitespace) {
        char c;
        int start;
        int end = $this$trimWhitespace.length();
        for (start = 0; start < end && StringsKmp.isSpaceEnterOrTab(c = $this$trimWhitespace.charAt(start)); ++start) {
        }
        while (start < end && StringsKmp.isSpaceEnterOrTab(c = $this$trimWhitespace.charAt(end - 1))) {
            --end;
        }
        return new CharSequenceSubSequence($this$trimWhitespace, start, end);
    }

    private static final boolean isSpaceEnterOrTab(char $this$isSpaceEnterOrTab) {
        return $this$isSpaceEnterOrTab == '\n' || $this$isSpaceEnterOrTab == '\t' || $this$isSpaceEnterOrTab == ' ';
    }

    private static final boolean equalsByContents(CharSequence $this$equalsByContents, CharSequence other) {
        if ($this$equalsByContents == other) {
            return true;
        }
        if ($this$equalsByContents == null || other == null) {
            return false;
        }
        if ($this$equalsByContents.length() != other.length()) {
            return false;
        }
        int n = $this$equalsByContents.length();
        for (int i = 0; i < n; ++i) {
            if ($this$equalsByContents.charAt(i) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @JvmOverloads
    @Contract(pure=true)
    public static final int stringHashCode(@NotNull CharSequence $this$stringHashCode, int from, int to) {
        Intrinsics.checkNotNullParameter($this$stringHashCode, "<this>");
        return StringsKmp.stringHashCode$default($this$stringHashCode, from, to, 0, 4, null);
    }
}

