/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.proxy.handlers;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.kotlin.jupyter.debug.proxy.JdiProxyApiDelegate;
import com.intellij.kotlin.jupyter.debug.proxy.JdiProxyInvocationHandlerProvider;
import com.intellij.kotlin.jupyter.debug.proxy.context.DebugValueContext;
import com.intellij.kotlin.jupyter.debug.proxy.handlers.JdiProxyInvocationHandler;
import com.intellij.kotlin.jupyter.debug.util.TypeUtilsKt;
import com.sun.jdi.ObjectReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J4\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/JdiProxyDelegatingInvocationHandler;", "Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/JdiProxyInvocationHandler;", "valueContext", "Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;", "<init>", "(Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;)V", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "objectReference", "Lcom/sun/jdi/ObjectReference;", "getObjectReference", "()Lcom/sun/jdi/ObjectReference;", "extensionDelegate", "Lcom/intellij/kotlin/jupyter/debug/proxy/JdiProxyApiDelegate;", "isApplicable", "", "obj", "", "method", "Ljava/lang/reflect/Method;", "invoke", "proxy", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "intellij.kotlin.jupyter.debug"})
public final class JdiProxyDelegatingInvocationHandler
implements JdiProxyInvocationHandler {
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final ObjectReference objectReference;
    @Nullable
    private final JdiProxyApiDelegate extensionDelegate;

    public JdiProxyDelegatingInvocationHandler(@NotNull DebugValueContext valueContext) {
        Intrinsics.checkNotNullParameter((Object)valueContext, (String)"valueContext");
        this.debugProcess = valueContext.getDebugProcess();
        this.objectReference = valueContext.getObjectReference();
        this.extensionDelegate = JdiProxyInvocationHandlerProvider.Companion.findInvocationHandlerDelegateForReference(valueContext);
    }

    @Override
    @NotNull
    public DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    @Override
    @NotNull
    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    @Override
    public boolean isApplicable(@NotNull Object obj, @NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Class<?> declaringClass = method.getDeclaringClass();
        Intrinsics.checkNotNull(declaringClass);
        return !TypeUtilsKt.isTopType(declaringClass) && declaringClass.isInstance(this.extensionDelegate);
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object[] objectArray = args;
        if (args == null) {
            objectArray = new Object[]{};
        }
        Object[] objectArray2 = objectArray;
        return method.invoke((Object)this.extensionDelegate, Arrays.copyOf(objectArray2, objectArray2.length));
    }
}

