/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.session;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.execution.util.FilesKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinKernelVersionsKt;
import com.intellij.kotlin.jupyter.core.util.NotebookProjectLevelService;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookFileDebugSession;
import com.intellij.kotlin.jupyter.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.debug.util.connection.DebugConnectionUtility;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.startup.PortsGenerator;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0006H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager;", "Lcom/intellij/kotlin/jupyter/core/util/NotebookProjectLevelService;", "Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookFileDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "portsGenerator", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/PortsGenerator;", "nextTargetDebugPortOrNullFor", "", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)Ljava/lang/Integer;", "hasAnyXDebugSession", "", "getHasAnyXDebugSession", "()Z", "hasAnyAttachedProcess", "getHasAnyAttachedProcess", "getByDebugProcessOrNull", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "getByPath", "path", "Ljava/nio/file/Path;", "createInstance", "virtualFile", "fileScope", "Companion", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookDebugSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,80:1\n193#2,3:81\n193#2,3:84\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager\n*L\n39#1:81,3\n45#1:84,3\n*E\n"})
public final class KotlinNotebookDebugSessionManager
extends NotebookProjectLevelService<KotlinNotebookFileDebugSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PortsGenerator portsGenerator;

    public KotlinNotebookDebugSessionManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
        this.portsGenerator = DebugConnectionUtility.INSTANCE.getDebugPortsGenerator();
    }

    private final Integer nextTargetDebugPortOrNullFor(BackedNotebookVirtualFile file) {
        if (!DebugSupportUtilsKt.debugFeaturesSupported(file, this.getProject())) {
            return null;
        }
        boolean isSuitable = KotlinKernelVersionsKt.isKernelVersionEnoughForInstrumentation((Project)this.getProject());
        return isSuitable && !ApplicationManager.getApplication().isUnitTestMode() ? Integer.valueOf(this.portsGenerator.randomPort()) : null;
    }

    public final boolean getHasAnyXDebugSession() {
        boolean bl;
        block3: {
            Map $this$any$iv = this.getMapping();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!((KotlinNotebookFileDebugSession)((Object)it.getValue())).isLiveSession()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasAnyAttachedProcess() {
        boolean bl;
        block3: {
            Map $this$any$iv = this.getMapping();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    DebuggerSession debuggerSession = ((KotlinNotebookFileDebugSession)((Object)it.getValue())).getDebuggerSession();
                    boolean bl3 = debuggerSession != null && (debuggerSession = debuggerSession.getProcess()) != null ? debuggerSession.isAttached() : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final KotlinNotebookFileDebugSession getByDebugProcessOrNull(@Nullable DebugProcess debugProcess) {
        KotlinNotebookFileDebugSession kotlinNotebookFileDebugSession;
        block2: {
            if (debugProcess == null) {
                return null;
            }
            for (Map.Entry it : this.getMapping().entrySet()) {
                boolean bl = false;
                DebuggerSession debuggerSession = ((KotlinNotebookFileDebugSession)((Object)it.getValue())).getDebuggerSession();
                KotlinNotebookFileDebugSession kotlinNotebookFileDebugSession2 = Intrinsics.areEqual((Object)(debuggerSession != null ? debuggerSession.getProcess() : null), (Object)debugProcess) ? (KotlinNotebookFileDebugSession)((Object)it.getValue()) : null;
                if (kotlinNotebookFileDebugSession2 == null) continue;
                kotlinNotebookFileDebugSession = kotlinNotebookFileDebugSession2;
                break block2;
            }
            kotlinNotebookFileDebugSession = null;
        }
        return kotlinNotebookFileDebugSession;
    }

    @Nullable
    public final KotlinNotebookFileDebugSession getByPath(@NotNull Path path) {
        KotlinNotebookFileDebugSession kotlinNotebookFileDebugSession;
        KotlinNotebookFileDebugSession existingSession;
        block4: {
            KotlinNotebookFileDebugSession kotlinNotebookFileDebugSession2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            for (Map.Entry it : this.getMapping().entrySet()) {
                boolean bl = false;
                KotlinNotebookFileDebugSession kotlinNotebookFileDebugSession3 = Intrinsics.areEqual((Object)((VirtualFile)it.getKey()).getPath(), (Object)((Object)path).toString()) ? (KotlinNotebookFileDebugSession)((Object)it.getValue()) : null;
                if (kotlinNotebookFileDebugSession3 == null) continue;
                kotlinNotebookFileDebugSession2 = kotlinNotebookFileDebugSession3;
                break block4;
            }
            kotlinNotebookFileDebugSession2 = existingSession = null;
        }
        if (existingSession == null) {
            BackedNotebookVirtualFile backedNotebookVirtualFile = FilesKt.findNotebookVirtualFileByPath((Path)path);
            if (backedNotebookVirtualFile == null) {
                return null;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
            kotlinNotebookFileDebugSession = (KotlinNotebookFileDebugSession)this.getOrCreate(backedNotebookVirtualFile2);
        } else {
            kotlinNotebookFileDebugSession = existingSession;
        }
        return kotlinNotebookFileDebugSession;
    }

    @NotNull
    protected KotlinNotebookFileDebugSession createInstance(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull CoroutineScope fileScope) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)fileScope, (String)"fileScope");
        return new KotlinNotebookFileDebugSession(virtualFile, this.getProject(), fileScope, (Function0<Integer>)((Function0)() -> KotlinNotebookDebugSessionManager.createInstance$lambda$0(this, virtualFile)));
    }

    private static final Integer createInstance$lambda$0(KotlinNotebookDebugSessionManager this$0, BackedNotebookVirtualFile $virtualFile) {
        return this$0.nextTargetDebugPortOrNullFor($virtualFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "getForFile", "Lcom/intellij/kotlin/jupyter/debug/session/KotlinNotebookFileDebugSession;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.kotlin.jupyter.debug"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookDebugSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/debug/session/KotlinNotebookDebugSessionManager$Companion\n*L\n74#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookDebugSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinNotebookDebugSessionManager> serviceClass$iv = KotlinNotebookDebugSessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinNotebookDebugSessionManager)((Object)object);
        }

        @NotNull
        public final KotlinNotebookFileDebugSession getForFile(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return (KotlinNotebookFileDebugSession)this.getInstance(project).getOrCreate(virtualFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

