/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssColorMixFunction;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.color.ColorSpace;
import com.intellij.psi.css.impl.util.color.CssColor;
import com.intellij.psi.css.impl.util.color.CssColorInterpolationUtilKt;
import com.intellij.psi.css.impl.util.color.HueInterpolationMethod;
import com.intellij.util.MathUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a5\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"getColorInColorMixFunction", "Lcom/intellij/psi/css/impl/util/color/CssColor;", "termList", "Lcom/intellij/psi/css/CssTermList;", "normalizePercentages", "Lkotlin/Triple;", "", "left", "right", "(Ljava/lang/Double;Ljava/lang/Double;)Lkotlin/Triple;", "resolveTerms", "Lcom/intellij/psi/css/impl/util/CssColorMixFunction;", "intellij.css.common"})
public final class CssColorMixUtilKt {
    @Nullable
    public static final CssColor getColorInColorMixFunction(@NotNull CssTermList termList) {
        Intrinsics.checkNotNullParameter((Object)termList, (String)"termList");
        CssColorMixFunction cssColorMixFunction = CssColorMixUtilKt.resolveTerms(termList);
        if (cssColorMixFunction == null) {
            return null;
        }
        CssColorMixFunction cssColorMixFunction2 = cssColorMixFunction;
        Triple<Double, Double, Double> triple = CssColorMixUtilKt.normalizePercentages(cssColorMixFunction2.getResolvedLeftPercentage(), cssColorMixFunction2.getResolvedRightPercentage());
        if (triple == null) {
            return null;
        }
        Triple<Double, Double, Double> triple2 = triple;
        double leftPercentage = ((Number)triple2.component1()).doubleValue();
        double rightPercentage = ((Number)triple2.component2()).doubleValue();
        double alphaMultiplier = ((Number)triple2.component3()).doubleValue();
        CssColor result = CssColorInterpolationUtilKt.interpolateColors(cssColorMixFunction2.getColorSpace(), cssColorMixFunction2.getLeftColor(), cssColorMixFunction2.getRightColor(), leftPercentage, rightPercentage, cssColorMixFunction2.getInterpolationMethod());
        Double d = result.getAlpha();
        result.setAlpha((d != null ? d : 0.0) * alphaMultiplier);
        return result;
    }

    private static final Triple<Double, Double, Double> normalizePercentages(Double left, Double right) {
        Pair pair;
        double alphaMultiplier = 1.0;
        if (left == null && right == null) {
            pair = new Pair((Object)0.5, (Object)0.5);
        } else if (left == null && right != null) {
            pair = new Pair((Object)(1.0 - right), (Object)right);
        } else if (left != null && right == null) {
            pair = new Pair((Object)left, (Object)(1.0 - left));
        } else {
            Double d = left;
            Intrinsics.checkNotNull((Object)d);
            Double d2 = right;
            Intrinsics.checkNotNull((Object)d2);
            pair = new Pair((Object)d, (Object)d2);
        }
        Pair pair2 = pair;
        double leftPercentage = ((Number)pair2.component1()).doubleValue();
        double rightPercentage = ((Number)pair2.component2()).doubleValue();
        if (MathUtil.compare((double)(leftPercentage + rightPercentage), (double)0.0, (double)1.0E-4) == 0) {
            return null;
        }
        int comparison = MathUtil.compare((double)(leftPercentage + rightPercentage), (double)1.0, (double)1.0E-4);
        if (comparison != 0) {
            if (comparison < 0) {
                alphaMultiplier = leftPercentage + rightPercentage;
            }
            double leftTemp = leftPercentage;
            leftPercentage /= leftPercentage + rightPercentage;
            rightPercentage /= leftTemp + rightPercentage;
        }
        return new Triple((Object)leftPercentage, (Object)rightPercentage, (Object)alphaMultiplier);
    }

    private static final CssColorMixFunction resolveTerms(CssTermList termList) {
        Double d;
        CssTermType cssTermType;
        CssTermType cssTermType2;
        CssTermType cssTermType3;
        if (termList.getTerms().length < 4) {
            return null;
        }
        Ref.IntRef i = new Ref.IntRef();
        if (!Intrinsics.areEqual((Object)CssColorMixUtilKt.resolveTerms$getNext(termList, i).getText(), (Object)"in")) {
            return null;
        }
        String string = CssColorMixUtilKt.resolveTerms$getNext(termList, i).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        ColorSpace colorSpace = ColorSpace.Companion.fromText(string);
        if (colorSpace == null) {
            return null;
        }
        ColorSpace colorSpace2 = colorSpace;
        HueInterpolationMethod interpolationMethod = HueInterpolationMethod.SHORTER;
        CssTerm leftColorTerm = null;
        CssTerm cssTerm = CssColorMixUtilKt.resolveTerms$peek(i, termList);
        Object object = cssTermType3 = cssTerm != null ? cssTerm.getTermType() : null;
        if (Intrinsics.areEqual((Object)cssTermType3, (Object)CssTermTypes.IDENT)) {
            HueInterpolationMethod hueInterpolationMethod = HueInterpolationMethod.Companion.fromTermSafe(CssColorMixUtilKt.resolveTerms$getNext(termList, i));
            if (hueInterpolationMethod == null) {
                return null;
            }
            interpolationMethod = hueInterpolationMethod;
            if (!Intrinsics.areEqual((Object)CssColorMixUtilKt.resolveTerms$getNext(termList, i).getText(), (Object)"hue")) {
                return null;
            }
            if (!colorSpace2.isPolar()) {
                return null;
            }
            CssTerm cssTerm2 = CssColorMixUtilKt.resolveTerms$peek(i, termList);
            if (!Intrinsics.areEqual((Object)(cssTerm2 != null ? cssTerm2.getTermType() : null), (Object)CssTermTypes.COLOR)) {
                return null;
            }
            leftColorTerm = CssColorMixUtilKt.resolveTerms$getNext(termList, i);
        } else if (Intrinsics.areEqual((Object)cssTermType3, (Object)CssTermTypes.COLOR)) {
            leftColorTerm = CssColorMixUtilKt.resolveTerms$getNext(termList, i);
        } else {
            return null;
        }
        CssColor cssColor = CssPsiColorUtil.getColorInClassicCss((PsiElement)leftColorTerm);
        if (cssColor == null) {
            return null;
        }
        CssColor leftColor = cssColor;
        Double resolvedLeftPercentage = null;
        CssTerm rightColorTerm = null;
        CssTerm cssTerm3 = CssColorMixUtilKt.resolveTerms$peek(i, termList);
        Object object2 = cssTermType2 = cssTerm3 != null ? cssTerm3.getTermType() : null;
        if (Intrinsics.areEqual((Object)cssTermType2, (Object)CssTermTypes.COLOR)) {
            rightColorTerm = CssColorMixUtilKt.resolveTerms$getNext(termList, i);
        } else if (Intrinsics.areEqual((Object)cssTermType2, (Object)CssTermTypes.PERCENTAGE)) {
            resolvedLeftPercentage = CssPsiColorUtil.getNonClampingPercentageValue(CssColorMixUtilKt.resolveTerms$getNext(termList, i).getText());
            if (Intrinsics.areEqual((Double)resolvedLeftPercentage, (double)-1.0)) {
                return null;
            }
            CssTerm cssTerm4 = CssColorMixUtilKt.resolveTerms$peek(i, termList);
            if (!Intrinsics.areEqual((Object)(cssTerm4 != null ? cssTerm4.getTermType() : null), (Object)CssTermTypes.COLOR)) {
                return null;
            }
            rightColorTerm = CssColorMixUtilKt.resolveTerms$getNext(termList, i);
        } else {
            return null;
        }
        CssColor cssColor2 = CssPsiColorUtil.getColorInClassicCss((PsiElement)rightColorTerm);
        if (cssColor2 == null) {
            return null;
        }
        CssColor rightColor = cssColor2;
        CssTerm cssTerm5 = CssColorMixUtilKt.resolveTerms$peek(i, termList);
        Object object3 = cssTermType = cssTerm5 != null ? cssTerm5.getTermType() : null;
        if (cssTermType == null) {
            d = null;
        } else if (Intrinsics.areEqual((Object)cssTermType, (Object)CssTermTypes.PERCENTAGE)) {
            double it = CssPsiColorUtil.getPercentageValue(CssColorMixUtilKt.resolveTerms$getNext(termList, i).getText());
            boolean bl = false;
            if (it == -1.0) {
                return null;
            }
            d = it;
        } else {
            return null;
        }
        Double resolvedRightPercentage = d;
        if (CssColorMixUtilKt.resolveTerms$peek(i, termList) != null) {
            return null;
        }
        return new CssColorMixFunction(colorSpace2, leftColor, rightColor, resolvedLeftPercentage, resolvedRightPercentage, interpolationMethod);
    }

    private static final CssTerm resolveTerms$getNext(CssTermList $termList, Ref.IntRef i) {
        int n = i.element;
        i.element = n + 1;
        CssTerm cssTerm = $termList.getTerms()[n];
        Intrinsics.checkNotNullExpressionValue((Object)cssTerm, (String)"get(...)");
        return cssTerm;
    }

    private static final CssTerm resolveTerms$peek(Ref.IntRef i, CssTermList $termList) {
        return i.element < $termList.getTerms().length ? $termList.getTerms()[i.element] : null;
    }
}

