/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class SelectInManager {
    private final Project myProject;
    @Deprecated(forRemoval=true)
    @NonNls
    public static final String PROJECT = SelectInManager.getProject();

    public SelectInManager(@NotNull Project project) {
        if (project == null) {
            SelectInManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<SelectInTarget> getTargetList() {
        ArrayList<SelectInTarget> targets = new ArrayList<SelectInTarget>(DumbService.getDumbAwareExtensions((Project)this.myProject, SelectInTarget.EP_NAME));
        targets.sort(SelectInTargetComparator.INSTANCE);
        ArrayList<SelectInTarget> arrayList = targets;
        if (arrayList == null) {
            SelectInManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Deprecated
    public SelectInTarget @NotNull [] getTargets() {
        SelectInTarget[] selectInTargetArray = this.getTargetList().toArray(new SelectInTarget[0]);
        if (selectInTargetArray == null) {
            SelectInManager.$$$reportNull$$$0(2);
        }
        return selectInTargetArray;
    }

    public static SelectInManager getInstance(@NotNull Project project) {
        if (project == null) {
            SelectInManager.$$$reportNull$$$0(3);
        }
        return (SelectInManager)project.getService(SelectInManager.class);
    }

    public static SelectInTarget findSelectInTarget(@NotNull String id, Project project) {
        List<SelectInTarget> targets;
        if (id == null) {
            SelectInManager.$$$reportNull$$$0(4);
        }
        SelectInManager manager = project == null || project.isDisposed() ? null : SelectInManager.getInstance(project);
        List<SelectInTarget> list = targets = manager == null ? null : manager.getTargetList();
        if (targets != null) {
            for (SelectInTarget target : targets) {
                if (target == null || !Objects.equals(id, target.getToolWindowId())) continue;
                return target;
            }
        }
        return null;
    }

    @Nls
    public static String getProject() {
        return IdeBundle.message("select.in.project", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/SelectInManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/SelectInManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSelectInTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class SelectInTargetComparator
    implements Comparator<SelectInTarget> {
        public static final Comparator<SelectInTarget> INSTANCE = new SelectInTargetComparator();

        @Override
        public int compare(SelectInTarget o1, SelectInTarget o2) {
            return Float.compare(o1.getWeight(), o2.getWeight());
        }
    }
}

