/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.execution.ui.TagButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleAnnouncerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class ComponentValidator {
    private static final String PROPERTY_NAME = "JComponent.componentValidator";
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("ValidationTooltip.maxWidth", 384);
    public static final Function<JComponent, JComponent> CWBB_PROVIDER = c -> ((ComponentWithBrowseButton)c).getChildComponent();
    private final Disposable parentDisposable;
    private Supplier<? extends ValidationInfo> validator;
    private Supplier<? extends ValidationInfo> focusValidator;
    private Function<? super JComponent, ? extends JComponent> outlineProvider;
    private HyperlinkListener hyperlinkListener;
    private ValidationInfo validationInfo;
    private final SingleEdtTaskScheduler popupAlarm;
    private SingleEdtTaskScheduler popupAnnouncementAlarm;
    private boolean isOverPopup;
    private ComponentPopupBuilder popupBuilder;
    private JBPopup popup;
    private RelativePoint popupLocation;
    private Dimension popupSize;
    private boolean disableValidation;
    private JEditorPane tipComponent;

    public ComponentValidator(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ComponentValidator.$$$reportNull$$$0(0);
        }
        this.outlineProvider = Function.identity();
        this.popupAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.parentDisposable = parentDisposable;
    }

    public ComponentValidator withValidator(@NotNull Supplier<? extends ValidationInfo> validator) {
        if (validator == null) {
            ComponentValidator.$$$reportNull$$$0(1);
        }
        this.validator = validator;
        return this;
    }

    public ComponentValidator withFocusValidator(@NotNull Supplier<? extends ValidationInfo> focusValidator) {
        if (focusValidator == null) {
            ComponentValidator.$$$reportNull$$$0(2);
        }
        this.focusValidator = focusValidator;
        return this;
    }

    public ComponentValidator withHyperlinkListener(@NotNull HyperlinkListener hyperlinkListener) {
        if (hyperlinkListener == null) {
            ComponentValidator.$$$reportNull$$$0(3);
        }
        this.hyperlinkListener = hyperlinkListener;
        return this;
    }

    public ComponentValidator withOutlineProvider(@NotNull Function<? super JComponent, ? extends JComponent> outlineProvider) {
        if (outlineProvider == null) {
            ComponentValidator.$$$reportNull$$$0(4);
        }
        this.outlineProvider = outlineProvider;
        return this;
    }

    public ComponentValidator andStartOnFocusLost() {
        this.disableValidation = true;
        return this;
    }

    public ComponentValidator installOn(@NotNull JComponent component) {
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(5);
        }
        Component fc = ComponentValidator.getFocusable(component).orElse(this.outlineProvider.apply(component));
        component.putClientProperty(PROPERTY_NAME, this);
        ValidationFocusListener focusListener = new ValidationFocusListener();
        ValidationMouseListener mouseListener = new ValidationMouseListener();
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (ComponentValidator.this.popup != null && ComponentValidator.this.popup.isVisible() && ComponentValidator.this.popupLocation != null) {
                    ComponentValidator.this.popup.setLocation(ComponentValidator.this.popupLocation.getScreenPoint());
                }
            }
        };
        PropertyChangeListener ancestorListener = e -> {
            Window w = (Window)ComponentUtil.findParentByCondition((Component)((Component)e.getSource()), v -> v instanceof Window);
            if (w != null) {
                if (e.getNewValue() != null) {
                    w.addComponentListener(componentListener);
                } else {
                    w.removeComponentListener(componentListener);
                }
            }
        };
        Window w = (Window)ComponentUtil.findParentByCondition((Component)component, v -> v instanceof Window);
        if (w != null) {
            w.addComponentListener(componentListener);
        } else {
            component.addPropertyChangeListener("ancestor", ancestorListener);
        }
        fc.addFocusListener(focusListener);
        fc.addMouseListener(mouseListener);
        Disposer.register((Disposable)this.parentDisposable, () -> {
            fc.removeFocusListener(focusListener);
            fc.removeMouseListener(mouseListener);
            if (w != null) {
                w.removeComponentListener(componentListener);
            }
            this.reset();
        });
        return this;
    }

    public ComponentValidator andRegisterOnDocumentListener(final @NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            ComponentValidator.$$$reportNull$$$0(6);
        }
        DocumentAdapter listener2 = new DocumentAdapter(this){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance(textComponent).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ComponentValidator$2", "textChanged"));
            }
        };
        textComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)listener2);
        Disposer.register((Disposable)this.parentDisposable, () -> textComponent.getDocument().removeDocumentListener((javax.swing.event.DocumentListener)listener2));
        return this;
    }

    public <T extends JComponent> ComponentValidator andRegisterOnDocumentListener(final @NotNull T textComponent) {
        if (textComponent == null) {
            ComponentValidator.$$$reportNull$$$0(7);
        }
        ((EditorTextComponent)textComponent).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance(textComponent).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/ui/ComponentValidator$3", "documentChanged"));
            }
        }, this.parentDisposable);
        return this;
    }

    public void revalidate() {
        if (this.validator != null) {
            this.updateInfo(this.validator.get());
        }
    }

    public static Optional<ComponentValidator> getInstance(@NotNull JComponent component) {
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(8);
        }
        return Optional.ofNullable((ComponentValidator)component.getClientProperty(PROPERTY_NAME));
    }

    private void reset() {
        if (this.validationInfo != null && this.validationInfo.component != null) {
            this.outlineProvider.apply(this.validationInfo.component).putClientProperty("JComponent.outline", null);
            this.validationInfo.component.revalidate();
            this.validationInfo.component.repaint();
        }
        this.hidePopup(true);
        if (this.popupAnnouncementAlarm != null) {
            this.popupAnnouncementAlarm.cancel();
        }
        this.popupBuilder = null;
        this.tipComponent = null;
        this.popupLocation = null;
        this.popupSize = null;
        this.validationInfo = null;
    }

    @Nullable
    public ValidationInfo getValidationInfo() {
        return this.validationInfo;
    }

    private boolean needResetForInfo(@Nullable ValidationInfo info) {
        if (info == null && this.validationInfo != null) {
            return true;
        }
        if (info != null && this.validationInfo != null) {
            if (info.warning != this.validationInfo.warning) {
                return true;
            }
            if (this.tipComponent != null && !Objects.equals(info.message, this.validationInfo.message)) {
                String message = HtmlChunk.div().attr("width", MAX_WIDTH.get()).addRaw(ComponentValidator.trimMessage(info.message, this.tipComponent)).wrapWith(HtmlChunk.html()).toString();
                View v = BasicHTML.createHTMLView(this.tipComponent, message);
                Dimension size = this.tipComponent.getPreferredSize();
                JBInsets.removeFrom((Dimension)size, (Insets)this.tipComponent.getInsets());
                if (v.getPreferredSpan(1) != (float)size.height) {
                    return true;
                }
            }
        }
        return false;
    }

    public void updateInfo(@Nullable ValidationInfo info) {
        boolean hasNewInfo;
        if (this.disableValidation) {
            return;
        }
        boolean bl = hasNewInfo = info != null && !info.equals((Object)this.validationInfo);
        if (this.needResetForInfo(info)) {
            this.reset();
        }
        if (hasNewInfo || info != null && this.popup != null && !this.popup.isVisible()) {
            this.validationInfo = info;
            if (this.popup != null && this.popup.isVisible() && this.tipComponent != null) {
                this.popup.pack(true, ComponentValidator.convertMessage(info.message, this.tipComponent));
            } else {
                JComponent component = this.validationInfo.component;
                if (component != null) {
                    this.outlineProvider.apply(component).putClientProperty("JComponent.outline", this.validationInfo.warning ? "warning" : "error");
                    component.revalidate();
                    component.repaint();
                }
                if (!StringUtil.isEmptyOrSpaces((String)info.message)) {
                    this.popupBuilder = ComponentValidator.createPopupBuilder(this.validationInfo, (? super JEditorPane editorPane) -> {
                        this.tipComponent = editorPane;
                        editorPane.addHyperlinkListener(this.hyperlinkListener);
                        editorPane.addMouseListener(new TipComponentMouseListener());
                        this.popupSize = editorPane.getPreferredSize();
                    }).setCancelOnMouseOutCallback(e -> e.getID() == 501 && !ComponentValidator.withinComponent(info, e));
                    ComponentValidator.getFocusable(component).ifPresent(fc -> {
                        if (fc.hasFocus()) {
                            this.showPopup();
                        }
                    });
                }
            }
        }
    }

    @NotNull
    private static ComponentPopupBuilder createPopupBuilder(boolean isWarning, @Nullable Consumer<? super JEditorPane> configurator) {
        JEditorPane tipComponent = new JEditorPane();
        tipComponent.setContentType("text/html");
        tipComponent.setEditable(false);
        tipComponent.setEditorKit(HTMLEditorKitBuilder.simple());
        EditorKit kit = tipComponent.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}");
            css.addRule("a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}");
            css.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}");
            css.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}");
            css.addRule("body {background-color:#" + ColorUtil.toHex((Color)(isWarning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor())) + ";}");
        }
        if (tipComponent.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)tipComponent.getCaret()).setUpdatePolicy(1);
        }
        tipComponent.setCaretPosition(0);
        tipComponent.setBackground(isWarning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor());
        tipComponent.setOpaque(true);
        tipComponent.setBorder(ComponentValidator.getBorder());
        if (configurator != null) {
            configurator.accept(tipComponent);
        }
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipComponent, null).setBorderColor(isWarning ? JBUI.CurrentTheme.Validator.warningBorderColor() : JBUI.CurrentTheme.Validator.errorBorderColor()).setCancelOnClickOutside(false).setShowShadow(true).setFocusable(false);
        if (componentPopupBuilder == null) {
            ComponentValidator.$$$reportNull$$$0(9);
        }
        return componentPopupBuilder;
    }

    @NlsSafe
    private static boolean convertMessage(@Nls String message, @NotNull JEditorPane component) {
        View v;
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(10);
        }
        boolean widerText = (v = BasicHTML.createHTMLView(component, String.format("<html>%s</html>", message))).getPreferredSpan(0) > (float)MAX_WIDTH.get();
        HtmlChunk.Element div = widerText ? HtmlChunk.div().attr("width", MAX_WIDTH.get()).addRaw(ComponentValidator.trimMessage(message, component)) : HtmlChunk.div().addRaw(message);
        component.setText(div.wrapWith("body").wrapWith("html").toString());
        return widerText;
    }

    @NotNull
    public static ComponentPopupBuilder createPopupBuilder(@NotNull ValidationInfo info, @Nullable Consumer<? super JEditorPane> configurator) {
        if (info == null) {
            ComponentValidator.$$$reportNull$$$0(11);
        }
        return ComponentValidator.createPopupBuilder(info.warning, (? super JEditorPane tipComponent) -> {
            ComponentValidator.convertMessage(info.message, tipComponent);
            if (configurator != null) {
                configurator.accept((JEditorPane)tipComponent);
            }
        });
    }

    @Nls
    private static String trimMessage(@Nls String message, JComponent c) {
        String[] words = message.split("\\s+");
        @Nls StringBuilder result2 = new StringBuilder();
        for (String word : words) {
            word = SwingUtilities2.clipStringIfNecessary(c, c.getFontMetrics(c.getFont()), word, MAX_WIDTH.get());
            result2.append(word).append(" ");
        }
        return result2.toString();
    }

    public static boolean withinComponent(@NotNull ValidationInfo info, @NotNull MouseEvent e) {
        if (info == null) {
            ComponentValidator.$$$reportNull$$$0(12);
        }
        if (e == null) {
            ComponentValidator.$$$reportNull$$$0(13);
        }
        if (info.component != null && info.component.isShowing()) {
            Rectangle screenBounds = new Rectangle(info.component.getLocationOnScreen(), info.component.getSize());
            return screenBounds.contains(e.getLocationOnScreen());
        }
        return false;
    }

    private void showPopup() {
        if ((this.popup == null || !this.popup.isVisible()) && this.popupBuilder != null && this.validationInfo != null && this.validationInfo.component != null && this.validationInfo.component.isEnabled()) {
            JComponent jComponent;
            this.popup = this.popupBuilder.createPopup();
            Insets i = this.validationInfo.component.getInsets();
            Point point = new Point(JBUIScale.scale((int)40), i.top - JBUIScale.scale((int)6) - this.popupSize.height);
            this.popupLocation = new RelativePoint((Component)this.validationInfo.component, point);
            this.popup.show(this.popupLocation);
            if (AccessibleAnnouncerUtil.isAnnouncingAvailable() && (jComponent = this.validationInfo.component) instanceof Accessible) {
                Accessible a = (Accessible)((Object)jComponent);
                if (this.popupAnnouncementAlarm == null) {
                    this.popupAnnouncementAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
                }
                this.popupAnnouncementAlarm.cancelAndRequest(200L, () -> {
                    if (this.validationInfo != null) {
                        String message = UIBundle.message(this.validationInfo.warning ? "validation.info.warning.with.prefix" : "validation.info.error.with.prefix", this.validationInfo.message);
                        AccessibleAnnouncerUtil.announce((Accessible)a, (String)message, (boolean)false);
                    }
                });
            }
        }
    }

    private void hidePopup(boolean now) {
        if (this.popup != null && this.popup.isVisible()) {
            if (now || this.hyperlinkListener == null) {
                this.popup.cancel();
                this.popup = null;
            } else {
                this.popupAlarm.request((long)Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"), () -> {
                    if (!this.isOverPopup || this.hyperlinkListener == null) {
                        this.hidePopup(true);
                    }
                });
            }
        }
    }

    public static Border getBorder() {
        Insets i = UIManager.getInsets("ValidationTooltip.borderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty((int)4, (int)8);
    }

    private static Optional<Component> getFocusable(Component source) {
        if (source instanceof JComboBox && !((JComboBox)source).isEditable() || source instanceof JCheckBox || source instanceof JRadioButton || source instanceof TagButton) {
            return Optional.of(source);
        }
        return ((JBTreeTraverser)UIUtil.uiTraverser((Component)source).filter(c -> c instanceof JTextComponent && c.isFocusable() || c instanceof EditorTextComponent && c instanceof FocusListener)).toList().stream().findFirst();
    }

    public void enableValidation() {
        this.disableValidation = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusValidator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outlineProvider";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/ComponentValidator";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/ComponentValidator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withValidator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withFocusValidator";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withHyperlinkListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withOutlineProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "andRegisterOnDocumentListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPopupBuilder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withinComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private class ValidationFocusListener
    implements FocusListener {
        private ValidationFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComponentValidator.this.hidePopup(false);
            if (ComponentValidator.this.focusValidator != null) {
                ComponentValidator.this.updateInfo(ComponentValidator.this.focusValidator.get());
            }
            if (ComponentValidator.this.disableValidation) {
                ComponentValidator.this.enableValidation();
                ComponentValidator.this.revalidate();
            }
        }
    }

    private class ValidationMouseListener
    extends MouseAdapter {
        private ValidationMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ComponentValidator.this.validationInfo != null) {
                ComponentValidator.getFocusable(ComponentValidator.this.validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.hidePopup(false);
                    }
                });
            }
        }
    }

    private class TipComponentMouseListener
    extends MouseAdapter {
        private TipComponentMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.isOverPopup = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ComponentValidator.this.isOverPopup = false;
            if (ComponentValidator.this.popup != null) {
                ComponentValidator.getFocusable(ComponentValidator.this.validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.popup.cancel();
                        ComponentValidator.this.popup = null;
                    }
                });
            }
        }
    }
}

