/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Touchbar {
    private static final Key<ActionGroup> ACTION_GROUP_KEY = Key.create((String)"Touchbar.ActionGroup.key");
    private static final boolean EXPAND_OPTION_BUTTONS = Boolean.getBoolean("Touchbar.expand.option.button");

    @Nullable
    public static ActionGroup getActions(@NotNull JComponent component) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(0);
        }
        return (ActionGroup)ClientProperty.get((Component)component, ACTION_GROUP_KEY);
    }

    public static void setActions(@NotNull JComponent component, @Nullable ActionGroup group) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(1);
        }
        if (!SystemInfoRt.isMac || !LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null) {
            return;
        }
        component.putClientProperty(ACTION_GROUP_KEY, group);
    }

    public static void setActions(@NotNull JComponent component, @Nullable AnAction action) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(2);
        }
        Touchbar.setActions(component, action == null ? null : new DefaultActionGroup(action));
    }

    public static void setActions(@NotNull JComponent component, @Language(value="devkit-action-id") @NotNull String actionId) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(3);
        }
        if (actionId == null) {
            Touchbar.$$$reportNull$$$0(4);
        }
        Touchbar.setActions(component, ActionManager.getInstance().getAction(actionId));
    }

    public static void addActions(@NotNull JComponent component, @Nullable ActionGroup group) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(5);
        }
        if (!SystemInfoRt.isMac || !LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null) {
            return;
        }
        ActionGroup old = (ActionGroup)ClientProperty.get((Component)component, ACTION_GROUP_KEY);
        if (old == null) {
            Touchbar.setActions(component, group);
        } else if (old instanceof DefaultActionGroup && group != null) {
            ((DefaultActionGroup)old).addAll(group);
        }
    }

    public static void setButtonActions(@NotNull JComponent component, Collection<? extends JButton> buttons, Collection<? extends JButton> principal, JButton defaultButton) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(6);
        }
        Touchbar.setButtonActions(component, buttons, principal, defaultButton, null);
    }

    public static void setButtonActions(@NotNull JComponent component, Collection<? extends JButton> buttons, Collection<? extends JButton> principal, JButton defaultButton, @Nullable ActionGroup extraActions) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(7);
        }
        if (!SystemInfoRt.isMac || !LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null) {
            return;
        }
        ActionManagerEx.withLazyActionManager(null, (Function1<? super ActionManager, Unit>)((Function1)instance2 -> {
            DefaultActionGroup result2 = new DefaultActionGroup();
            if (buttons != null) {
                result2.add((AnAction)Touchbar.buildActionsFromButtons(buttons, defaultButton, false));
            }
            if (extraActions != null) {
                result2.add((AnAction)extraActions);
            }
            if (principal != null) {
                result2.add((AnAction)Touchbar.buildActionsFromButtons(principal, defaultButton, true));
            }
            Touchbar.setActions(component, result2);
            return Unit.INSTANCE;
        }));
    }

    @NotNull
    private static DefaultActionGroup buildActionsFromButtons(Collection<? extends JButton> buttons, JButton defaultButton, boolean isPrincipal) {
        DefaultActionGroup result2 = new DefaultActionGroup();
        if (EXPAND_OPTION_BUTTONS) {
            DefaultActionGroup options = null;
            for (JButton jButton : buttons) {
                JBOptionButton ob;
                Action[] opts;
                if (!(jButton instanceof JBOptionButton) || (opts = (ob = (JBOptionButton)jButton).getOptions()) == null) continue;
                for (Action a : opts) {
                    AnAction anAct;
                    if (a == null || (anAct = Touchbar._createActionFromButton(a, ob, true)) == null) continue;
                    if (options == null) {
                        options = new DefaultActionGroup();
                    }
                    options.add(anAct);
                }
            }
            if (options != null) {
                result2.add((AnAction)options);
            }
        }
        for (JButton jButton : buttons) {
            AnAction anAction2 = Touchbar._createActionFromButton(jButton.getAction(), jButton, false);
            if (anAction2 == null) continue;
            if (jButton == defaultButton) {
                TouchbarActionCustomizations.setDefault(anAction2, true);
            }
            result2.add(anAction2);
        }
        if (isPrincipal) {
            TouchbarActionCustomizations.setPrincipal((AnAction)result2, true);
        }
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            Touchbar.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    private static AnAction _createActionFromButton(@Nullable Action action, @NotNull JButton button2, boolean useTextFromAction) {
        Object anAct;
        if (button2 == null) {
            Touchbar.$$$reportNull$$$0(9);
        }
        Object object = anAct = action == null ? null : action.getValue("AnAction");
        if (anAct == null) {
            anAct = new MyAction(useTextFromAction, action, button2);
        }
        if (!(anAct instanceof AnAction)) {
            return null;
        }
        TouchbarActionCustomizations.setComponent((AnAction)anAct, button2).setShowText(true).setShowImage(false);
        return (AnAction)anAct;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/Touchbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/Touchbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildActionsFromButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setButtonActions";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_createActionFromButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static class MyAction
    extends DumbAwareAction
    implements ActionWithDelegate<Object> {
        final boolean useTextFromAction;
        @Nullable
        final Action action;
        @NotNull
        final JButton button;

        MyAction(boolean useTextFromAction, @Nullable Action action, @NotNull JButton button2) {
            if (button2 == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            this.useTextFromAction = useTextFromAction;
            this.action = action;
            this.button = button2;
            this.setEnabledInModalContext(true);
            if (useTextFromAction) {
                Object name = action == null ? button2.getText() : action.getValue("Name");
                this.getTemplatePresentation().setText(name instanceof String ? (String)name : "");
            }
        }

        @NotNull
        public Object getDelegate() {
            Object object = this.action == null ? this.button : this.action;
            if (object == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(3);
            }
            if (this.action == null) {
                this.button.doClick();
                return;
            }
            this.action.actionPerformed(new ActionEvent(this.button, 1001, null));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabled(this.action == null ? this.button.isEnabled() : this.action.isEnabled());
            if (!this.useTextFromAction) {
                e.getPresentation().setText((String)DialogWrapper.extractMnemonic((String)this.button.getText()).second);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/mac/touchbar/Touchbar$MyAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/Touchbar$MyAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

