/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.internal;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ProxyCredentialProvider;
import com.intellij.util.net.ProxyCredentialStore;
import com.intellij.util.net.internal.HttpConfigurableMigrationUtilsKt;
import com.intellij.util.proxy.CommonProxy;
import java.net.PasswordAuthentication;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/net/internal/HttpConfigurableToCredentialStoreAdapter;", "Lcom/intellij/util/net/ProxyCredentialStore;", "Lcom/intellij/util/net/ProxyCredentialProvider;", "getHttpConfigurable", "Lkotlin/Function0;", "Lcom/intellij/util/net/HttpConfigurable;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "httpConfigurable", "()Lcom/intellij/util/net/HttpConfigurable;", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "host", "", "port", "", "setCredentials", "", "credentials", "remember", "", "areCredentialsRemembered", "clearTransientCredentials", "clearAllCredentials", "intellij.platform.ide"})
final class HttpConfigurableToCredentialStoreAdapter
implements ProxyCredentialStore,
ProxyCredentialProvider {
    @NotNull
    private final Function0<HttpConfigurable> getHttpConfigurable;

    public HttpConfigurableToCredentialStoreAdapter(@NotNull Function0<? extends HttpConfigurable> getHttpConfigurable) {
        Intrinsics.checkNotNullParameter(getHttpConfigurable, (String)"getHttpConfigurable");
        this.getHttpConfigurable = getHttpConfigurable;
    }

    private final HttpConfigurable getHttpConfigurable() {
        return (HttpConfigurable)this.getHttpConfigurable.invoke();
    }

    @Override
    @Nullable
    public synchronized Credentials getCredentials(@NotNull String host, int port) {
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port) {
            credentials = HttpConfigurableMigrationUtilsKt.access$getCredentials(this.getHttpConfigurable());
        } else {
            PasswordAuthentication passwordAuthentication = this.getHttpConfigurable().getGenericPassword(host, port);
            credentials = passwordAuthentication != null ? HttpConfigurableMigrationUtilsKt.access$toCredentials(passwordAuthentication) : null;
        }
        return credentials;
    }

    @Override
    public synchronized void setCredentials(@NotNull String host, int port, @Nullable Credentials credentials, boolean remember) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port) {
            HttpConfigurableMigrationUtilsKt.access$setCredentials(this.getHttpConfigurable(), credentials);
            this.getHttpConfigurable().KEEP_PROXY_PASSWORD = credentials != null && remember;
        } else if (credentials == null || credentials.getPassword() == null) {
            this.getHttpConfigurable().removeGeneric(new CommonProxy.HostInfo(null, host, port));
        } else {
            HttpConfigurable httpConfigurable = this.getHttpConfigurable();
            String string = credentials.getUserName();
            OneTimeString oneTimeString = credentials.getPassword();
            Intrinsics.checkNotNull((Object)oneTimeString);
            httpConfigurable.putGenericPassword(host, port, new PasswordAuthentication(string, OneTimeString.toCharArray$default((OneTimeString)oneTimeString, (boolean)false, (int)1, null)), remember);
        }
    }

    @Override
    public synchronized boolean areCredentialsRemembered(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port ? this.getHttpConfigurable().KEEP_PROXY_PASSWORD : this.getHttpConfigurable().isGenericPasswordRemembered(host, port);
    }

    @Override
    public synchronized void clearTransientCredentials() {
        this.getHttpConfigurable().clearGenericPasswords();
    }

    @Override
    public synchronized void clearAllCredentials() {
        HttpConfigurableMigrationUtilsKt.access$setCredentials(this.getHttpConfigurable(), null);
        this.getHttpConfigurable().setPlainProxyPassword(null);
        this.getHttpConfigurable().KEEP_PROXY_PASSWORD = false;
        this.getHttpConfigurable().clearGenericPasswords();
    }
}

