/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DialogUtil {
    private DialogUtil() {
    }

    public static void registerMnemonic(@NotNull AbstractButton button2) {
        if (button2 == null) {
            DialogUtil.$$$reportNull$$$0(0);
        }
        DialogUtil.setTextWithMnemonic(button2, button2.getText(), '\u001b');
    }

    public static void registerMnemonic(@NotNull AbstractButton button2, char mn) {
        if (button2 == null) {
            DialogUtil.$$$reportNull$$$0(1);
        }
        DialogUtil.setTextWithMnemonic(button2, button2.getText(), mn);
    }

    public static void setTextWithMnemonic(@NotNull AbstractButton button2, @NlsContexts.Button String text) {
        if (button2 == null) {
            DialogUtil.$$$reportNull$$$0(2);
        }
        DialogUtil.setTextWithMnemonic(button2, text, '\u001b');
    }

    public static void setTextWithMnemonic(@NotNull AbstractButton button2, @NlsContexts.Button String text, char mn) {
        if (button2 == null) {
            DialogUtil.$$$reportNull$$$0(3);
        }
        if (text != null) {
            @Nls StringBuilder realText = new StringBuilder();
            char mnemonic = '\u0000';
            int index = -1;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch != mn) {
                    realText.append(ch);
                    continue;
                }
                if (i + 1 >= text.length()) continue;
                mnemonic = text.charAt(i + 1);
                index = realText.length();
            }
            if (mnemonic != '\u0000') {
                button2.setText(realText.toString());
                if (LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && UISettings.getInstance().getDisableMnemonicsInControls()) {
                    button2.setMnemonic(0);
                    button2.setDisplayedMnemonicIndex(-1);
                    button2.setFocusable(true);
                } else {
                    button2.setMnemonic(mnemonic);
                    button2.setDisplayedMnemonicIndex(index);
                }
            }
        }
    }

    public static void registerMnemonic(JLabel label2, @Nullable JComponent target) {
        DialogUtil.registerMnemonic(label2, target, '\u001b');
    }

    public static void registerMnemonic(JLabel label2, @Nullable JComponent target, char mn) {
        String text = label2.getText();
        if (text != null) {
            @Nls StringBuilder realText = new StringBuilder(text.length());
            char mnemonic = '\u0000';
            int index = -1;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch != mn || i + 1 == text.length() || text.charAt(i + 1) == ' ') {
                    realText.append(ch);
                    continue;
                }
                mnemonic = text.charAt(i + 1);
                index = realText.length();
            }
            if (mnemonic != '\u0000') {
                label2.setText(realText.toString());
                if (UISettings.getShadowInstance().getDisableMnemonicsInControls()) {
                    label2.setDisplayedMnemonic(0);
                    label2.setDisplayedMnemonicIndex(-1);
                } else {
                    label2.setDisplayedMnemonic(mnemonic);
                    label2.setDisplayedMnemonicIndex(index);
                }
                if (target != null) {
                    label2.setLabelFor(target);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "button";
        objectArray2[1] = "com/intellij/util/ui/DialogUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerMnemonic";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextWithMnemonic";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

