/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.ScrollKind;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0011\u001a\u001e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0011\u001a\"\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010'\u001a\u00020\u0018\u001a\"\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010'\u001a\u00020\u0018\u001a\n\u0010)\u001a\u00020&*\u00020\u0001\u001a\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+*\u00020\u0002\u001a\u0012\u0010,\u001a\u00020\u001f*\u00020\u00022\u0006\u0010-\u001a\u00020.\u001a\n\u0010/\u001a\u00020\u001f*\u000200\u001a-\u00101\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00182\u000e\b\u0004\u00103\u001a\b\u0012\u0004\u0012\u00020\u001004H\u0082\b\u001a\u001e\u00105\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u0010\u001a\n\u00108\u001a\u000200*\u000200\u001a\u001a\u00109\u001a\u00020\u001d*\u00020:2\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001f\u001a\u0012\u0010=\u001a\u00020\u0018*\u00020\u001f2\u0006\u0010>\u001a\u00020\u001f\u001a\n\u00108\u001a\u00020?*\u00020?\u001a\n\u0010@\u001a\u00020A*\u00020\u001f\u001a\n\u0010@\u001a\u00020A*\u00020&\u001a\n\u0010@\u001a\u00020A*\u00020\u0004\u001a\n\u0010@\u001a\u00020A*\u00020\u0013\u001a\n\u0010@\u001a\u00020A*\u00020\"\u001a\n\u0010@\u001a\u00020A*\u00020B\u001a\n\u0010@\u001a\u00020A*\u00020C\u001a\n\u0010@\u001a\u00020A*\u00020D\u001a\n\u0010E\u001a\u00020A*\u00020B\u001a\u000f\u0010F\u001a\u00020\u0015*\u0004\u0018\u00010\u0010H\u0086\u0002\u001a\u000f\u0010G\u001a\u00020\u0015*\u0004\u0018\u00010\u0010H\u0086\u0002\u001a\r\u0010F\u001a\u00020\u0015*\u00020HH\u0086\u0002\u001a\r\u0010G\u001a\u00020\u0015*\u00020HH\u0086\u0002\"3\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006I"}, d2={"getCaretById", "Lcom/intellij/openapi/editor/Caret;", "Lcom/intellij/openapi/editor/CaretModel;", "id", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "<set-?>", "getId", "(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", "setId", "(Lcom/intellij/openapi/editor/Caret;Lcom/jetbrains/rd/ide/model/RdCaretId;)V", "id$delegate", "Lkotlin/properties/ReadWriteProperty;", "toScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/rd/ide/model/ScrollKind;", "docOffsetAndVirtualToVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "Lcom/intellij/openapi/editor/Editor;", "pos", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "offset", "", "virtualDelta", "logicalLeansForward", "", "calculateVisibleRange", "Lcom/jetbrains/rd/ide/model/VisibleRange;", "editor", "applyStateTo", "", "newState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "applySelectionTo", "selectionModel", "Lcom/jetbrains/rd/ide/model/RdSelection;", "caretToSync", "addCaretTo", "caret", "Lcom/jetbrains/rd/ide/model/RdCaret;", "isPrimary", "positionModel", "createModelCaret", "createModelCarets", "", "createModelCaretState", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getActualState", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "createModelPosition", "ignoreVirtualDelta", "calcVisualPosition", "Lkotlin/Function0;", "calcVirtualDelta", "caretOffset", "visualPosition", "reverse", "assertSameCaretState", "Lcom/intellij/openapi/diagnostic/Logger;", "expectedState", "actualState", "isEquivalentTo", "other", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "toDebugString", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "createLogCategory", "component1", "component2", "Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n164#1,6:253\n164#1,6:259\n164#1,6:265\n296#2,2:246\n1068#2:248\n1586#2:249\n1661#2,3:250\n1586#2:271\n1661#2,3:272\n1586#2:275\n1661#2,3:276\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n*L\n137#1:253,6\n138#1:259,6\n139#1:265,6\n12#1:246,2\n68#1:248\n74#1:249\n74#1:250,3\n145#1:271\n145#1:272,3\n224#1:275\n224#1:276,3\n*E\n"})
public final class UtilKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadWriteProperty id$delegate;

    @Nullable
    public static final Caret getCaretById(@NotNull CaretModel $this$getCaretById, @NotNull RdCaretId id) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getCaretById, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            List list = $this$getCaretById.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Caret it = (Caret)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)UtilKt.getId(it), (Object)id)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final RdCaretId getId(@NotNull Caret $this$id) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        return (RdCaretId)id$delegate.getValue((Object)$this$id, $$delegatedProperties[0]);
    }

    public static final void setId(@NotNull Caret $this$id, @Nullable RdCaretId rdCaretId) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        id$delegate.setValue((Object)$this$id, $$delegatedProperties[0], (Object)rdCaretId);
    }

    @NotNull
    public static final ScrollType toScrollType(@NotNull ScrollKind $this$toScrollType) {
        Intrinsics.checkNotNullParameter((Object)$this$toScrollType, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toScrollType.ordinal()]) {
            case 1 -> ScrollType.MAKE_VISIBLE;
            case 2 -> ScrollType.RELATIVE;
            case 3 -> ScrollType.CENTER;
            case 4 -> ScrollType.CENTER_DOWN;
            case 5 -> ScrollType.CENTER_UP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, @NotNull DocOffsetAndVirtualModel pos) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Boolean bl = pos.getLogicalLeansForward();
        return UtilKt.docOffsetAndVirtualToVisualPosition($this$docOffsetAndVirtualToVisualPosition, pos.getOffset(), pos.getVirtualDelta(), bl != null ? bl : false);
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, int offset, int virtualDelta, boolean logicalLeansForward) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        if (!(virtualDelta >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $this$docOffsetAndVirtualToVisualPosition.offsetToVisualPosition(offset, logicalLeansForward, false);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition vPos = visualPosition;
        return virtualDelta == 0 ? vPos : new VisualPosition(vPos.line, vPos.column + virtualDelta, vPos.leansRight);
    }

    @NotNull
    public static final VisibleRange calculateVisibleRange(@NotNull Editor editor) {
        List list;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ProperTextRange properTextRange = editor.calculateVisibleRange();
        Intrinsics.checkNotNullExpressionValue((Object)properTextRange, (String)"calculateVisibleRange(...)");
        ProperTextRange visibleRange = properTextRange;
        Object[] objectArray = editor.getFoldingModel();
        FoldingModelImpl foldingModelImpl = objectArray instanceof FoldingModelImpl ? (FoldingModelImpl)objectArray : null;
        List regionsOverlapping = foldingModelImpl != null && (objectArray = foldingModelImpl.fetchVisible()) != null && (sequence3 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, arg_0 -> UtilKt.calculateVisibleRange$lambda$0(visibleRange, arg_0))) != null && (sequence = SequencesKt.map((Sequence)sequence2, UtilKt::calculateVisibleRange$lambda$1)) != null && (list = SequencesKt.toList((Sequence)sequence)) != null ? list : CollectionsKt.emptyList();
        return new VisibleRange(visibleRange.getStartOffset(), visibleRange.getEndOffset(), regionsOverlapping);
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyStateTo(@NotNull RdCaretState newState, @NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isDisposed()) {
            return;
        }
        Iterable $this$sortedBy$iv = newState.getCarets();
        boolean $i$f$sortedBy = false;
        List newCarets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RdCaret it = (RdCaret)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getId().getNumber());
                it = (RdCaret)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getId().getNumber()));
            }
        });
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret currentCaret = caret;
        boolean currentCaretLogicalPositionLeansForward = currentCaret.getLogicalPosition().leansForward;
        int currentCaretOffset = currentCaret.getOffset();
        Boolean lastCaretBeforeRollbackLeansForward = CaretRestoreHelper.Companion.getInstance().getLastCaretBeforeRollbackLeansForward();
        Iterable $this$map$iv = newCarets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl;
            void caret2;
            boolean newCaretHasSameOffset;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            boolean bl3 = newCaretHasSameOffset = currentCaretOffset == caret2.getOffset().getOffset();
            if (newCaretHasSameOffset) {
                bl = currentCaretLogicalPositionLeansForward;
            } else {
                Boolean bl4 = lastCaretBeforeRollbackLeansForward;
                bl = bl4 != null ? bl4 : false;
            }
            boolean defaultLeansForward = bl;
            Boolean bl5 = caret2.getOffset().getLogicalLeansForward();
            LogicalPosition caretPosition = editor.offsetToLogicalPosition(caret2.getOffset().getOffset()).leanForward(bl5 != null ? bl5 : defaultLeansForward);
            Boolean bl6 = caret2.getSelection().getStart().getLogicalLeansForward();
            LogicalPosition selectionStart = editor.offsetToLogicalPosition(caret2.getSelection().getStart().getOffset()).leanForward(bl6 != null ? bl6 : defaultLeansForward);
            Boolean bl7 = caret2.getSelection().getEnd().getLogicalLeansForward();
            LogicalPosition selectionEnd = editor.offsetToLogicalPosition(caret2.getSelection().getEnd().getOffset()).leanForward(bl7 != null ? bl7 : defaultLeansForward);
            collection.add(new CaretState(caretPosition, caret2.getOffset().getVirtualDelta(), selectionStart, selectionEnd));
        }
        List states = (List)destination$iv$iv;
        editor.getCaretModel().setCaretsAndSelections(states);
        for (RdCaret newCaret : newCarets) {
            Caret caret3;
            Boolean bl;
            if (newCaret.getOffset().getOffset() == currentCaretOffset) {
                Boolean bl8 = newCaret.getOffset().getLogicalLeansForward();
                bl = bl8 != null ? bl8 : currentCaretLogicalPositionLeansForward;
            } else {
                bl = newCaret.getOffset().getLogicalLeansForward();
                if (bl == null) {
                    bl = lastCaretBeforeRollbackLeansForward;
                }
            }
            Boolean leansForward = bl;
            Boolean bl9 = leansForward;
            VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition(editor, newCaret.getOffset().getOffset(), newCaret.getOffset().getVirtualDelta(), bl9 != null ? bl9 : false);
            if (editor.getCaretModel().getCaretAt(visualPosition) == null) {
                throw new IllegalStateException(("Cannot find caret at " + visualPosition).toString());
            }
            UtilKt.setId(caret3, newCaret.getId());
            if (!Intrinsics.areEqual((Object)newCaret.getId(), (Object)newState.getPrimaryCaretId()) || editor.getCaretModel().getPrimaryCaret() == caret3) continue;
            editor.getCaretModel().removeCaret(caret3);
            UtilKt.addCaretTo(newCaret, editor, true);
        }
    }

    public static final void applySelectionTo(@NotNull RdSelection selectionModel, @NotNull Caret caretToSync, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)caretToSync, (String)"caretToSync");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getStart();
        int startOffset = docOffsetAndVirtualModel.component1();
        int startVDelta = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getEnd();
        int endOffset = docOffsetAndVirtualModel2.component1();
        int endVDelta = docOffsetAndVirtualModel2.component2();
        if (startVDelta > 0 || endVDelta > 0) {
            VisualPosition startVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getStart());
            VisualPosition endVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getEnd());
            caretToSync.setSelection(startVPos, startOffset, endVPos, endOffset);
        } else {
            caretToSync.setSelection(startOffset, endOffset);
        }
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull RdCaret caret, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Caret caret2 = UtilKt.addCaretTo(caret.getOffset(), editor, isPrimary);
        if (caret2 == null) {
            return null;
        }
        Caret caretToSync = caret2;
        UtilKt.applySelectionTo(caret.getSelection(), caretToSync, editor);
        UtilKt.setId(caretToSync, caret.getId());
        return caretToSync;
    }

    public static /* synthetic */ Caret addCaretTo$default(RdCaret rdCaret, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(rdCaret, editor, bl);
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull DocOffsetAndVirtualModel positionModel, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)positionModel, (String)"positionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VisualPosition pos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, positionModel);
        return editor.getCaretModel().addCaret(pos, isPrimary);
    }

    public static /* synthetic */ Caret addCaretTo$default(DocOffsetAndVirtualModel docOffsetAndVirtualModel, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(docOffsetAndVirtualModel, editor, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RdCaret createModelCaret(@NotNull Caret $this$createModelCaret) {
        DocOffsetAndVirtualModel docOffsetAndVirtualModel;
        void $this$createModelPosition$iv;
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2;
        void $this$createModelPosition$iv2;
        DocOffsetAndVirtualModel docOffsetAndVirtualModel3;
        void $this$createModelPosition$iv3;
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaret, (String)"<this>");
        RdCaretId rdCaretId = UtilKt.getId($this$createModelCaret);
        if (rdCaretId == null) {
            throw new IllegalStateException("Caret has no ID assigned".toString());
        }
        RdCaretId id = rdCaretId;
        Caret caret = $this$createModelCaret;
        int n = $this$createModelCaret.getOffset();
        int ignoreVirtualDelta$iv = 0;
        boolean $i$f$createModelPosition = false;
        boolean isInBulkUpdate$iv = $this$createModelPosition$iv3.getEditor().getDocument().isInBulkUpdate();
        if (isInBulkUpdate$iv) {
            docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel((int)offset$iv, 0, Boolean.valueOf(false));
        } else {
            Editor editor = $this$createModelPosition$iv3.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            void var12_9 = offset$iv;
            Editor editor2 = editor;
            boolean bl = false;
            VisualPosition visualPosition = $this$createModelCaret.getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            VisualPosition visualPosition2 = visualPosition;
            int virtualDelta$iv = UtilKt.calcVirtualDelta(editor2, (int)var12_9, visualPosition2);
            docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel((int)offset$iv, virtualDelta$iv, Boolean.valueOf($this$createModelPosition$iv3.getLogicalPosition().leansForward));
        }
        DocOffsetAndVirtualModel offset = docOffsetAndVirtualModel3;
        Caret offset$iv = $this$createModelCaret;
        ignoreVirtualDelta$iv = $this$createModelCaret.getSelectionStart();
        int ignoreVirtualDelta$iv2 = 1;
        boolean $i$f$createModelPosition2 = false;
        boolean isInBulkUpdate$iv2 = $this$createModelPosition$iv2.getEditor().getDocument().isInBulkUpdate();
        if (isInBulkUpdate$iv2) {
            docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel((int)offset$iv2, 0, Boolean.valueOf(false));
        } else {
            int virtualDelta$iv = 0;
            docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel((int)offset$iv2, virtualDelta$iv, Boolean.valueOf($this$createModelPosition$iv2.getLogicalPosition().leansForward));
        }
        DocOffsetAndVirtualModel startPos = docOffsetAndVirtualModel2;
        Caret offset$iv2 = $this$createModelCaret;
        ignoreVirtualDelta$iv2 = $this$createModelCaret.getSelectionEnd();
        boolean ignoreVirtualDelta$iv3 = true;
        boolean $i$f$createModelPosition3 = false;
        boolean isInBulkUpdate$iv3 = $this$createModelPosition$iv.getEditor().getDocument().isInBulkUpdate();
        if (isInBulkUpdate$iv3) {
            docOffsetAndVirtualModel = new DocOffsetAndVirtualModel((int)offset$iv, 0, Boolean.valueOf(false));
        } else {
            int virtualDelta$iv = 0;
            docOffsetAndVirtualModel = new DocOffsetAndVirtualModel((int)offset$iv, virtualDelta$iv, Boolean.valueOf($this$createModelPosition$iv.getLogicalPosition().leansForward));
        }
        DocOffsetAndVirtualModel endPos = docOffsetAndVirtualModel;
        RdSelection selection = new RdSelection(startPos, endPos);
        return new RdCaret(id, offset, selection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RdCaret> createModelCarets(@NotNull CaretModel $this$createModelCarets) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createModelCarets, (String)"<this>");
        List list = $this$createModelCarets.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caret;
            Caret caret2 = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)caret);
            collection.add(UtilKt.createModelCaret((Caret)caret));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final RdCaretState createModelCaretState(@NotNull CaretModel $this$createModelCaretState, @NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaretState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Caret caret = $this$createModelCaretState.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        RdCaretId rdCaretId = UtilKt.getId(caret);
        if (rdCaretId == null) {
            throw new IllegalStateException("Primary caret has no ID assigned".toString());
        }
        RdCaretId primaryId = rdCaretId;
        return new RdCaretState(primaryId, UtilKt.createModelCarets($this$createModelCaretState), version);
    }

    @NotNull
    public static final RdCaretState getActualState(@NotNull RdSelectionChangeBase $this$getActualState) {
        RdCaretState rdCaretState;
        Intrinsics.checkNotNullParameter((Object)$this$getActualState, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase = $this$getActualState;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdCaretState = ((RdCaretStateChange)$this$getActualState).getNewState();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            rdCaretState = ((RdCaretStateSnapshotBase)$this$getActualState).getState();
        } else {
            throw new IllegalStateException(("Unsupported selection change: " + $this$getActualState).toString());
        }
        return rdCaretState;
    }

    private static final DocOffsetAndVirtualModel createModelPosition(Caret $this$createModelPosition, int offset, boolean ignoreVirtualDelta, Function0<VisualPosition> calcVisualPosition) {
        int n;
        boolean $i$f$createModelPosition = false;
        boolean isInBulkUpdate = $this$createModelPosition.getEditor().getDocument().isInBulkUpdate();
        if (isInBulkUpdate) {
            return new DocOffsetAndVirtualModel(offset, 0, Boolean.valueOf(false));
        }
        if (ignoreVirtualDelta) {
            n = 0;
        } else {
            Editor editor = $this$createModelPosition.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            n = UtilKt.calcVirtualDelta(editor, offset, (VisualPosition)calcVisualPosition.invoke());
        }
        int virtualDelta = n;
        return new DocOffsetAndVirtualModel(offset, virtualDelta, Boolean.valueOf($this$createModelPosition.getLogicalPosition().leansForward));
    }

    public static final int calcVirtualDelta(@NotNull Editor editor, int caretOffset, @NotNull VisualPosition visualPosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)visualPosition, (String)"visualPosition");
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int delta = EditorModificationUtilEx.calcAfterLineEnd((Editor)editor, (int)caretOffset, (LogicalPosition)logicalPosition2, (VisualPosition)visualPosition);
        return delta < 0 ? 0 : delta;
    }

    @NotNull
    public static final RdSelectionChangeBase reverse(@NotNull RdSelectionChangeBase $this$reverse) {
        RdSelectionChangeBase rdSelectionChangeBase;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase2 = $this$reverse;
        if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateChange(((RdCaretStateChange)$this$reverse).getNewState(), ((RdCaretStateChange)$this$reverse).getOldState(), $this$reverse.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = $this$reverse;
        } else {
            throw new IllegalStateException(("unsupported change type " + $this$reverse).toString());
        }
        return rdSelectionChangeBase;
    }

    public static final void assertSameCaretState(@NotNull Logger $this$assertSameCaretState, @NotNull RdCaretState expectedState, @NotNull RdCaretState actualState) {
        Intrinsics.checkNotNullParameter((Object)$this$assertSameCaretState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedState, (String)"expectedState");
        Intrinsics.checkNotNullParameter((Object)actualState, (String)"actualState");
        if (!UtilKt.isEquivalentTo(actualState, expectedState)) {
            $this$assertSameCaretState.error("expected oldState: " + UtilKt.toDebugString(expectedState) + ", actual: " + UtilKt.toDebugString(actualState));
        }
    }

    public static final boolean isEquivalentTo(@NotNull RdCaretState $this$isEquivalentTo, @NotNull RdCaretState other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEquivalentTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$isEquivalentTo.getCarets().size() != other.getCarets().size() || !Intrinsics.areEqual((Object)$this$isEquivalentTo.getDocumentVersion(), (Object)other.getDocumentVersion()) || !Intrinsics.areEqual((Object)$this$isEquivalentTo.getPrimaryCaretId(), (Object)other.getPrimaryCaretId())) {
            return false;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)$this$isEquivalentTo.getCarets(), (Iterable)other.getCarets())) {
            RdCaret caret = (RdCaret)pair.component1();
            RdCaret otherCaret = (RdCaret)pair.component2();
            if (!(!Intrinsics.areEqual((Object)caret.getSelection().getStart(), (Object)caret.getSelection().getEnd()) ? !Intrinsics.areEqual((Object)caret.getSelection(), (Object)otherCaret.getSelection()) : !Intrinsics.areEqual((Object)caret.getOffset(), (Object)otherCaret.getOffset()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final RdDocumentChange reverse(@NotNull RdDocumentChange $this$reverse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        String string2 = $this$reverse.getText();
        if (string2 != null) {
            String string3 = string2;
            int n = $this$reverse.getOffset();
            int n2 = $this$reverse.getOffset() + $this$reverse.getNewText().length();
            CharSequence charSequence = $this$reverse.getOldText();
            string = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        } else {
            string = null;
        }
        String oldDocumentText = string;
        return new RdDocumentChange($this$reverse.getOffset(), $this$reverse.getMoveOffset(), $this$reverse.getOldText(), $this$reverse.getNewText(), $this$reverse.getModificationKind(), $this$reverse.getOldDocumentLength() - $this$reverse.getOldText().length() + $this$reverse.getNewText().length(), oldDocumentText, $this$reverse.isWholeTextReplaced(), $this$reverse.getDocumentId(), $this$reverse.getOldVersion(), $this$reverse.getNewVersion(), $this$reverse.getUniqueId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toDebugString(@NotNull RdCaretState $this$toDebugString) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        Iterable iterable = $this$toDebugString.getCarets();
        String string = UtilKt.toDebugString($this$toDebugString.getPrimaryCaretId());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.toDebugString((RdCaret)it));
        }
        return "(primary: " + string + ", carets: " + (List)destination$iv$iv + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaret $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(id: " + UtilKt.toDebugString($this$toDebugString.getId()) + ", offset: " + UtilKt.toDebugString($this$toDebugString.getOffset()) + ", selection: " + UtilKt.toDebugString($this$toDebugString.getSelection()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaretId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return ($this$toDebugString.isClient() ? "c" : "s") + $this$toDebugString.getNumber();
    }

    @NotNull
    public static final String toDebugString(@NotNull DocOffsetAndVirtualModel $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getOffset() + ", " + $this$toDebugString.getVirtualDelta() + ", " + $this$toDebugString.getLogicalLeansForward() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdSelection $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(start: " + UtilKt.toDebugString($this$toDebugString.getStart()) + " - end: " + UtilKt.toDebugString($this$toDebugString.getEnd()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull TextControlId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + DocumentExKt.toDebugString($this$toDebugString.getDocumentId()) + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getTabIndex() + ", " + $this$toDebugString.getKind() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getCompositeId() + ", " + $this$toDebugString.getProviderId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorCompositeId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getFileId() + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String createLogCategory(@NotNull TextControlId $this$createLogCategory) {
        Intrinsics.checkNotNullParameter((Object)$this$createLogCategory, (String)"<this>");
        String fileName = DocumentExKt.createLogCategory($this$createLogCategory.getDocumentId());
        int tabIndex = $this$createLogCategory.getTabIndex();
        TextControlLocation kind = $this$createLogCategory.getKind();
        return fileName + ", " + tabIndex + ", " + kind;
    }

    public static final int component1(@Nullable VisualPosition $this$component1) {
        VisualPosition visualPosition = $this$component1;
        return visualPosition != null ? visualPosition.line : -1;
    }

    public static final int component2(@Nullable VisualPosition $this$component2) {
        VisualPosition visualPosition = $this$component2;
        return visualPosition != null ? visualPosition.column : -1;
    }

    public static final int component1(@NotNull LogicalPosition $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.line;
    }

    public static final int component2(@NotNull LogicalPosition $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.column;
    }

    private static final boolean calculateVisibleRange$lambda$0(ProperTextRange $visibleRange, FoldRegion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $visibleRange.contains((Segment)it) && !it.isExpanded();
    }

    private static final RdTextRange calculateVisibleRange$lambda$1(FoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return new RdTextRange(region.getStartOffset(), region.getEndOffset());
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(UtilKt.class, "id", "getId(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", 1)))};
        $$delegatedProperties = kPropertyArray;
        id$delegate = UserDataHolderKt.userData$default(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScrollKind.values().length];
            try {
                nArray[ScrollKind.Smart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Relative.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Center.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.LowerHalf.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.UpperHalf.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

