/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.toolWindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.CodeWithMeBackendBundle;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.viewModel.extraction.ToolWindowExtractorMode;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowModeProvider;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/cwm/plugin/toolWindow/BackendToolwindowUnsupportedNotificationTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "hasFollowers", "", "addNotification", "", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "removeNotification", "MyNotification", "Companion", "intellij.cwm.plugin"})
public final class BackendToolwindowUnsupportedNotificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<Boolean> KEY;

    public BackendToolwindowUnsupportedNotificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection connection = this.project.getMessageBus().connect();
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.project, ClientId.Companion.getLocalId());
        Intrinsics.checkNotNull((Object)clientProjectSession);
        final ClientProjectSession session = clientProjectSession;
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (!this.hasFollowers()) {
                    return;
                }
                ToolWindowExtractorMode mode = BackendToolWindowModeProvider.INSTANCE.getBackendToolWindowMode(toolWindow.getId(), session);
                if (mode.isUnsupported()) {
                    this.addNotification(toolWindow);
                }
            }
        });
        Ref.BooleanRef isShown = new Ref.BooleanRef();
        UserManager.Companion.getInstance(this.project).getFollowers().advise(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> BackendToolwindowUnsupportedNotificationTracker._init_$lambda$0(this, isShown, session, arg_0));
        BoolPropertyExKt.whenFalse((IViewable)((IViewable)UserManager.Companion.getInstance(this.project).getSessionEnabled()), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> BackendToolwindowUnsupportedNotificationTracker._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final boolean hasFollowers() {
        return !((Collection)UserManager.Companion.getInstance(this.project).getFollowers()).isEmpty();
    }

    private final void addNotification(ToolWindow window) {
        if (window.getContentManagerIfCreated() == null) {
            return;
        }
        ToolWindowEx toolWindowEx = window instanceof ToolWindowEx ? (ToolWindowEx)window : null;
        InternalDecorator internalDecorator = toolWindowEx != null ? toolWindowEx.getDecorator() : null;
        InternalDecoratorImpl internalDecoratorImpl = internalDecorator instanceof InternalDecoratorImpl ? (InternalDecoratorImpl)internalDecorator : null;
        if (internalDecoratorImpl == null) {
            return;
        }
        InternalDecoratorImpl decorator2 = internalDecoratorImpl;
        if (Intrinsics.areEqual((Object)ClientProperty.get((Component)((Component)decorator2), KEY), (Object)true)) {
            return;
        }
        if (decorator2.getHeaderComponent() == null) {
            MyNotification notification = new MyNotification();
            notification.setText(CodeWithMeBackendBundle.INSTANCE.message("toolwindow.host.message.not.implemented.content", new Object[0]));
            notification.setToolTipText(CodeWithMeBackendBundle.INSTANCE.message("toolwindow.host.message.not.implemented.content", new Object[0]));
            notification.setCloseAction(() -> BackendToolwindowUnsupportedNotificationTracker.addNotification$lambda$0(decorator2));
            decorator2.setHeaderComponent((JComponent)((Object)notification));
        }
    }

    private final void removeNotification(ToolWindow window) {
        if (window.getContentManagerIfCreated() == null) {
            return;
        }
        ToolWindowEx toolWindowEx = window instanceof ToolWindowEx ? (ToolWindowEx)window : null;
        InternalDecorator internalDecorator = toolWindowEx != null ? toolWindowEx.getDecorator() : null;
        InternalDecoratorImpl internalDecoratorImpl = internalDecorator instanceof InternalDecoratorImpl ? (InternalDecoratorImpl)internalDecorator : null;
        if (internalDecoratorImpl == null) {
            return;
        }
        InternalDecoratorImpl decorator2 = internalDecoratorImpl;
        if (decorator2.getHeaderComponent() instanceof MyNotification) {
            decorator2.setHeaderComponent(null);
        }
    }

    private static final Unit _init_$lambda$0(BackendToolwindowUnsupportedNotificationTracker this$0, Ref.BooleanRef $isShown, ClientProjectSession $session, IViewableList.Event it) {
        block3: {
            boolean hasFollowers;
            block2: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                hasFollowers = this$0.hasFollowers();
                if (!hasFollowers || $isShown.element) break block2;
                $isShown.element = true;
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this$0.project);
                for (String id : toolWindowManager.getToolWindowIds()) {
                    ToolWindow window;
                    ToolWindowExtractorMode mode;
                    if (toolWindowManager.getToolWindow(id) == null || !(mode = BackendToolWindowModeProvider.INSTANCE.getBackendToolWindowMode(id, $session)).isUnsupported()) continue;
                    this$0.addNotification(window);
                }
                break block3;
            }
            if (hasFollowers || !$isShown.element) break block3;
            $isShown.element = false;
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this$0.project);
            for (String id : toolWindowManager.getToolWindowIds()) {
                ToolWindow window;
                if (toolWindowManager.getToolWindow(id) == null) continue;
                this$0.removeNotification(window);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(BackendToolwindowUnsupportedNotificationTracker this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this$0.project);
        for (String id : toolWindowManager.getToolWindowIds()) {
            InternalDecoratorImpl decorator2;
            ToolWindow window;
            if (toolWindowManager.getToolWindow(id) == null || window.getContentManagerIfCreated() == null) continue;
            ToolWindowEx toolWindowEx = window instanceof ToolWindowEx ? (ToolWindowEx)window : null;
            Object object = toolWindowEx != null ? toolWindowEx.getDecorator() : null;
            if ((object instanceof InternalDecoratorImpl ? (InternalDecoratorImpl)object : null) == null) continue;
            decorator2 = decorator2;
            ClientProperty.remove((JComponent)((JComponent)decorator2), KEY);
        }
        return Unit.INSTANCE;
    }

    private static final void addNotification$lambda$0(InternalDecoratorImpl $decorator) {
        if ($decorator.getHeaderComponent() instanceof MyNotification) {
            ClientProperty.put((JComponent)((JComponent)$decorator), KEY, (Object)true);
            $decorator.setHeaderComponent(null);
        }
    }

    static {
        Key key = Key.create((String)"skipNotImplementedNotification");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/toolWindow/BackendToolwindowUnsupportedNotificationTracker$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.cwm.plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/cwm/plugin/toolWindow/BackendToolwindowUnsupportedNotificationTracker$MyNotification;", "Lcom/intellij/ui/EditorNotificationPanel;", "<init>", "()V", "intellij.cwm.plugin"})
    private static final class MyNotification
    extends EditorNotificationPanel {
        public MyNotification() {
            super(JBUI.CurrentTheme.Validator.warningBackgroundColor());
        }
    }
}

