/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.connection;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.rd.platform.codeWithMe.fingerprint.Fingerprint;
import com.jetbrains.rd.platform.codeWithMe.fingerprint.FingerprintJsonManager;
import com.jetbrains.rd.platform.codeWithMe.fingerprint.HostFingerprint;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.connection.ClientAcceptState;
import com.jetbrains.rdserver.connection.HostCertificateUtilityKt;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.RdServerDirectConnectionsListener;
import com.jetbrains.rdserver.startup.RdServerPort;
import com.jetbrains.rdserver.startup.SecureClientData;
import com.jetbrains.rdserver.unattendedHost.connection.DirectConnectionDetails;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostConnectionManagerImpl;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostLifetimeService;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostTokenService;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImplKt;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020'J\u000e\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020,J\u000e\u0010/\u001a\u00020\u00142\u0006\u0010.\u001a\u00020,J\"\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u00102\u001a\u00020)2\u0006\u00103\u001a\u000204H\u0086@\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u0004\u0018\u000104J\u001c\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010(\u001a\u00020)2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u0002092\u0006\u0010:\u001a\u00020;R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl;", "", "<init>", "()V", "unattendedLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "unattendedModeSequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "value", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "unattendedModeLifetime", "getUnattendedModeLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "_connectionManager", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostConnectionManagerImpl;", "connectionManager", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "getConnectionManager", "()Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "isUnattendedMode", "", "()Z", "setUnattendedMode", "(Z)V", "remoteDevConnectionAddress", "Lkotlin/Pair;", "Ljava/net/InetAddress;", "", "getRemoteDevConnectionAddress", "()Lkotlin/Pair;", "setRemoteDevConnectionAddress", "(Lkotlin/Pair;)V", "currentConnectionDetails", "Lcom/jetbrains/rdserver/unattendedHost/connection/DirectConnectionDetails;", "initUnattendedMode", "address", "port", "Lcom/jetbrains/rdserver/startup/RdServerPort;", "attachToProjectIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "exitUnattendedMode", "lastClientJoinedViaPassword", "Lcom/intellij/codeWithMe/ClientId;", "setClientJoinedViaPassword", "clientId", "wasClientJoinedViaPassword", "createRemoteListener", "lifetime", "openProject", "projectPath", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remoteDevDirectLink", "shouldAutomaticallyAcceptGuest", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/rdserver/connection/ClientAcceptState;", "data", "Lcom/jetbrains/rdserver/startup/SecureClientData;", "shouldAutomaticallyAcceptController", "Companion", "intellij.platform.remoteController.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUnattendedModeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedModeManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 7 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 8 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,305:1\n42#2,3:306\n1#3:309\n14060#4,2:310\n67#5,4:312\n67#5,4:333\n60#5,5:343\n60#5,5:348\n60#5,5:353\n13#5:359\n22#6,17:316\n123#7:337\n112#7,5:338\n13#8:358\n*S KotlinDebug\n*F\n+ 1 UnattendedModeManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl\n*L\n102#1:306,3\n133#1:310,2\n214#1:312,4\n227#1:333,4\n267#1:343,5\n269#1:348,5\n278#1:353,5\n53#1:359\n225#1:316,17\n231#1:337\n231#1:338,5\n53#1:358\n*E\n"})
public final class UnattendedModeManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition unattendedLifetime;
    @NotNull
    private final SequentialLifetimes unattendedModeSequentialLifetimes;
    @NotNull
    private Lifetime unattendedModeLifetime;
    @NotNull
    private final UnattendedHostConnectionManagerImpl _connectionManager;
    private boolean isUnattendedMode;
    @Nullable
    private volatile Pair<? extends InetAddress, Integer> remoteDevConnectionAddress;
    @Nullable
    private DirectConnectionDetails currentConnectionDetails;
    @Nullable
    private ClientId lastClientJoinedViaPassword;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<String> UNATTENDED_HOST_PROJECT_PATH_KEY;
    @NotNull
    private static final Key<String> UNATTENDED_HOST_PROJECT_LINK_KEY;

    public UnattendedModeManagerImpl() {
        boolean $i$f$service = false;
        Class<UnattendedHostLifetimeService> serviceClass$iv = UnattendedHostLifetimeService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.unattendedLifetime = ((UnattendedHostLifetimeService)((Object)object)).getUnattendedLifetime();
        this.unattendedModeSequentialLifetimes = new SequentialLifetimes((Lifetime)this.unattendedLifetime);
        this.unattendedModeLifetime = Lifetime.Companion.getTerminated();
        this._connectionManager = new UnattendedHostConnectionManagerImpl((Lifetime)this.unattendedLifetime.createNested(), null);
    }

    @NotNull
    public final Lifetime getUnattendedModeLifetime() {
        return this.unattendedModeLifetime;
    }

    @NotNull
    public final RdServerConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public final boolean isUnattendedMode() {
        return this.isUnattendedMode;
    }

    public final void setUnattendedMode(boolean bl) {
        this.isUnattendedMode = bl;
    }

    @Nullable
    public final Pair<InetAddress, Integer> getRemoteDevConnectionAddress() {
        return this.remoteDevConnectionAddress;
    }

    public final void setRemoteDevConnectionAddress(@Nullable Pair<? extends InetAddress, Integer> pair) {
        this.remoteDevConnectionAddress = pair;
    }

    @NotNull
    public final DirectConnectionDetails initUnattendedMode(@Nullable InetAddress address, @NotNull RdServerPort port) {
        DirectConnectionDetails directConnectionDetails;
        Project[] projectArray;
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        DirectConnectionDetails directConnectionDetails2 = this.currentConnectionDetails;
        if (directConnectionDetails2 != null) {
            DirectConnectionDetails it = directConnectionDetails2;
            boolean bl = false;
            return it;
        }
        logger.info("Host switching to unattended mode, join requests will be denied/accepted programmatically..");
        this.isUnattendedMode = true;
        if (!this.unattendedModeSequentialLifetimes.isTerminated()) {
            logger.error("Attempting to initialize RD mode while previous init lifetime is still alive");
        }
        if ((projectArray = ProjectManager.getInstanceIfCreated()) != null && (projectArray = projectArray.getOpenProjects()) != null) {
            Project[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.attachToProjectIfNeeded(it);
            }
        }
        LifetimeDefinition listenerLifetime = this.unattendedModeSequentialLifetimes.next();
        this.unattendedModeLifetime = (Lifetime)listenerLifetime;
        listenerLifetime.onTermination(() -> UnattendedModeManagerImpl.initUnattendedMode$lambda$2(this));
        LifetimeCoroutineUtilKt.launch$default((Lifetime)((Lifetime)listenerLifetime), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            Object L$0;
            Object L$1;
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HostFingerprint currentFingerprint = new HostFingerprint(((SelfSignedCertificate.SelfSignedCertificateData)HostCertificateUtilityKt.getRemoteDevHostCertificate().getValue()).getFingerprint());
                        FingerprintJsonManager fingerprintJsonManager = new FingerprintJsonManager();
                        fingerprintJsonManager.writeSessionFingerprint((Fingerprint)currentFingerprint);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentFingerprint);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fingerprintJsonManager);
                        this.label = 1;
                        Object object2 = fingerprintJsonManager.startFingerprintTimeUpdates(() -> initUnattendedMode.4.invokeSuspend$lambda$0(currentFingerprint), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        FingerprintJsonManager fingerprintJsonManager = (FingerprintJsonManager)this.L$1;
                        HostFingerprint currentFingerprint = (HostFingerprint)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Fingerprint invokeSuspend$lambda$0(HostFingerprint $currentFingerprint) {
                return (Fingerprint)HostFingerprint.copy$default((HostFingerprint)$currentFingerprint, null, (long)System.currentTimeMillis(), null, (int)5, null);
            }
        }), (int)2, null);
        DirectConnectionDetails it = directConnectionDetails = this.createRemoteListener((Lifetime)listenerLifetime, address, port);
        boolean bl = false;
        this.currentConnectionDetails = it;
        return directConnectionDetails;
    }

    public final void attachToProjectIfNeeded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isUnattendedMode) {
            this._connectionManager.attachProject(project);
        }
    }

    public final void exitUnattendedMode() {
        logger.info("Host exiting unattended mode");
        this.isUnattendedMode = false;
        this.unattendedModeSequentialLifetimes.terminateCurrent();
    }

    public final void setClientJoinedViaPassword(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.lastClientJoinedViaPassword = clientId;
    }

    public final boolean wasClientJoinedViaPassword(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return Intrinsics.areEqual((Object)clientId, (Object)this.lastClientJoinedViaPassword);
    }

    private final DirectConnectionDetails createRemoteListener(Lifetime lifetime, InetAddress address, RdServerPort port) {
        logger.info("Create remote listener for unattended host");
        String testToken = System.getenv("CWM_UNATTENDED_HOST_TOKEN");
        if (testToken != null) {
            UnattendedHostTokenService.Companion.getInstance().setLocalTestToken(testToken);
        }
        String currentToken = UnattendedHostTokenService.Companion.getInstance().createOrGetSingleUseConnectionToken();
        RdServerDirectConnectionsListener rdServerDirectConnectionsListener = RdServerDirectConnectionsListener.Companion.getInstance();
        Pair listeningAddress = RdServerDirectConnectionsListener.startListener$default((RdServerDirectConnectionsListener)rdServerDirectConnectionsListener, (Lifetime)lifetime, (RdServerConnectionManager)this.getConnectionManager(), (InetAddress)address, (RdServerPort)port, (boolean)false, (boolean)false, (int)48, null);
        lifetime.bracketIfAlive(() -> UnattendedModeManagerImpl.createRemoteListener$lambda$0(this, listeningAddress), () -> UnattendedModeManagerImpl.createRemoteListener$lambda$1(this));
        return new DirectConnectionDetails((Pair<? extends InetAddress, Integer>)listeningAddress, currentToken);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object openProject(@NotNull String projectPath, @NotNull Continuation<? super Project> $completion) {
        if (!($completion instanceof openProject.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ UnattendedModeManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.openProject(null, (Continuation<? super Project>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = projectPath;
                $continuation.label = 1;
                v0 = com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl$Companion.access$prepareProject(UnattendedModeManagerImpl.Companion, projectPath, (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                projectPath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (Project)v0;
                if (v1 == null) {
                    throw new IllegalStateException(("Failed to initialize project: " + projectPath).toString());
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String remoteDevDirectLink() {
        String jreBuild;
        CharSequence charSequence;
        String fingerprint;
        Pair<? extends InetAddress, Integer> remoteConnectionAddress;
        String joinToken;
        block7: {
            void this_$iv$iv;
            void this_$iv;
            Logger logger;
            Logger $this$trace$iv = UnattendedModeManagerImpl.logger;
            boolean $i$f$trace22 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Get direct link for Unattended host connection. (unattended mode: " + this.isUnattendedMode + ")");
            }
            if (!this.isUnattendedMode) {
                return null;
            }
            joinToken = UnattendedHostTokenService.Companion.getInstance().createOrGetSingleUseConnectionToken();
            SpinWait.Companion $i$f$trace22 = SpinWait.Companion;
            long timeoutMs$iv = 1000L;
            boolean $i$f$spinUntil = false;
            void var6_11 = this_$iv;
            Lifetime lifetime$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil2 = false;
            void var9_16 = this_$iv$iv;
            Duration duration = Duration.ofMillis(timeoutMs$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv = duration;
            boolean $i$f$spinUntil3 = false;
            long start$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv = 0L;
            while (true) {
                boolean bl = false;
                if (this.remoteDevConnectionAddress != null || !RLifetimeKt.isAlive((Lifetime)lifetime$iv$iv) || System.nanoTime() - start$iv$iv$iv > duration$iv$iv$iv.toNanos()) break;
                long l = spins$iv$iv$iv;
                spins$iv$iv$iv = l + 1L;
                if (l < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv / (long)100);
            }
            Logger $this$trace$iv2 = UnattendedModeManagerImpl.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Got remote host connection address after timeout: " + this.remoteDevConnectionAddress);
            }
            Pair<? extends InetAddress, Integer> pair = this.remoteDevConnectionAddress;
            if (pair == null) {
                return null;
            }
            remoteConnectionAddress = pair;
            fingerprint = ((SelfSignedCertificate.SelfSignedCertificateData)HostCertificateUtilityKt.getRemoteDevHostCertificate().getValue()).getFingerprint();
            String string = ApplicationInfo.getInstance().getBuild().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String $this$trimStart$iv = string;
            boolean $i$f$trimStart = false;
            CharSequence $this$trimStart$iv$iv = $this$trimStart$iv;
            boolean $i$f$trimStart2 = false;
            int n = $this$trimStart$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (Character.isLetter(it) || it == '-') continue;
                charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                break block7;
            }
            charSequence = "";
        }
        String clientBuild = ((Object)charSequence).toString();
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        String string2 = jreBuild = UnattendedModeManagerImplKt.getJreBuild();
        Object jb = string2 == null ? "" : "&jb=" + string2;
        return new URI("tcp", null, ((InetAddress)remoteConnectionAddress.getFirst()).getHostAddress(), ((Number)remoteConnectionAddress.getSecond()).intValue(), null, null, "jt=" + joinToken + "&p=" + productCode + "&fp=" + fingerprint + "&cb=" + clientBuild + "&newUi=" + ExperimentalUI.Companion.isNewUI() + (String)jb).toASCIIString();
    }

    @NotNull
    public final CompletableFuture<ClientAcceptState> shouldAutomaticallyAcceptGuest(@NotNull Project project, @NotNull SecureClientData data) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CompletableFuture<ClientAcceptState> completableFuture = CompletableFuture.completedFuture(ClientAcceptState.Declined);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public final ClientAcceptState shouldAutomaticallyAcceptController(@NotNull SecureClientData data) {
        Logger logger;
        boolean $i$f$debug;
        Throwable t$iv;
        Logger $this$debug_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        UnattendedHostTokenService tokenService = UnattendedHostTokenService.Companion.getInstance();
        if (tokenService.hasClientUsedValidTokenPreviously(data)) {
            return ClientAcceptState.Accepted;
        }
        CharSequence charSequence = data.getSingleUseToken();
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$debug_u24default$iv = UnattendedModeManagerImpl.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Controller " + data.getUserName() + " is joining with token " + data.getSingleUseToken(), t$iv);
            }
            if (tokenService.verifySingleUseConnectionToken(data)) {
                $this$debug_u24default$iv = UnattendedModeManagerImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Accepting " + data.getUserName() + " because of valid token", t$iv);
                }
                return ClientAcceptState.Accepted;
            }
            UnattendedModeManagerImpl.logger.warn("Declining invalid token from " + data.getUserName());
        }
        if (tokenService.getHasPassword()) {
            $this$debug_u24default$iv = UnattendedModeManagerImpl.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Connecting client provided no valid token, requesting password " + data.getUserName(), t$iv);
            }
            return ClientAcceptState.Password;
        }
        UnattendedModeManagerImpl.logger.warn("No valid token, no password set, declining " + data.getUserName());
        return ClientAcceptState.Declined;
    }

    private static final Unit initUnattendedMode$lambda$2(UnattendedModeManagerImpl this$0) {
        this$0.currentConnectionDetails = null;
        return Unit.INSTANCE;
    }

    private static final Unit createRemoteListener$lambda$0(UnattendedModeManagerImpl this$0, Pair $listeningAddress) {
        this$0.remoteDevConnectionAddress = $listeningAddress;
        return Unit.INSTANCE;
    }

    private static final Unit createRemoteListener$lambda$1(UnattendedModeManagerImpl this$0) {
        this$0.remoteDevConnectionAddress = null;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnattendedModeManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedModeManagerImpl.logger = logger;
        UNATTENDED_HOST_PROJECT_PATH_KEY = new Key("UnattendedHostProjectPathKey");
        UNATTENDED_HOST_PROJECT_LINK_KEY = new Key("UnattendedHostProjectLinkKey");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl;", "UNATTENDED_HOST_PROJECT_PATH_KEY", "Lcom/intellij/openapi/util/Key;", "", "getUNATTENDED_HOST_PROJECT_PATH_KEY", "()Lcom/intellij/openapi/util/Key;", "UNATTENDED_HOST_PROJECT_LINK_KEY", "getUNATTENDED_HOST_PROJECT_LINK_KEY", "prepareProject", "Lcom/intellij/openapi/project/Project;", "projectPath", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toBooleanWithNumerics", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "shouldTrustAllProjects", "getShouldTrustAllProjects", "()Z", "intellij.platform.remoteController.backend"})
    @SourceDebugExtension(value={"SMAP\nUnattendedModeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedModeManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskKt\n+ 5 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskBuilder\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,305:1\n42#2,3:306\n1401#3,2:309\n217#4:311\n174#5,3:312\n179#5,32:316\n178#5:348\n23#6:315\n*S KotlinDebug\n*F\n+ 1 UnattendedModeManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedModeManagerImpl$Companion\n*L\n55#1:306,3\n61#1:309,2\n67#1:311\n67#1:312,3\n67#1:316,32\n67#1:348\n67#1:315\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnattendedModeManagerImpl getInstance() {
            boolean $i$f$service = false;
            Class<UnattendedModeManagerImpl> serviceClass$iv = UnattendedModeManagerImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (UnattendedModeManagerImpl)object;
        }

        @NotNull
        public final Key<String> getUNATTENDED_HOST_PROJECT_PATH_KEY() {
            return UNATTENDED_HOST_PROJECT_PATH_KEY;
        }

        @NotNull
        public final Key<String> getUNATTENDED_HOST_PROJECT_LINK_KEY() {
            return UNATTENDED_HOST_PROJECT_LINK_KEY;
        }

        /*
         * Unable to fully structure code
         */
        private final Object prepareProject(String projectPath, Continuation<? super Project> $completion) {
            if (!($completion instanceof prepareProject.1)) ** GOTO lbl-1000
            var35_3 = $completion;
            if ((var35_3.label & -2147483648) != 0) {
                var35_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    int I$1;
                    int I$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl$Companion.access$prepareProject(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var36_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = ProjectManager.getInstanceIfCreated();
                    if (v0 == null || (v0 = v0.getOpenProjects()) == null) ** GOTO lbl25
                    $this$firstOrNull$iv = v0;
                    $i$f$firstOrNull = false;
                    var9_13 = $this$firstOrNull$iv.length;
                    for (var8_11 = 0; var8_11 < var9_13; ++var8_11) {
                        it = element$iv = $this$firstOrNull$iv[var8_11];
                        $i$a$-firstOrNull-UnattendedModeManagerImpl$Companion$prepareProject$alreadyOpenProjectForPath$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getUserData(UnattendedModeManagerImpl.Companion.getUNATTENDED_HOST_PROJECT_PATH_KEY()), (Object)projectPath)) continue;
                        v1 = element$iv;
                        ** GOTO lbl26
                    }
                    v1 = null;
                    ** GOTO lbl26
lbl25:
                    // 1 sources

                    v1 = alreadyOpenProjectForPath = null;
lbl26:
                    // 3 sources

                    if (alreadyOpenProjectForPath != null) {
                        UnattendedModeManagerImpl.access$getLogger$cp().info("Project at path '" + projectPath + "' is already open");
                        return alreadyOpenProjectForPath;
                    }
                    projectPathPath = Path.of(projectPath, new String[0]);
                    $i$f$OpenProjectTask = 0;
                    this_$iv$iv = new OpenProjectTaskBuilder();
                    $i$f$build = 0;
                    $this$prepareProject_u24lambda_u241 = this_$iv$iv;
                    $i$a$-OpenProjectTask-UnattendedModeManagerImpl$Companion$prepareProject$options$1 = 0;
                    Intrinsics.checkNotNull((Object)projectPathPath);
                    $continuation.L$0 = projectPath;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)alreadyOpenProjectForPath);
                    $continuation.L$2 = projectPathPath;
                    $continuation.L$3 = this_$iv$iv;
                    $continuation.L$4 = $this$prepareProject_u24lambda_u241;
                    $continuation.I$0 = $i$f$OpenProjectTask;
                    $continuation.I$1 = $i$f$build;
                    $continuation.I$2 = $i$a$-OpenProjectTask-UnattendedModeManagerImpl$Companion$prepareProject$options$1;
                    $continuation.label = 1;
                    v2 = PlatformProjectOpenProcessor.Companion.configureToOpenDotIdeaOrCreateNewIfNotExists($this$prepareProject_u24lambda_u241, projectPathPath, null, (Continuation)$continuation);
                    if (v2 == var36_5) {
                        return var36_5;
                    }
                    ** GOTO lbl60
                }
                case 1: {
                    $i$a$-OpenProjectTask-UnattendedModeManagerImpl$Companion$prepareProject$options$1 = $continuation.I$2;
                    $i$f$build = $continuation.I$1;
                    $i$f$OpenProjectTask = $continuation.I$0;
                    $this$prepareProject_u24lambda_u241 = (OpenProjectTaskBuilder)$continuation.L$4;
                    this_$iv$iv = (OpenProjectTaskBuilder)$continuation.L$3;
                    projectPathPath = (Path)$continuation.L$2;
                    alreadyOpenProjectForPath = (Project)$continuation.L$1;
                    projectPath = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl60:
                    // 2 sources

                    $this$prepareProject_u24lambda_u241.setForceOpenInNewFrame(true);
                    $this$prepareProject_u24lambda_u241.setBeforeOpen((Function2)new Function2<Project, Continuation<? super Boolean>, Object>(null){
                        int label;
                        /* synthetic */ Object L$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            Project project = (Project)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (UnattendedModeManagerImpl.Companion.getShouldTrustAllProjects()) {
                                        void it;
                                        UnattendedModeManagerImpl.access$getLogger$cp().info("Auto-link the project since the configuration contains 'trust all projects'");
                                        ExternalSystemUnlinkedProjectSettings.Companion.getInstance((Project)it).setEnabledAutoLink(true);
                                    }
                                    return Boxing.boxBoolean((boolean)true);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(Project p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    if (this_$iv$iv.getProject() != null && this_$iv$iv.getCreateModule()) {
                        $this$thisLogger$iv$iv$iv = this_$iv$iv;
                        $i$f$thisLogger = false;
                        v3 = Logger.getInstance(OpenProjectTaskBuilder.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                        v4 = this_$iv$iv.getProject();
                        v3.warn("Project is explicitly set (name=" + (v4 != null ? v4.getName() : null) + "), but createModule is true");
                    }
                    var11_18 = this_$iv$iv.getForceOpenInNewFrame();
                    var12_19 = this_$iv$iv.getForceReuseFrame();
                    var13_24 = this_$iv$iv.getPreloadServices();
                    var9_14 = this_$iv$iv.getProjectToClose();
                    var10_16 = this_$iv$iv.isRefreshVfsNeeded();
                    var14_25 = this_$iv$iv.getProjectName();
                    var15_26 = this_$iv$iv.isNewProject();
                    v5 = this_$iv$iv.getUseDefaultProjectAsTemplate();
                    var16_27 = v5 != null ? v5.booleanValue() : this_$iv$iv.isNewProject();
                    var17_28 = this_$iv$iv.getRunConfigurators();
                    var18_29 = this_$iv$iv.isProjectCreatedWithWizard();
                    var19_30 = this_$iv$iv.getRunConversionBeforeOpen();
                    var20_31 = this_$iv$iv.getShowWelcomeScreen();
                    var21_32 = this_$iv$iv.getBeforeOpen();
                    var22_33 = this_$iv$iv.getBeforeInit();
                    var23_34 = this_$iv$iv.getPreparedToOpen();
                    var24_35 = this_$iv$iv.getCallback();
                    var25_36 = this_$iv$iv.getPreventIprLookup();
                    var26_37 = this_$iv$iv.getProcessorChooser();
                    var27_38 = this_$iv$iv.getProjectWorkspaceId();
                    var28_39 = this_$iv$iv.getImplOptions();
                    var29_40 = this_$iv$iv.getCreateModule();
                    var30_41 = this_$iv$iv.getLine();
                    var31_42 = this_$iv$iv.getColumn();
                    var32_43 = this_$iv$iv.getProject();
                    var33_44 = this_$iv$iv.getProjectRootDir();
                    options = new OpenProjectTask(var11_18 != false, var12_19 != false, var9_14, var15_26 != false, var16_27 != false, var32_43, var14_25, var20_31 != false, var24_35, var30_41, var31_42, var10_16 != false, var17_28 != false, var19_30 != false, var27_38, var18_29 != false, var13_24 != false, var22_33, var21_32, var23_34, var25_36 != false, var26_37, var28_39, var33_44, var29_40 != false);
                    UnattendedModeManagerImpl.access$getLogger$cp().info("Opening or importing a project against path " + projectPathPath);
                    Intrinsics.checkNotNull((Object)projectPathPath);
                    $continuation.L$0 = projectPath;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)alreadyOpenProjectForPath);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectPathPath);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)options);
                    $continuation.L$4 = null;
                    $continuation.label = 2;
                    v6 = ProjectUtil.INSTANCE.openOrImportAsync(projectPathPath, options, (Continuation)$continuation);
                    if (v6 == var36_5) {
                        return var36_5;
                    }
                    ** GOTO lbl117
                }
                case 2: {
                    options = (OpenProjectTask)$continuation.L$3;
                    projectPathPath = (Path)$continuation.L$2;
                    alreadyOpenProjectForPath = (Project)$continuation.L$1;
                    projectPath = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl117:
                    // 2 sources

                    if ((project = (Project)v6) == null) {
                        UnattendedModeManagerImpl.access$getLogger$cp().info("Project is not defined after opening");
                        return null;
                    }
                    project.putUserData(this.getUNATTENDED_HOST_PROJECT_PATH_KEY(), (Object)projectPath);
                    return project;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Boolean toBooleanWithNumerics(@Nullable String $this$toBooleanWithNumerics) {
            String string = $this$toBooleanWithNumerics;
            if (string == null) return null;
            int n = -1;
            switch (string.hashCode()) {
                case 48: {
                    if (string.equals("0")) {
                        n = 1;
                    }
                    break;
                }
                case 49: {
                    if (string.equals("1")) {
                        n = 2;
                    }
                    break;
                }
                case 3569038: {
                    if (string.equals("true")) {
                        n = 2;
                    }
                    break;
                }
                case 97196323: {
                    if (string.equals("false")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    Boolean bl = true;
                    return bl;
                }
                case 1: {
                    Boolean bl = false;
                    return bl;
                }
                default: {
                    return null;
                }
            }
        }

        public final boolean getShouldTrustAllProjects() {
            return Intrinsics.areEqual((Object)this.toBooleanWithNumerics(System.getenv("REMOTE_DEV_TRUST_PROJECTS")), (Object)true);
        }

        public static final /* synthetic */ Object access$prepareProject(Companion $this, String projectPath, Continuation $completion) {
            return $this.prepareProject(projectPath, (Continuation<? super Project>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

