/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.survey;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.ExternalFeedbackSurveyConfig;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.system.OS;
import com.jetbrains.rdserver.unattendedHost.CodeWithMeUnattendedHostBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/survey/OutOfDateGlibcSurveyConfig;", "Lcom/intellij/platform/feedback/ExternalFeedbackSurveyConfig;", "<init>", "()V", "getUrlToSurvey", "", "project", "Lcom/intellij/openapi/project/Project;", "surveyId", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "updateStateAfterRespondActionInvoked", "", "updateStateAfterNotificationShowed", "intellij.platform.remoteController.backend"})
public final class OutOfDateGlibcSurveyConfig
implements ExternalFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 6, 6);
    private final boolean requireIdeEAP;

    public OutOfDateGlibcSurveyConfig() {
        this.surveyId = "legacy_glibc_feedback";
    }

    @NotNull
    public String getUrlToSurvey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return "https://survey.alchemer.com/s3/8045952/RSCH-6053";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return true;
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (OS.CURRENT != OS.Linux) {
            return false;
        }
        OS.OsInfo osInfo = OS.CURRENT.getOsInfo();
        Intrinsics.checkNotNull((Object)osInfo, (String)"null cannot be cast to non-null type com.intellij.util.system.OS.LinuxInfo");
        Object object = ((OS.LinuxInfo)osInfo).getGlibcVersion();
        if (object == null || (object = StringsKt.toDoubleOrNull((String)object)) == null) {
            return false;
        }
        double versionNumber = (Double)object;
        return versionNumber < 2.28;
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)fullProductName);
        objectArray[0] = fullProductName;
        String string = CodeWithMeUnattendedHostBundle.INSTANCE.message("glibc.survey.notification.title", objectArray);
        objectArray = new Object[]{fullProductName};
        return new RequestFeedbackNotification("com.jetbrains.rdserver.unattendedHost.Notification", string, CodeWithMeUnattendedHostBundle.INSTANCE.message("glibc.survey.notification.text", objectArray));
    }

    public void updateStateAfterRespondActionInvoked(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

