/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.refactoring;

import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.resolve.PbImportReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a:\u0010\u0006\u001a,\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\b0\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"collectDuplicatedImportsSkipOriginal", "", "Lcom/intellij/protobuf/lang/psi/PbImportStatement;", "file", "Lcom/intellij/protobuf/lang/psi/PbFile;", "collectDuplicatedImportsIncludeOriginal", "analyzeImports", "Lkotlin/Pair;", "", "", "removeDuplicatedImports", "", "duplicates", "", "intellij.protoeditor.core"})
@SourceDebugExtension(value={"SMAP\nPbDuplicatedImportAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbDuplicatedImportAnalyzer.kt\ncom/intellij/protobuf/lang/refactoring/PbDuplicatedImportAnalyzerKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,56:1\n4253#2,12:57\n19#3:69\n*S KotlinDebug\n*F\n+ 1 PbDuplicatedImportAnalyzer.kt\ncom/intellij/protobuf/lang/refactoring/PbDuplicatedImportAnalyzerKt\n*L\n33#1:57,12\n35#1:69\n*E\n"})
public final class PbDuplicatedImportAnalyzerKt {
    @NotNull
    public static final Collection<PbImportStatement> collectDuplicatedImportsSkipOriginal(@NotNull PbFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CollectionsKt.flatten((Iterable)((Map)PbDuplicatedImportAnalyzerKt.analyzeImports(file).getSecond()).values());
    }

    @NotNull
    public static final Collection<PbImportStatement> collectDuplicatedImportsIncludeOriginal(@NotNull PbFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<Map<PbFile, PbImportStatement>, Map<PbFile, List<PbImportStatement>>> pair = PbDuplicatedImportAnalyzerKt.analyzeImports(file);
        Map originalImports = (Map)pair.component1();
        Map duplicatesWithoutOriginal = (Map)pair.component2();
        List allImportsWithDuplicates = new ArrayList();
        for (Map.Entry duplicate : duplicatesWithoutOriginal.entrySet()) {
            CollectionsKt.addAll((Collection)allImportsWithDuplicates, (Iterable)((Iterable)duplicate.getValue()));
            PbImportStatement duplicatedImport = (PbImportStatement)originalImports.get(duplicate.getKey());
            if (duplicatedImport == null) continue;
            ((Collection)allImportsWithDuplicates).add(duplicatedImport);
        }
        return allImportsWithDuplicates;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Map<PbFile, PbImportStatement>, Map<PbFile, List<PbImportStatement>>> analyzeImports(PbFile file) {
        Map originalGoodImports = new LinkedHashMap();
        Map duplicatesWithoutOriginal = new LinkedHashMap();
        for (PbImportStatement importStatement : file.getImportStatements()) {
            void $this$asSafely$iv;
            PsiElement psiElement;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            PsiReference[] psiReferenceArray;
            PbImportName pbImportName = importStatement.getImportName();
            if (pbImportName == null || (psiReferenceArray = pbImportName.getReferences()) == null) continue;
            Object object = psiReferenceArray;
            boolean $i$f$filterIsInstance = false;
            PbFile pbFile = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PbImportReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (PbImportReference)((Object)CollectionsKt.singleOrNull((List)((List)destination$iv$iv)));
            if (object == null || (psiElement = object.resolve()) == null) continue;
            destination$iv$iv = psiElement;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof PbFile)) {
                v0 = null;
            }
            if ((pbFile = (PbFile)v0) == null) continue;
            PbFile importedFile = pbFile;
            if (originalGoodImports.containsKey(importedFile)) {
                if (duplicatesWithoutOriginal.get(importedFile) == null) {
                    duplicatesWithoutOriginal.put(importedFile, (List)new ArrayList());
                }
                List list = (List)duplicatesWithoutOriginal.get(importedFile);
                if (list != null) {
                    Intrinsics.checkNotNull((Object)importStatement);
                    list.add(importStatement);
                }
                continue;
            }
            originalGoodImports.put(importedFile, importStatement);
        }
        return TuplesKt.to((Object)originalGoodImports, (Object)duplicatesWithoutOriginal);
    }

    public static final void removeDuplicatedImports(@NotNull PbFile file, @NotNull Set<? extends PbImportStatement> duplicates) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
        for (PbImportStatement importStatement : file.getImportStatements()) {
            if (!duplicates.contains(importStatement)) continue;
            importStatement.delete();
        }
    }
}

