/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.main;

import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInnerClassInstrumenter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumenter;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class TestDiscoveryTransformer
extends AbstractIntellijClassfileTransformer {
    private static final boolean COUNTERS_IN_INNER_CLASS = System.getProperty("idea.test.discovery.counters.in.inner.class") != null;
    private final List<Pattern> exclude;
    private final List<Pattern> include;

    /*
     * WARNING - void declaration
     */
    public TestDiscoveryTransformer(List<Pattern> exclude, List<Pattern> include) {
        void var2_2;
        void var1_1;
        this.exclude = var1_1;
        this.include = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassVisitor cw) {
        void var1_1;
        void var3_3;
        if (COUNTERS_IN_INNER_CLASS) {
            void var2_2;
            return new TestDiscoveryInnerClassInstrumenter(cw, cr, className, (ClassLoader)var2_2);
        }
        return new TestDiscoveryInstrumenter(cw, (ClassReader)var3_3, (String)var1_1);
    }

    @Override
    protected boolean shouldExclude(String className) {
        for (Pattern pattern : this.exclude) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        for (Pattern pattern : this.include) {
            if (!pattern.matcher(className).matches()) continue;
            return false;
        }
        return !this.include.isEmpty();
    }
}

