/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.license.FeaturesCheckKt;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionProfileLoader;
import org.jetbrains.qodana.staticAnalysis.profile.GroupState;
import org.jetbrains.qodana.staticAnalysis.profile.MainInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.ProfilesKt;
import org.jetbrains.qodana.staticAnalysis.profile.PromoInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.SanityInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.providers.QodanaEmbeddedProfile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "", "mainGroup", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "additionalGroups", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "licenseType", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;Ljava/util/List;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/license/QodanaLicenseType;)V", "getMainGroup", "()Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "allGroups", "getAllGroups", "()Ljava/util/List;", "idToEffectiveGroup", "", "", "getIdToEffectiveGroup", "()Ljava/util/Map;", "effectiveProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "getEffectiveProfile", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "effectiveProfile$delegate", "Lkotlin/Lazy;", "checkUnknownScopes", "", "createState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "Companion", "QodanaProfileState", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n1300#2,2:169\n1315#2,4:171\n1266#2,4:177\n1266#2,4:183\n1915#2,2:187\n466#3:175\n415#3:176\n481#3:181\n427#3:182\n13#4:189\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile\n*L\n135#1:169,2\n135#1:171,4\n136#1:177,4\n138#1:183,4\n110#1:187,2\n136#1:175\n136#1:176\n138#1:181\n138#1:182\n35#1:189\n*E\n"})
public final class QodanaProfile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MainInspectionGroup mainGroup;
    @NotNull
    private final List<NamedInspectionGroup> additionalGroups;
    @NotNull
    private final Project project;
    @NotNull
    private final QodanaLicenseType licenseType;
    @NotNull
    private final List<NamedInspectionGroup> allGroups;
    @NotNull
    private final Map<String, NamedInspectionGroup> idToEffectiveGroup;
    @NotNull
    private final Lazy effectiveProfile$delegate;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public QodanaProfile(@NotNull MainInspectionGroup mainGroup, @NotNull List<? extends NamedInspectionGroup> additionalGroups, @NotNull Project project, @NotNull QodanaLicenseType licenseType) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)mainGroup, (String)"mainGroup");
        Intrinsics.checkNotNullParameter(additionalGroups, (String)"additionalGroups");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        this.mainGroup = mainGroup;
        this.additionalGroups = additionalGroups;
        this.project = project;
        this.licenseType = licenseType;
        this.allGroups = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.mainGroup), (Iterable)this.additionalGroups);
        Map map3 = map2 = (Map)new LinkedHashMap();
        QodanaProfile qodanaProfile = this;
        boolean bl = false;
        for (NamedInspectionGroup group : this.allGroups) {
            for (ToolsImpl tool : group.getProfile().getTools()) {
                void $this$idToEffectiveGroup_u24lambda_u240;
                if (!tool.isEnabled()) continue;
                $this$idToEffectiveGroup_u24lambda_u240.putIfAbsent(tool.getShortName(), group);
            }
        }
        qodanaProfile.idToEffectiveGroup = map2;
        this.effectiveProfile$delegate = LazyKt.lazy(() -> QodanaProfile.effectiveProfile_delegate$lambda$0(this));
    }

    @NotNull
    public final MainInspectionGroup getMainGroup() {
        return this.mainGroup;
    }

    @NotNull
    public final List<NamedInspectionGroup> getAllGroups() {
        return this.allGroups;
    }

    @NotNull
    public final Map<String, NamedInspectionGroup> getIdToEffectiveGroup() {
        return this.idToEffectiveGroup;
    }

    @NotNull
    public final QodanaInspectionProfile getEffectiveProfile() {
        Lazy lazy = this.effectiveProfile$delegate;
        return (QodanaInspectionProfile)((Object)lazy.getValue());
    }

    private final void checkUnknownScopes(QodanaInspectionProfile effectiveProfile) {
        List list2 = effectiveProfile.getAllEnabledInspectionTools(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllEnabledInspectionTools(...)");
        List tools = list2;
        Set seen = new LinkedHashSet();
        for (Tools tool : tools) {
            for (ScopeToolState scopeState : tool.getTools()) {
                if (scopeState.getScope(this.project) != null) continue;
                String string = scopeState.getScopeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeName(...)");
                if (!seen.add(string)) continue;
                LOG.warn("Unknown scope in profile: '" + scopeState.getScopeName() + "'");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QodanaProfileState createState(@NotNull QodanaGlobalInspectionContext context) {
        Map map2;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map.Entry it$iv$iv;
        Object object;
        Map.Entry entry;
        Iterable $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        GroupState groupState;
        Map map3;
        Object object2;
        Map $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        MainInspectionGroup.State mainState = this.mainGroup.createState(context);
        Iterable $this$associateWith$iv = this.additionalGroups;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Object object3 = $this$associateWithTo$iv$iv.iterator();
        while (object3.hasNext()) {
            void it;
            Object element$iv$iv = object3.next();
            NamedInspectionGroup namedInspectionGroup = (NamedInspectionGroup)element$iv$iv;
            object2 = element$iv$iv;
            map3 = destination$iv$iv;
            boolean bl = false;
            groupState = it.createState(context);
            map3.put(object2, groupState);
        }
        Map states = MapsKt.plus((Map)destination$iv$iv, (Pair)TuplesKt.to((Object)this.mainGroup, (Object)mainState));
        Map $this$mapValues$iv = this.idToEffectiveGroup;
        boolean $i$f$mapValues = false;
        $this$associateWithTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        object3 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv$iv;
            boolean bl3 = false;
            object = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            map3 = map4;
            boolean bl2 = false;
            NamedInspectionGroup value2 = (NamedInspectionGroup)object.getValue();
            Object v = states.get(value2);
            Intrinsics.checkNotNull(v);
            groupState = (GroupState)v;
            map3.put(object2, groupState);
        }
        Map statesMap = destination$iv$iv$iv;
        $this$mapValues$iv = states;
        Map map5 = statesMap;
        groupState = mainState;
        boolean $i$f$mapKeys = false;
        $this$mapValuesTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        destination$iv$iv$iv = destination$iv$iv;
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv2;
            void it;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            object = ((NamedInspectionGroup)it.getKey()).getName();
            Map map6 = map2;
            boolean bl4 = false;
            entry = it$iv$iv2.getValue();
            map6.put(object, entry);
        }
        Map map7 = map2 = destination$iv$iv$iv;
        Map map8 = map5;
        GroupState groupState2 = groupState;
        return new QodanaProfileState((MainInspectionGroup.State)groupState2, map8, map7);
    }

    private static final QodanaInspectionProfile effectiveProfile_delegate$lambda$0(QodanaProfile this$0) {
        QodanaInspectionProfile effectiveProfile = QodanaInspectionProfile.Companion.newWithDisabledTools("qodana.effective.profile", QodanaInspectionProfileManager.Companion.getInstance(this$0.project));
        for (NamedInspectionGroup group : this$0.allGroups) {
            for (ToolsImpl tools : group.getProfile().getTools()) {
                ToolsImpl to;
                if (!tools.isEnabled() || !Intrinsics.areEqual((Object)group, (Object)this$0.idToEffectiveGroup.get(tools.getShortName())) || (to = effectiveProfile.getToolsOrNull(tools.getShortName(), this$0.project)) == null) continue;
                Intrinsics.checkNotNull((Object)tools);
                ProfilesKt.copyTool(to, tools, this$0.project);
                ProfilesKt.copyDependentTools(this$0.project, tools, group.getProfile(), effectiveProfile);
            }
        }
        Collection collection = effectiveProfile.getTools();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTools(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ToolsImpl tool = (ToolsImpl)element$iv;
            boolean bl = false;
            QodanaLicenseType qodanaLicenseType = this$0.licenseType;
            Intrinsics.checkNotNull((Object)tool);
            if (FeaturesCheckKt.isInspectionLicensed(qodanaLicenseType, tool)) continue;
            tool.setEnabled(false);
        }
        this$0.checkUnknownScopes(effectiveProfile);
        return effectiveProfile;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(QodanaProfile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0011*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "project", "Lcom/intellij/openapi/project/Project;", "mainInspectionProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "inspectionProfileLoader", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionProfileLoader;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "sanity", "", "promo", "isRecommendedOrStarter", "(Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)Z", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,168:1\n1276#2,2:169\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion\n*L\n83#1:169,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaProfile create(@NotNull Project project, @NotNull QodanaInspectionProfile mainInspectionProfile, @NotNull QodanaInspectionProfileLoader inspectionProfileLoader, @NotNull QodanaConfig config, boolean sanity, boolean promo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)mainInspectionProfile), (String)"mainInspectionProfile");
            Intrinsics.checkNotNullParameter((Object)((Object)inspectionProfileLoader), (String)"inspectionProfileLoader");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean addDefaultExclude = this.isRecommendedOrStarter(mainInspectionProfile);
            List inspectionGroups = new ArrayList();
            if (sanity) {
                String sanityProfileName = System.getProperty("qodana.sanity.profile.name", "qodana.sanity");
                Intrinsics.checkNotNull((Object)sanityProfileName);
                QodanaInspectionProfile sanityProfile = inspectionProfileLoader.loadProfileByName(sanityProfileName);
                if (sanityProfile != null) {
                    inspectionGroups.add(new SanityInspectionGroup("sanity", sanityProfile).applyConfig(config, project, addDefaultExclude));
                    LOG.info("The '" + sanityProfileName + "' profile is configured for sanity checks");
                } else {
                    LOG.warn("Can't load the '" + sanityProfileName + "' sanity profile. Running sanity inspections is disabled.");
                }
            }
            if (promo) {
                String promoProfileName = System.getProperty("qodana.promo.profile.name", "qodana.recommended");
                Intrinsics.checkNotNull((Object)promoProfileName);
                QodanaInspectionProfile promoProfile = inspectionProfileLoader.loadProfileByName(promoProfileName);
                if (promoProfile != null) {
                    inspectionGroups.add(new PromoInspectionGroup("promo", promoProfile).applyConfig(config, project, addDefaultExclude));
                    LOG.info("The '" + promoProfileName + "' profile is configured for promo checks");
                } else {
                    LOG.warn("Can't load the '" + promoProfileName + "' promo profile. Running promo inspections is disabled.");
                }
            }
            MainInspectionGroup userGroup = new MainInspectionGroup(mainInspectionProfile).applyConfig(config, project, addDefaultExclude);
            return new QodanaProfile(userGroup, inspectionGroups, project, config.getLicense().getType());
        }

        private final boolean isRecommendedOrStarter(QodanaInspectionProfile $this$isRecommendedOrStarter) {
            boolean bl;
            block1: {
                QodanaEmbeddedProfile[] qodanaEmbeddedProfileArray = new QodanaEmbeddedProfile[]{QodanaEmbeddedProfile.QODANA_RECOMMENDED_OLD, QodanaEmbeddedProfile.QODANA_STARTER_OLD};
                Sequence $this$any$iv = SequencesKt.sequenceOf((Object[])qodanaEmbeddedProfileArray);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    QodanaEmbeddedProfile it = (QodanaEmbeddedProfile)((Object)element$iv);
                    boolean bl2 = false;
                    String string = $this$isRecommendedOrStarter.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!it.matchesName(string)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0015R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "", "mainState", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "stateByInspectionId", "", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/GroupState;", "stateByGroupName", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;Ljava/util/Map;Ljava/util/Map;)V", "getMainState", "()Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "getStateByInspectionId", "()Ljava/util/Map;", "getStateByGroupName", "receivedCounters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "onReceive", "", "inspectionId", "size", "dump", "shouldSkip", "", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "onFinish", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1915#2,2:169\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState\n*L\n165#1:169,2\n*E\n"})
    public static final class QodanaProfileState {
        @NotNull
        private final MainInspectionGroup.State mainState;
        @NotNull
        private final Map<String, GroupState> stateByInspectionId;
        @NotNull
        private final Map<String, GroupState> stateByGroupName;
        @NotNull
        private final ConcurrentHashMap<String, Integer> receivedCounters;

        public QodanaProfileState(@NotNull MainInspectionGroup.State mainState, @NotNull Map<String, ? extends GroupState> stateByInspectionId, @NotNull Map<String, ? extends GroupState> stateByGroupName) {
            Intrinsics.checkNotNullParameter((Object)mainState, (String)"mainState");
            Intrinsics.checkNotNullParameter(stateByInspectionId, (String)"stateByInspectionId");
            Intrinsics.checkNotNullParameter(stateByGroupName, (String)"stateByGroupName");
            this.mainState = mainState;
            this.stateByInspectionId = stateByInspectionId;
            this.stateByGroupName = stateByGroupName;
            this.receivedCounters = new ConcurrentHashMap();
        }

        @NotNull
        public final MainInspectionGroup.State getMainState() {
            return this.mainState;
        }

        @NotNull
        public final Map<String, GroupState> getStateByInspectionId() {
            return this.stateByInspectionId;
        }

        @NotNull
        public final Map<String, GroupState> getStateByGroupName() {
            return this.stateByGroupName;
        }

        public final void onReceive(@NotNull String inspectionId, int size) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            this.receivedCounters.compute(inspectionId, new BiFunction(size){
                final /* synthetic */ int $size;
                {
                    this.$size = $size;
                }

                public final Integer apply(String string, Integer v) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
                    Integer n = v;
                    return n == null ? Integer.valueOf(this.$size) : Integer.valueOf(n + this.$size);
                }
            });
        }

        public final void dump() {
            Set<Map.Entry<String, Integer>> set = this.receivedCounters.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            String receivedMessage = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, QodanaProfileState::dump$lambda$0, (int)30, null);
            LOG.debug("Received counters:\n " + receivedMessage);
        }

        public final boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file2, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
            GroupState groupState = this.stateByInspectionId.get(inspectionId);
            return groupState != null ? groupState.shouldSkip(inspectionId, file2, wrappers) : false;
        }

        public final void onFinish() {
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)this.stateByInspectionId.values());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GroupState it = (GroupState)element$iv;
                boolean bl = false;
                it.onFinish();
            }
        }

        private static final CharSequence dump$lambda$0(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String id = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Integer counter = (Integer)v;
            return "InspectionId:" + id + " received: " + counter;
        }
    }
}

