/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rJ\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "problemsFound", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Key;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Value;", "addInspectionFinishedEvent", "", "problemsCount", "", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "logProblemsFound", "getSummaryFor", "Lkotlin/Pair;", "inspectionId", "", "Companion", "Key", "Value", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionProblemsFoundAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionProblemsFoundAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n1915#2,2:72\n221#3,2:74\n*S KotlinDebug\n*F\n+ 1 InspectionProblemsFoundAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService\n*L\n50#1:72,2\n62#1:74,2\n*E\n"})
public final class InspectionProblemsFoundAggregatorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Key, Value> problemsFound;

    public InspectionProblemsFoundAggregatorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.problemsFound = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addInspectionFinishedEvent(int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind) {
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind == InspectListener.InspectionKind.LOCAL_PRIORITY) {
            return;
        }
        String string = tool.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        this.problemsFound.compute(new Key(string), new BiFunction(problemsCount, tool){
            final /* synthetic */ int $problemsCount;
            final /* synthetic */ InspectionToolWrapper<?, ?> $tool;
            {
                this.$problemsCount = $problemsCount;
                this.$tool = $tool;
            }

            public final Value apply(Key key, Value v) {
                Value value2;
                Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
                if (v == null) {
                    value2 = new Value(this.$problemsCount, 1, this.$tool);
                } else {
                    Value value3 = v;
                    value3.setProblemsCount(value3.getProblemsCount() + this.$problemsCount);
                    value3 = v;
                    value3.setFilesCount(value3.getFilesCount() + 1);
                    value2 = v;
                }
                return value2;
            }
        });
    }

    public final void logProblemsFound() {
        Collection<Value> collection = this.problemsFound.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Value value2 = (Value)element$iv;
            boolean bl = false;
            InspectionEventsCollector.logInspectionProblemsFound(value2.getProblemsCount(), value2.getFilesCount(), value2.getTool(), this.project);
        }
    }

    @TestOnly
    @NotNull
    public final Pair<Integer, Integer> getSummaryFor(@NotNull String inspectionId) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        int files2 = 0;
        int problems = 0;
        Map $this$forEach$iv = this.problemsFound;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Key k = (Key)entry.getKey();
            Value v = (Value)entry.getValue();
            if (!Intrinsics.areEqual((Object)k.getInspectionId(), (Object)inspectionId)) continue;
            files2 += v.getFilesCount();
            problems += v.getProblemsCount();
        }
        return TuplesKt.to((Object)files2, (Object)problems);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionProblemsFoundAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionProblemsFoundAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,71:1\n75#2:72\n*S KotlinDebug\n*F\n+ 1 InspectionProblemsFoundAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Companion\n*L\n22#1:72\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstance(@NotNull Project project, @NotNull Continuation<? super InspectionProblemsFoundAggregatorService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(InspectionProblemsFoundAggregatorService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Key;", "", "inspectionId", "", "<init>", "(Ljava/lang/String;)V", "getInspectionId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.qodana"})
    private static final class Key {
        @NotNull
        private final String inspectionId;

        public Key(@NotNull String inspectionId) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            this.inspectionId = inspectionId;
        }

        @NotNull
        public final String getInspectionId() {
            return this.inspectionId;
        }

        @NotNull
        public final String component1() {
            return this.inspectionId;
        }

        @NotNull
        public final Key copy(@NotNull String inspectionId) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            return new Key(inspectionId);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.inspectionId;
            }
            return key.copy(string);
        }

        @NotNull
        public String toString() {
            return "Key(inspectionId=" + this.inspectionId + ")";
        }

        public int hashCode() {
            return this.inspectionId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            return Intrinsics.areEqual((Object)this.inspectionId, (Object)key.inspectionId);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u0019\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionProblemsFoundAggregatorService$Value;", "", "problemsCount", "", "filesCount", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "<init>", "(IILcom/intellij/codeInspection/ex/InspectionToolWrapper;)V", "getProblemsCount", "()I", "setProblemsCount", "(I)V", "getFilesCount", "setFilesCount", "getTool", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "intellij.qodana"})
    private static final class Value {
        private int problemsCount;
        private int filesCount;
        @NotNull
        private final InspectionToolWrapper<?, ?> tool;

        public Value(int problemsCount, int filesCount, @NotNull InspectionToolWrapper<?, ?> tool) {
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            this.problemsCount = problemsCount;
            this.filesCount = filesCount;
            this.tool = tool;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        public final void setProblemsCount(int n) {
            this.problemsCount = n;
        }

        public final int getFilesCount() {
            return this.filesCount;
        }

        public final void setFilesCount(int n) {
            this.filesCount = n;
        }

        @NotNull
        public final InspectionToolWrapper<?, ?> getTool() {
            return this.tool;
        }
    }
}

