/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.history.core.revisions.Difference;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.diff.PresentableFileDifferenceKt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/PresentableDifference;", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "difference", "Lcom/intellij/history/core/revisions/Difference;", "targetFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lcom/intellij/history/core/revisions/Difference;Lcom/intellij/openapi/vcs/FilePath;)V", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "getFilePath", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "equals", "", "other", "", "hashCode", "", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public class PresentableDifference
implements PresentableChange {
    @NotNull
    private final ActivityScope scope;
    @NotNull
    private final ChangeSetSelection selection;
    @NotNull
    private final Difference difference;
    @NotNull
    private final FilePath targetFilePath;

    public PresentableDifference(@NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, @NotNull Difference difference, @NotNull FilePath targetFilePath) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)difference, (String)"difference");
        Intrinsics.checkNotNullParameter((Object)targetFilePath, (String)"targetFilePath");
        this.scope = scope;
        this.selection = selection;
        this.difference = difference;
        this.targetFilePath = targetFilePath;
    }

    @NotNull
    public final Difference getDifference() {
        return this.difference;
    }

    @NotNull
    public FilePath getFilePath() {
        return this.targetFilePath;
    }

    @NotNull
    public FileStatus getFileStatus() {
        return PresentableFileDifferenceKt.fileStatus(this.difference.getLeft() != null, this.difference.getRight() != null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PresentableDifference)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scope, (Object)((PresentableDifference)other).scope)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selection, (Object)((PresentableDifference)other).selection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.difference, (Object)((PresentableDifference)other).difference);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.scope, this.selection, this.difference};
        return Objects.hash(objectArray);
    }
}

