/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleJVMIssuePatternMatcher;", "", "<init>", "()V", "JVM_VERSION_ISSUE_PATTERN_8_8", "Lkotlin/text/Regex;", "JVM_VERSION_ISSUE_PATTERN_6_4", "JVM_VERSION_ISSUE_PATTERN_6_4_CLEANER", "JVM_VERSION_ISSUE_PATTERN_6_2", "JVM_VERSION_ISSUE_PATTERN_6_2_CLEANER", "JVM_VERSION_ISSUE_PATTERN_6_0", "JVM_VERSION_ISSUE_JUNIT6_START", "", "analyzeFailureMessage", "Lorg/jetbrains/plugins/gradle/issue/GradleJVMIssuePatternMatcher$GradleJVMIssueMatchResult;", "failureMessage", "GradleJVMIssueMatchResult", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleJVMIssuePatternMatcher {
    @NotNull
    public static final GradleJVMIssuePatternMatcher INSTANCE = new GradleJVMIssuePatternMatcher();
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_8_8 = new Regex("is only compatible with JVM runtime version (\\d+) or newer\\.");
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_6_4 = new Regex("Incompatible because this component declares a component( for use during compile-time)?,? compatible with Java (\\d+) and the consumer needed a component( for use during runtime)?,? compatible with Java (\\d+)");
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_6_4_CLEANER = new Regex("\\n {6}- Other compatible attributes?:[^\\n]*(\\n {10}[^\\n]*)*");
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_6_2 = new Regex("Required org\\.gradle\\.jvm\\.version '(\\d+)' and found incompatible value '(\\d+)'\\.");
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_6_2_CLEANER = new Regex("\\n {6}- Other attributes?:[^\\n]*(\\n {10}[^\\n]*)*");
    @NotNull
    private static final Regex JVM_VERSION_ISSUE_PATTERN_6_0 = new Regex("Required org\\.gradle\\.jvm\\.version '(\\d+)' but no value provided\\.");
    @NotNull
    private static final String JVM_VERSION_ISSUE_JUNIT6_START = "Cannot choose between the following variants of org.junit.jupiter:junit-jupiter:6";

    private GradleJVMIssuePatternMatcher() {
    }

    @Nullable
    public final GradleJVMIssueMatchResult analyzeFailureMessage(@Nullable String failureMessage) {
        GradleJVMIssueMatchResult gradleJVMIssueMatchResult;
        CharSequence charSequence = failureMessage;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_8_8, (CharSequence)failureMessage, (int)0, (int)2, null) != null) {
            Object object = Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_8_8, (CharSequence)failureMessage, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                return null;
            }
            int requiredVersion = Integer.parseInt((String)object);
            gradleJVMIssueMatchResult = new GradleJVMIssueMatchResult(((Object)StringsKt.trim((CharSequence)failureMessage)).toString(), requiredVersion);
        } else if (Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_6_4, (CharSequence)failureMessage, (int)0, (int)2, null) != null) {
            CharSequence charSequence2 = failureMessage;
            Regex regex = JVM_VERSION_ISSUE_PATTERN_6_4_CLEANER;
            String string = "";
            cleanedMessage = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence2, string))).toString();
            Object object = Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_6_4, (CharSequence)failureMessage, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(2)) == null) {
                return null;
            }
            int requiredVersion = Integer.parseInt((String)object);
            gradleJVMIssueMatchResult = new GradleJVMIssueMatchResult(cleanedMessage, requiredVersion);
        } else if (Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_6_2, (CharSequence)failureMessage, (int)0, (int)2, null) != null) {
            CharSequence requiredVersion = failureMessage;
            Regex regex = JVM_VERSION_ISSUE_PATTERN_6_2_CLEANER;
            String string = "";
            cleanedMessage = ((Object)StringsKt.trim((CharSequence)regex.replace(requiredVersion, string))).toString();
            Object object = Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_6_2, (CharSequence)failureMessage, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(2)) == null) {
                return null;
            }
            int requiredVersion2 = Integer.parseInt((String)object);
            gradleJVMIssueMatchResult = new GradleJVMIssueMatchResult(cleanedMessage, requiredVersion2);
        } else if (StringsKt.startsWith$default((String)failureMessage, (String)JVM_VERSION_ISSUE_JUNIT6_START, (boolean)false, (int)2, null)) {
            Object object = Regex.find$default((Regex)JVM_VERSION_ISSUE_PATTERN_6_0, (CharSequence)failureMessage, (int)0, (int)2, null);
            Integer currentGradleJVM = object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
            Object[] objectArray = new Object[]{currentGradleJVM};
            String description = GradleBundle.message("gradle.build.issue.unresolved.dependency.junit6.gradle6.description", objectArray);
            Intrinsics.checkNotNull((Object)description);
            gradleJVMIssueMatchResult = new GradleJVMIssueMatchResult(description, 17);
        } else {
            gradleJVMIssueMatchResult = null;
        }
        return gradleJVMIssueMatchResult;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleJVMIssuePatternMatcher$GradleJVMIssueMatchResult;", "", "cleanedMessage", "", "requiredJvmVersion", "", "<init>", "(Ljava/lang/String;I)V", "getCleanedMessage", "()Ljava/lang/String;", "getRequiredJvmVersion", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.gradle"})
    public static final class GradleJVMIssueMatchResult {
        @NotNull
        private final String cleanedMessage;
        private final int requiredJvmVersion;

        public GradleJVMIssueMatchResult(@NotNull String cleanedMessage, int requiredJvmVersion) {
            Intrinsics.checkNotNullParameter((Object)cleanedMessage, (String)"cleanedMessage");
            this.cleanedMessage = cleanedMessage;
            this.requiredJvmVersion = requiredJvmVersion;
        }

        @NotNull
        public final String getCleanedMessage() {
            return this.cleanedMessage;
        }

        public final int getRequiredJvmVersion() {
            return this.requiredJvmVersion;
        }

        @NotNull
        public final String component1() {
            return this.cleanedMessage;
        }

        public final int component2() {
            return this.requiredJvmVersion;
        }

        @NotNull
        public final GradleJVMIssueMatchResult copy(@NotNull String cleanedMessage, int requiredJvmVersion) {
            Intrinsics.checkNotNullParameter((Object)cleanedMessage, (String)"cleanedMessage");
            return new GradleJVMIssueMatchResult(cleanedMessage, requiredJvmVersion);
        }

        public static /* synthetic */ GradleJVMIssueMatchResult copy$default(GradleJVMIssueMatchResult gradleJVMIssueMatchResult, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = gradleJVMIssueMatchResult.cleanedMessage;
            }
            if ((n2 & 2) != 0) {
                n = gradleJVMIssueMatchResult.requiredJvmVersion;
            }
            return gradleJVMIssueMatchResult.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "GradleJVMIssueMatchResult(cleanedMessage=" + this.cleanedMessage + ", requiredJvmVersion=" + this.requiredJvmVersion + ")";
        }

        public int hashCode() {
            int result = this.cleanedMessage.hashCode();
            result = result * 31 + Integer.hashCode(this.requiredJvmVersion);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GradleJVMIssueMatchResult)) {
                return false;
            }
            GradleJVMIssueMatchResult gradleJVMIssueMatchResult = (GradleJVMIssueMatchResult)other;
            if (!Intrinsics.areEqual((Object)this.cleanedMessage, (Object)gradleJVMIssueMatchResult.cleanedMessage)) {
                return false;
            }
            return this.requiredJvmVersion == gradleJVMIssueMatchResult.requiredJvmVersion;
        }
    }
}

