/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.mass;

import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.ide.ui.mass.Change;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.SuppressionPattern;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u00020\bH\u0096\u0080\u0004R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/ide/ui/mass/IgnoreChange;", "Lcom/intellij/grazie/ide/ui/mass/Change;", "problem", "Lcom/intellij/grazie/text/TextProblem;", "change", "<init>", "(Lcom/intellij/grazie/text/TextProblem;Lcom/intellij/grazie/ide/ui/mass/Change;)V", "presentableText", "", "apply", "", "revert", "toString", "intellij.grazie.core"})
final class IgnoreChange
implements Change {
    @Nullable
    private final Change change;
    @NotNull
    private final String presentableText;

    public IgnoreChange(@NotNull TextProblem problem, @Nullable Change change) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        SuppressionPattern suppressionPattern = new CheckerRunner(textContent).defaultSuppressionPattern(problem, null);
        String string = StringUtil.shortenTextWithEllipsis((String)suppressionPattern.getErrorText(), (int)50, (int)20);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String errorText = string;
        Object[] objectArray = new Object[]{errorText};
        this.presentableText = GrazieBundle.message("grazie.grammar.quickfix.ignore.text.no.context", objectArray);
        this.change = change;
    }

    @Override
    public void apply() {
        block0: {
            Change change = this.change;
            if (change == null) break block0;
            change.revert();
        }
    }

    @Override
    public void revert() {
        block0: {
            Change change = this.change;
            if (change == null) break block0;
            change.apply();
        }
    }

    @NotNull
    public String toString() {
        return this.presentableText;
    }
}

