/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.engine;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageISO;
import ai.grazie.nlp.utils.normalization.Normalizer;
import ai.grazie.nlp.utils.normalization.StripAccentsNormalizer;
import ai.grazie.spell.GrazieSpeller;
import ai.grazie.spell.GrazieSplittingSpeller;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.dictionary.rule.IgnoreRuleDictionary;
import ai.grazie.spell.language.LanguageModel;
import ai.grazie.spell.lists.WordList;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.filter.feature.RadiusSuggestionFilter;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.utils.mpp.Resources;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.grazie.spellcheck.async.WordListLoader;
import com.intellij.grazie.spellcheck.dictionary.ExtendedWordListWithFrequency;
import com.intellij.grazie.spellcheck.dictionary.WordListAdapter;
import com.intellij.grazie.spellcheck.engine.GrazieSpellCheckerEngine;
import com.intellij.grazie.spellcheck.engine.SuggestionRequest;
import com.intellij.grazie.spellcheck.hunspell.HunspellDictionary;
import com.intellij.grazie.spellcheck.ranker.DiacriticSuggestionRanker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerEngineListener;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.spellchecker.settings.CustomDictionarySettingsListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.AbstractSet;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0003;<=B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u0004\u0018\u00010\u001dJ\b\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u0017H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010.\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0016J\b\u00103\u001a\u00020\u001fH\u0016J\u0010\u00104\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u00106\u001a\u00020\u0017H\u0016J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u0017H\u0016J\b\u00109\u001a\u00020\u001fH\u0007J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0012\u001a\u001e\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u0015\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\b\u00150\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine;", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getTransformation", "Lcom/intellij/spellchecker/engine/Transformation;", "loader", "Lcom/intellij/grazie/spellcheck/async/WordListLoader;", "adapter", "Lcom/intellij/grazie/spellcheck/dictionary/WordListAdapter;", "replacingRules", "", "Lai/grazie/spell/dictionary/RuleDictionary;", "suggestionCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/grazie/spellcheck/engine/SuggestionRequest;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "", "getSuggestionCache$annotations", "()V", "createSpellerConfig", "Lai/grazie/spell/GrazieSpeller$UserConfig;", "speller", "Lai/grazie/spell/Speller;", "initializeSpeller", "", "getSpeller", "dispose", "isDictionaryLoad", "", "name", "getDictionaryNames", "loadDictionary", "Lcom/intellij/spellchecker/dictionary/Loader;", "addDictionary", "dictionary", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "addModifiableDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "isCorrect", "word", "getSuggestions", "maxSuggestions", "", "maxMetrics", "reset", "removeDictionary", "getVariants", "prefix", "removeDictionariesRecursively", "directory", "dropSuggestionCache", "getReplacingRules", "Companion", "SpellerLoadActivity", "SuggestionCacheInvalidator", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieSpellCheckerEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellCheckerEngine.kt\ncom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n777#2:227\n873#2,2:228\n*S KotlinDebug\n*F\n+ 1 GrazieSpellCheckerEngine.kt\ncom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine\n*L\n195#1:227\n195#1:228,2\n*E\n"})
public final class GrazieSpellCheckerEngine
implements SpellCheckerEngine,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final WordListLoader loader;
    @NotNull
    private final WordListAdapter adapter;
    @NotNull
    private final Set<RuleDictionary> replacingRules;
    @NotNull
    private final LoadingCache<SuggestionRequest, List<String>> suggestionCache;
    @Nullable
    private volatile Speller speller;
    @NotNull
    private static final Lazy<HunspellDictionary> enDictionary$delegate = LazyKt.lazy(GrazieSpellCheckerEngine::enDictionary_delegate$lambda$0);

    public GrazieSpellCheckerEngine(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.loader = new WordListLoader(project, this.coroutineScope);
        this.adapter = new WordListAdapter();
        this.replacingRules = this.getReplacingRules();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initializeSpeller(project);
        }
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(1024L).build(new CacheLoader(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final List<String> load(SuggestionRequest request2) {
                List list;
                Speller speller;
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Speller speller2 = GrazieSpellCheckerEngine.access$getSpeller$p(this.this$0);
                Intrinsics.checkNotNull((Object)speller2);
                Speller speller3 = speller = speller2;
                synchronized (speller3) {
                    boolean bl = false;
                    list = CollectionsKt.take((Iterable)speller.suggest(request2.word, request2.maxSuggestions), (int)request2.maxSuggestions);
                }
                return list;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.suggestionCache = loadingCache;
    }

    @NotNull
    public Transformation getTransformation() {
        return new Transformation();
    }

    private static /* synthetic */ void getSuggestionCache$annotations() {
    }

    private final GrazieSpeller.UserConfig createSpellerConfig() {
        ExtendedWordListWithFrequency wordList = new ExtendedWordListWithFrequency((WordListWithFrequency)Companion.getEnDictionary().getDict(), this.adapter);
        return new GrazieSpeller.UserConfig(new LanguageModel(Language.ENGLISH, (WordListWithFrequency)wordList, (RuleDictionary)new RuleDictionary.Aggregated(this.replacingRules), (SuggestionRanker)new DiacriticSuggestionRanker(LanguageModel.Companion.getRanker(Language.ENGLISH, (WordListWithFrequency)wordList)), (SuggestionFilter)new RadiusSuggestionFilter(0.05), (Normalizer)new StripAccentsNormalizer(), arg_0 -> GrazieSpellCheckerEngine.createSpellerConfig$lambda$0(this, arg_0)), null, 2, null);
    }

    @ApiStatus.Internal
    public final void initializeSpeller(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrazieSplittingSpeller speller = new GrazieSplittingSpeller((Speller)new GrazieSpeller(this.createSpellerConfig()), new GrazieSplittingSpeller.UserConfig(null, 0, null, null, 15, null));
        if (this.speller == null) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readAction(() -> initializeSpeller.1.invokeSuspend$lambda$0(this.$project), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(Project $project) {
                    MessageBus messageBus = $project.getMessageBus();
                    Topic topic = SpellCheckerEngineListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((SpellCheckerEngineListener)messageBus.syncPublisher(topic)).onSpellerInitialized();
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
        this.speller = (Speller)speller;
    }

    @Nullable
    public final Speller getSpeller() {
        return this.speller;
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public boolean isDictionaryLoad(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.adapter.containsSource(name);
    }

    @NotNull
    public Set<String> getDictionaryNames() {
        return this.adapter.getDictionaryNames();
    }

    public void loadDictionary(@NotNull Loader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader.loadWordList(loader, (Function2<? super String, ? super WordList, Unit>)((Function2)new Function2<String, WordList, Unit>((Object)this.adapter){

            public final void invoke(String p0, WordList p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((WordListAdapter)this.receiver).addList(p0, p1);
            }
        }));
    }

    public void addDictionary(@NotNull Dictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        String string = dictionary.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isDictionaryLoad(string)) {
            this.adapter.addDictionary(dictionary);
        }
    }

    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        this.addDictionary((Dictionary)dictionary);
    }

    public boolean isCorrect(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (((CharSequence)word).length() == 0) {
            return true;
        }
        Speller speller = this.speller;
        if (speller == null) {
            return true;
        }
        Speller speller2 = speller;
        if (word.length() > 32) {
            return true;
        }
        if (speller2.isAlien(word)) {
            return true;
        }
        return !speller2.isMisspelled(word, false);
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int maxMetrics) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.speller == null) {
            return CollectionsKt.emptyList();
        }
        if (word.length() > 32) {
            return CollectionsKt.emptyList();
        }
        Object object = this.suggestionCache.get((Object)new SuggestionRequest(word, maxSuggestions));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    public void reset() {
        this.adapter.reset();
    }

    public void removeDictionary(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.adapter.removeSource(name);
    }

    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public void removeDictionariesRecursively(@NotNull String directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Iterable $this$filter$iv = this.adapter.getNames();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl = false;
            if (!(FileUtil.isAncestor((String)directory, (String)name, (boolean)false) && this.isDictionaryLoad(name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        for (String name : toRemove) {
            this.adapter.removeSource(name);
        }
    }

    @TestOnly
    public final void dropSuggestionCache() {
        this.suggestionCache.invalidateAll();
    }

    private final Set<RuleDictionary> getReplacingRules() {
        return (Set)new AbstractSet<RuleDictionary>(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public int getSize() {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - void declaration
             */
            public Iterator<RuleDictionary> iterator() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] objectArray = new RuleDictionary[2];
                objectArray[0] = IgnoreRuleDictionary.Companion.standard(2);
                Intrinsics.checkNotNull((Object)GrazieSpellCheckerEngine.Companion.getEnDictionary().getRuleDictionary());
                Set replacingRules = SetsKt.mutableSetOf((Object[])objectArray);
                Iterable iterable = this.this$0.getDictionaryNames();
                GrazieSpellCheckerEngine grazieSpellCheckerEngine = this.this$0;
                boolean $i$f$map22 = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(GrazieSpellCheckerEngine.access$getAdapter$p(grazieSpellCheckerEngine).getDictionary((String)it));
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$map22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    RuleDictionary it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Dictionary it = (Dictionary)element$iv$iv;
                    boolean bl2 = false;
                    HunspellDictionary hunspellDictionary = it instanceof HunspellDictionary ? (HunspellDictionary)it : null;
                    if ((hunspellDictionary != null ? hunspellDictionary.getRuleDictionary() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set hunspellReplacingRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                return SetsKt.plus((Set)replacingRules, (Iterable)hunspellReplacingRules).iterator();
            }
        };
    }

    private static final boolean createSpellerConfig$lambda$0(GrazieSpellCheckerEngine this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.adapter.isAlien(it);
    }

    private static final HunspellDictionary enDictionary_delegate$lambda$0() {
        String dic = Resources.INSTANCE.text("/dictionary/en.dic");
        String aff = Resources.INSTANCE.text("/dictionary/en.aff");
        List trigrams = StringsKt.lines((CharSequence)Resources.INSTANCE.text("/dictionary/en.trigrams.txt"));
        return new HunspellDictionary(dic, aff, trigrams, "/dictionary/en.dic", LanguageISO.EN, Resources.INSTANCE.text("/rule/en.dat"));
    }

    @JvmStatic
    @NotNull
    public static final GrazieSpellCheckerEngine getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ WordListAdapter access$getAdapter$p(GrazieSpellCheckerEngine $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ Speller access$getSpeller$p(GrazieSpellCheckerEngine $this) {
        return $this.speller;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine;", "project", "Lcom/intellij/openapi/project/Project;", "enDictionary", "Lcom/intellij/grazie/spellcheck/hunspell/HunspellDictionary;", "getEnDictionary", "()Lcom/intellij/grazie/spellcheck/hunspell/HunspellDictionary;", "enDictionary$delegate", "Lkotlin/Lazy;", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GrazieSpellCheckerEngine getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SpellCheckerEngine spellCheckerEngine = SpellCheckerEngine.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)spellCheckerEngine, (String)"null cannot be cast to non-null type com.intellij.grazie.spellcheck.engine.GrazieSpellCheckerEngine");
            return (GrazieSpellCheckerEngine)spellCheckerEngine;
        }

        @NotNull
        public final HunspellDictionary getEnDictionary() {
            Lazy lazy = enDictionary$delegate;
            return (HunspellDictionary)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine$SpellerLoadActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieSpellCheckerEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellCheckerEngine.kt\ncom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine$SpellerLoadActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,226:1\n75#2:227\n*S KotlinDebug\n*F\n+ 1 GrazieSpellCheckerEngine.kt\ncom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine$SpellerLoadActivity\n*L\n84#1:227\n*E\n"})
    public static final class SpellerLoadActivity
    implements ProjectActivity {
        public SpellerLoadActivity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Companion.getInstance(project).initializeSpeller(project);
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            Object object = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(SpellCheckerManager.class, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grazie/spellcheck/engine/GrazieSpellCheckerEngine$SuggestionCacheInvalidator;", "Lcom/intellij/spellchecker/settings/CustomDictionarySettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "customDictionaryPathsChanged", "", "newPaths", "", "", "intellij.grazie.core"})
    public static final class SuggestionCacheInvalidator
    implements CustomDictionarySettingsListener {
        @NotNull
        private final Project project;

        public SuggestionCacheInvalidator(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void customDictionaryPathsChanged(@NotNull List<String> newPaths) {
            Intrinsics.checkNotNullParameter(newPaths, (String)"newPaths");
            Companion.getInstance(this.project).suggestionCache.invalidateAll();
        }
    }
}

