/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/SetBreakpointCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nSetBreakpointCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetBreakpointCommand.kt\ncom/jetbrains/performancePlugin/commands/SetBreakpointCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n777#2:106\n873#2,2:107\n*S KotlinDebug\n*F\n+ 1 SetBreakpointCommand.kt\ncom/jetbrains/performancePlugin/commands/SetBreakpointCommand\n*L\n80#1:106\n80#1:107,2\n*E\n"})
public final class SetBreakpointCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%setBreakpoint";

    public SetBreakpointCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Ref.BooleanRef isLambdaBreakpoint = new Ref.BooleanRef();
        ArrayList arguments = this.extractCommandList(PREFIX, ",");
        if (arguments.size() == 0) {
            callback2.reject("Usage %setBreakpoint &lt;line&gt; [&lt;relative_path&gt;, lambda-type]");
            return;
        }
        Object e = arguments.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        int lineNumber = Integer.parseInt((String)e);
        VirtualFile file = null;
        if (arguments.contains("lambda-type")) {
            arguments.remove("lambda-type");
            isLambdaBreakpoint.element = true;
        }
        if (arguments.size() == 1) {
            FileEditor selectedEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
            if (selectedEditor == null) {
                callback2.reject("No opened editor");
                return;
            }
            VirtualFile virtualFile = selectedEditor.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            file = virtualFile;
        } else {
            String relativePath = (String)arguments.get(1);
            Intrinsics.checkNotNull((Object)relativePath);
            VirtualFile virtualFile = OpenFileCommand.Companion.findFile(relativePath, project2);
            if (virtualFile == null) {
                Object[] objectArray = new Object[]{relativePath};
                String string = PerformanceTestingBundle.message("command.file.not.found", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                throw new IllegalStateException(string2.toString());
            }
            file = virtualFile;
        }
        String filePath = "file://" + file.getPath();
        XSourcePosition xSourcePosition = new XDebuggerUtilImpl().createPosition(file, lineNumber - 1);
        Intrinsics.checkNotNull((Object)xSourcePosition);
        List breakpointTypes = XBreakpointUtil.getAvailableLineBreakpointTypes$default((XBreakpointUtil)XBreakpointUtil.INSTANCE, (Project)project2, (XSourcePosition)xSourcePosition, null, (boolean)false, (int)8, null);
        if (breakpointTypes.isEmpty()) {
            callback2.reject("Impossible to set breakpoint on line " + lineNumber);
            return;
        }
        WriteAction.runAndWait(() -> SetBreakpointCommand.execute$lambda$0(project2, filePath, isLambdaBreakpoint, breakpointTypes, file, lineNumber, callback2));
        callback2.setDone();
    }

    /*
     * WARNING - void declaration
     */
    private static final void execute$lambda$0(Project $project, String $filePath, Ref.BooleanRef $isLambdaBreakpoint, List $breakpointTypes, VirtualFile $file, int $lineNumber, ActionCallback $callback) {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)$project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        VirtualFileManager.getInstance().refreshAndFindFileByUrl($filePath);
        XLineBreakpointType breakpointType = null;
        XBreakpointProperties breakpointProperties = null;
        if ($isLambdaBreakpoint.element) {
            void $this$filterTo$iv$iv;
            Promise promise = XDebuggerUtilImpl.getLineBreakpointVariants((Project)$project, (List)$breakpointTypes, (XSourcePosition)((XSourcePosition)XSourcePositionImpl.create((VirtualFile)$file, (int)($lineNumber - 1))));
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getLineBreakpointVariants(...)");
            List it = (List)Promises.asCompletableFuture((Promise)promise).get();
            Intrinsics.checkNotNull((Object)it);
            Iterable $this$filter$iv = it;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                XLineBreakpointType.XLineBreakpointVariant a = (XLineBreakpointType.XLineBreakpointVariant)element$iv$iv;
                boolean bl = false;
                String string = a.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(!StringsKt.contains$default((CharSequence)string, (CharSequence)"Line", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lambdaVariants = (List)destination$iv$iv;
            if (lambdaVariants.isEmpty()) {
                $callback.reject("Impossible to set lambda breakpoint to line " + $lineNumber);
                return;
            }
            XLineBreakpointType.XLineBreakpointVariant lambdaVariant = (XLineBreakpointType.XLineBreakpointVariant)CollectionsKt.first((List)lambdaVariants);
            XLineBreakpointType xLineBreakpointType = lambdaVariant.getType();
            Intrinsics.checkNotNull((Object)xLineBreakpointType, (String)"null cannot be cast to non-null type com.intellij.xdebugger.breakpoints.XLineBreakpointType<com.intellij.xdebugger.breakpoints.XBreakpointProperties<*>>");
            breakpointType = xLineBreakpointType;
            XBreakpointProperties xBreakpointProperties = lambdaVariant.createProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties);
            breakpointProperties = xBreakpointProperties;
        } else {
            Object object = CollectionsKt.first((List)$breakpointTypes);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.xdebugger.breakpoints.XLineBreakpointType<com.intellij.xdebugger.breakpoints.XBreakpointProperties<*>>");
            breakpointType = (XLineBreakpointType)object;
            XBreakpointProperties xBreakpointProperties = breakpointType.createBreakpointProperties($file, $lineNumber - 1);
            Intrinsics.checkNotNull((Object)xBreakpointProperties);
            breakpointProperties = xBreakpointProperties;
        }
        XLineBreakpoint xLineBreakpoint = breakpointManager.addLineBreakpoint(breakpointType, $filePath, $lineNumber - 1, breakpointProperties);
        Intrinsics.checkNotNullExpressionValue((Object)xLineBreakpoint, (String)"addLineBreakpoint(...)");
        XLineBreakpoint breakpoint = xLineBreakpoint;
        breakpointManager.updateBreakpointPresentation(breakpoint, null, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/SetBreakpointCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

