/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.cwm;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.downloader.CodeWithMeGuestLauncher;
import com.intellij.remoteDev.util.RemoteDevProtocolUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.api.GatewayUrlHandler;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/gateway/cwm/CodeWithMeUrlHandler;", "Lcom/jetbrains/gateway/api/GatewayUrlHandler;", "<init>", "()V", "tryConnect", "Lorg/jetbrains/concurrency/Promise;", "", "key", "", "rest", "requestor", "Lcom/jetbrains/gateway/api/ConnectionRequestor;", "Companion", "Util", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nCodeWithMeUrlHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeUrlHandler.kt\ncom/jetbrains/gateway/cwm/CodeWithMeUrlHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 CodeWithMeUrlHandler.kt\ncom/jetbrains/gateway/cwm/CodeWithMeUrlHandler\n*L\n18#1:80\n*E\n"})
public final class CodeWithMeUrlHandler
implements GatewayUrlHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @Nullable
    public Promise<Unit> tryConnect(@NotNull String key, @NotNull String rest, @NotNull ConnectionRequestor requestor) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        Intrinsics.checkNotNullParameter((Object)((Object)requestor), (String)"requestor");
        if (StringsKt.equals((String)key, (String)"cwm", (boolean)true)) {
            AsyncPromise promise = new AsyncPromise();
            Util.INSTANCE.performConnect(rest, (Function0<Unit>)((Function0)() -> CodeWithMeUrlHandler.tryConnect$lambda$0(promise)));
            return (Promise)promise;
        }
        return null;
    }

    private static final Unit tryConnect$lambda$0(AsyncPromise $promise) {
        $promise.setResult((Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeUrlHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/cwm/CodeWithMeUrlHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/cwm/CodeWithMeUrlHandler$Util;", "", "<init>", "()V", "performConnect", "", "url", "", "onDone", "Lkotlin/Function0;", "intellij.gateway.core"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final void performConnect(@NotNull String url, @NotNull Function0<Unit> onDone2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(onDone2, (String)"onDone");
            LOG.info("Performing connect with link: '" + url + "'");
            String gatewayPrefixUntilParams = "jetbrains-gateway://connect#";
            String httpPrefixUntilParams = "https://code-with-me.jetbrains.com/remoteDev#";
            if (StringsKt.startsWith$default((String)url, (String)gatewayPrefixUntilParams, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)httpPrefixUntilParams, (boolean)false, (int)2, null)) {
                int offset = 0;
                offset = StringsKt.startsWith$default((String)url, (String)"jetbrains-gateway://connect", (boolean)false, (int)2, null) ? gatewayPrefixUntilParams.length() : httpPrefixUntilParams.length();
                String string = url.substring(offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String rest = string;
                Map params = RemoteDevProtocolUtil.INSTANCE.parseParamsString(rest);
                GatewayUI.connect$default(GatewayUI.Companion.getInstance(), params, null, 2, null);
            } else {
                CodeWithMeGuestLauncher codeWithMeGuestLauncher = CodeWithMeGuestLauncher.INSTANCE;
                String string = GatewayBundle.INSTANCE.message("connector.cwm.dialog.title", new Object[0]);
                codeWithMeGuestLauncher.downloadCompatibleClientAndLaunch(null, null, null, url, string, true, arg_0 -> Util.performConnect$lambda$0(onDone2, arg_0));
            }
        }

        private static final Unit performConnect$lambda$0(Function0 $onDone, Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            $onDone.invoke();
            if (RLifetimeKt.isNotAlive((Lifetime)lifetime)) {
                return Unit.INSTANCE;
            }
            if (PlatformUtils.isGateway()) {
                GatewayConnectionFrameManager.Companion.getInstance().closeWelcomeFrame();
            } else {
                GatewayUI.Companion.getInstance().reset();
            }
            return Unit.INSTANCE;
        }
    }
}

