/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.LegacySettingsTransferWizard;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.JsonKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StateDatabaseParserKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StateDatabaseParser;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "recentsKey", "", "process", "", "file", "Ljava/io/File;", "parseRecents", "connection", "Ljava/sql/Connection;", "getKey", "key", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nStateDatabaseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateDatabaseParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StateDatabaseParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n1642#2,10:84\n1915#2:94\n1916#2:96\n1652#2:97\n1#3:95\n82#4,3:98\n*S KotlinDebug\n*F\n+ 1 StateDatabaseParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/StateDatabaseParser\n*L\n55#1:84,10\n55#1:94\n55#1:96\n55#1:97\n55#1:95\n57#1:98,3\n*E\n"})
public final class StateDatabaseParser {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Settings settings;
    @NotNull
    private final String recentsKey;

    public StateDatabaseParser(@NotNull CoroutineScope scope, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.scope = scope;
        this.settings = settings;
        this.recentsKey = "history.recentlyOpenedPathsList";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LegacySettingsTransferWizard.INSTANCE.warnBackgroundThreadIfNotLegacy();
        try {
            File databaseFileToOpen = StateDatabaseParserKt.access$createTemporaryFileCopy(file);
            try {
                Class.forName("org.sqlite.JDBC");
                AutoCloseable autoCloseable = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)databaseFileToOpen.getPath()));
                Throwable throwable = null;
                try {
                    Connection connection = (Connection)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)connection);
                    this.parseRecents(connection);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
                BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(databaseFileToOpen, null){
                    int label;
                    final /* synthetic */ File $databaseFileToOpen;
                    {
                        this.$databaseFileToOpen = $databaseFileToOpen;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                StateDatabaseParserKt.access$cleanUpTempFile(this.$databaseFileToOpen);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                throw throwable;
            }
            BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
        }
        catch (Throwable t) {
            this.settings.getNotes().put("vscode.databaseState", false);
            StateDatabaseParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseRecents(Connection connection) {
        void $this$mapNotNullTo$iv$iv;
        String string = this.getKey(connection, this.recentsKey);
        if (string == null) {
            return;
        }
        String recentProjectsRaw = string;
        JsonNode jsonNode = JsonKt.getVsCodeJsonMapper().readTree(recentProjectsRaw);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
        }
        ObjectNode root = objectNode;
        JsonNode jsonNode2 = root.get("entries");
        Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        Iterable $this$mapNotNull$iv = (Iterable)((ArrayNode)jsonNode2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            JsonNode jsonNode3 = it.get("folderUri");
            if ((jsonNode3 != null ? jsonNode3.textValue() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        for (String uri : paths) {
            Logger $this$runAndLogException$iv = StateDatabaseParserKt.access$getLogger$p();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)(!this.settings.addRecentProjectIfNeeded((Function0<RecentPathInfo>)((Function0)() -> StateDatabaseParser.parseRecents$lambda$1$0(uri))) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Boolean bl = (Boolean)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            boolean shouldBreak = bl != null ? bl : false;
            if (!shouldBreak) continue;
            break;
        }
    }

    private final String getKey(Connection connection, String key) {
        String query = "SELECT value FROM ItemTable WHERE key is '" + key + "' LIMIT 1";
        ResultSet res2 = connection.createStatement().executeQuery(query);
        if (!res2.next()) {
            return null;
        }
        return res2.getString("value");
    }

    private static final RecentPathInfo parseRecents$lambda$1$0(String $uri) {
        return StorageParser.Companion.parsePath$intellij_ide_startup_importSettings(new URI($uri));
    }
}

