/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ifds;

import com.intellij.rml.dfa.ifds.IFDS;
import com.intellij.rml.dfa.ifds.IFDSExtension;
import com.intellij.rml.dfa.impl.ifds.Path;
import com.intellij.rml.dfa.impl.ifds.Summaries;
import com.intellij.rml.dfa.impl.ir.IrProjectFactoryImpl;
import com.intellij.rml.dfa.impl.transform.StaticSingleAssignmentStage;
import com.intellij.rml.dfa.ir.IrEnvironment;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0!0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/rml/dfa/impl/ifds/IFDSImpl;", "Lcom/intellij/rml/dfa/ifds/IFDS;", "project", "Lcom/intellij/rml/dfa/ir/IrProject;", "extension", "Lcom/intellij/rml/dfa/ifds/IFDSExtension;", "mainFilePath", "", "filteredLocations", "", "Lcom/intellij/rml/dfa/ir/IrLocation;", "environment", "Lcom/intellij/rml/dfa/ir/IrEnvironment;", "<init>", "(Lcom/intellij/rml/dfa/ir/IrProject;Lcom/intellij/rml/dfa/ifds/IFDSExtension;Ljava/lang/String;Ljava/util/Set;Lcom/intellij/rml/dfa/ir/IrEnvironment;)V", "getProject", "()Lcom/intellij/rml/dfa/ir/IrProject;", "getExtension", "()Lcom/intellij/rml/dfa/ifds/IFDSExtension;", "transformedProject", "summaries", "Lcom/intellij/rml/dfa/impl/ifds/Summaries;", "traces", "Lcom/intellij/rml/dfa/impl/ifds/Path;", "refiningRate", "", "getRefiningRate", "()I", "setRefiningRate", "(I)V", "hasPath", "", "paths", "", "getPaths", "()Ljava/util/List;", "getRefinedFunctions", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIFDSImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IFDSImpl.kt\ncom/intellij/rml/dfa/impl/ifds/IFDSImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n1586#2:701\n1661#2,3:702\n812#2,12:705\n1391#2:717\n1480#2,5:718\n*S KotlinDebug\n*F\n+ 1 IFDSImpl.kt\ncom/intellij/rml/dfa/impl/ifds/IFDSImpl\n*L\n690#1:701\n690#1:702,3\n694#1:705,12\n695#1:717\n695#1:718,5\n*E\n"})
public class IFDSImpl
implements IFDS {
    @NotNull
    private final IrProject project;
    @NotNull
    private final IFDSExtension extension;
    @NotNull
    private final IrProject transformedProject;
    @NotNull
    private final Summaries summaries;
    @NotNull
    private final Set<Path> traces;
    private int refiningRate;

    public IFDSImpl(@NotNull IrProject project, @NotNull IFDSExtension extension, @Nullable String mainFilePath, @Nullable Set<IrLocation> filteredLocations, @Nullable IrEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.project = project;
        this.extension = extension;
        this.transformedProject = new IrProjectFactoryImpl().performTransformations(this.project, CollectionsKt.listOf((Object)new StaticSingleAssignmentStage()));
        this.summaries = new Summaries(this.transformedProject, this.extension, filteredLocations, environment);
        this.traces = this.summaries.processSources(mainFilePath);
    }

    @NotNull
    public final IrProject getProject() {
        return this.project;
    }

    @NotNull
    public final IFDSExtension getExtension() {
        return this.extension;
    }

    public int getRefiningRate() {
        return this.refiningRate;
    }

    public void setRefiningRate(int n) {
        this.refiningRate = n;
    }

    public boolean hasPath() {
        return !((Collection)this.traces).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<IrLocation>> getPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.traces;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.reversed((Iterable)it.getLocations()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<IrFunctionID> getRefinedFunctions() {
        void $this$flatMapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.transformedProject.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allFunctions = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = this.traces;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFunctions();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set processedFunctions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.setRefiningRate(!((Collection)allFunctions).isEmpty() ? processedFunctions.size() * 100 / allFunctions.size() : 0);
        return processedFunctions;
    }
}

