/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import com.intellij.rml.dfa.impl.rml.profiler.GlobalProfileManager;
import com.intellij.rml.dfa.impl.scripts.RMLScriptDSL;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.utils.StringHelper;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDeclarationType;
import com.intellij.rml.dfa.rml.dsl.lang.SignatureKt;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.KeyWithDefault;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0006J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JL\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/intellij/rml/dfa/impl/scripts/ScriptManager;", "", "<init>", "()V", "nameToScript", "", "", "Lcom/intellij/rml/dfa/impl/scripts/Script;", "nameToVariablesManager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "availableScripts", "", "getAvailableScripts", "()Ljava/util/Collection;", "addScript", "", "script", "getScript", "name", "getVariablesManager", "getMissingRelations", "", "hypotheticRepository", "Lcom/intellij/rml/dfa/impl/repositories/HypoteticRelationsRepository;", "repository", "Lcom/intellij/rml/dfa/impl/repositories/RelationsRepository;", "outputRelations", "getOutputRelations", "()Ljava/util/List;", "run", "Lcom/intellij/rml/dfa/impl/scripts/RuntimeVariablesManager;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "uiInstancesProvider", "Lcom/intellij/rml/dfa/impl/ui/UIInstancesProvider;", "Lcom/intellij/rml/dfa/impl/repositories/MutableRelationsRepository;", "profileManager", "Lcom/intellij/rml/dfa/impl/rml/profiler/GlobalProfileManager;", "refresh", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nScriptManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptManager.kt\ncom/intellij/rml/dfa/impl/scripts/ScriptManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n11705#2:87\n12052#2,3:88\n11705#2:100\n12052#2,3:101\n777#3:91\n873#3,2:92\n1391#3:94\n1480#3,2:95\n1391#3:97\n1480#3,2:98\n1482#3,3:104\n1482#3,3:107\n812#3,12:110\n*S KotlinDebug\n*F\n+ 1 ScriptManager.kt\ncom/intellij/rml/dfa/impl/scripts/ScriptManager\n*L\n42#1:87\n42#1:88,3\n48#1:100\n48#1:101,3\n42#1:91\n42#1:92,2\n47#1:94\n47#1:95,2\n48#1:97\n48#1:98,2\n48#1:104,3\n47#1:107,3\n78#1:110,12\n*E\n"})
public final class ScriptManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Script> nameToScript = new HashMap();
    @NotNull
    private final Map<String, VariablesManager> nameToVariablesManager = new HashMap();
    @NotNull
    private static final KeyWithDefault<String> KEY_SCRIPT_TIME = new KeyWithDefault("ScriptTime", (Object)"");

    @NotNull
    public final Collection<Script> getAvailableScripts() {
        return this.nameToScript.values();
    }

    public final void addScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.nameToScript.put(script.getName(), script);
    }

    @NotNull
    public final Script getScript(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Script script = this.nameToScript.get(name);
        Intrinsics.checkNotNull((Object)script);
        return script;
    }

    @NotNull
    public final VariablesManager getVariablesManager(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VariablesManager variablesManager = this.nameToVariablesManager.get(name);
        Intrinsics.checkNotNull((Object)variablesManager);
        return variablesManager;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getMissingRelations(Script script, HypoteticRelationsRepository hypotheticRepository, RelationsRepository repository) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        VariablesManager variablesManager = this.nameToVariablesManager.get(script.getName());
        Intrinsics.checkNotNull((Object)variablesManager);
        RelationSignature[] relationSignatureArray = variablesManager.getRelations(RmlDeclarationType.Input);
        Intrinsics.checkNotNullExpressionValue((Object)relationSignatureArray, (String)"getRelations(...)");
        Object $this$map$iv = relationSignatureArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelationSignature relationSignature = (RelationSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!SignatureKt.isFakeRelation((String)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable = CollectionsKt.minus((Iterable)((List)destination$iv$iv), (Iterable)ArraysKt.toSet((Object[])repository.getAvailableRelations()));
        List<String> list = hypotheticRepository.getAllRelations(RmlDeclarationType.Summary);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllRelations(...)");
        return CollectionsKt.minus((Iterable)iterable, (Iterable)CollectionsKt.toSet((Iterable)list));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getOutputRelations() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAvailableScripts();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Script script = (Script)element$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv2 = RmlDeclarationType.Companion.getOutputTypes();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                RmlDeclarationType it = (RmlDeclarationType)element$iv$iv2;
                boolean bl2 = false;
                String string = script.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                RelationSignature[] relationSignatureArray = this.getVariablesManager(string).getRelations(it);
                Intrinsics.checkNotNullExpressionValue((Object)relationSignatureArray, (String)"getRelations(...)");
                Object[] $this$map$iv = relationSignatureArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    RelationSignature relationSignature = (RelationSignature)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl3 = false;
                    collection.add(it2.getName());
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final RuntimeVariablesManager run(@NotNull Script script, @Nullable SymbolTable symbolTable, @NotNull HypoteticRelationsRepository hypotheticRepository, @NotNull RMLOptions options, @Nullable Cancellation cancellation, @NotNull UIInstancesProvider uiInstancesProvider, @NotNull MutableRelationsRepository repository, @Nullable GlobalProfileManager profileManager2) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)hypotheticRepository, (String)"hypotheticRepository");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)uiInstancesProvider, (String)"uiInstancesProvider");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        List<String> missingRelations = this.getMissingRelations(script, hypotheticRepository, repository);
        if (!((Collection)missingRelations).isEmpty()) {
            throw new DfaInternalException(Messages.getString(ScriptManager.class.getName() + "-0") + StringHelper.makeCommaList((Collection<String>)missingRelations) + Messages.getString(ScriptManager.class.getName() + "-1"));
        }
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-2") + script.getName() + "\"...");
        long start = System.currentTimeMillis();
        RuntimeVariablesManager manager = script.run(repository, repository.getRelationsManager(), symbolTable, options, cancellation, uiInstancesProvider, profileManager2);
        String scriptTime = FormatHelperKt.formatDuration$default((long)(System.currentTimeMillis() - start), (int)0, (int)2, null);
        options.set(KEY_SCRIPT_TIME, (Object)scriptTime);
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-4") + script.getName() + Messages.getString(ScriptManager.class.getName() + "-5") + scriptTime);
        Intrinsics.checkNotNull((Object)manager);
        return manager;
    }

    /*
     * WARNING - void declaration
     */
    public final void refresh() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.nameToScript.values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RMLScriptDSL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (RMLScriptDSL script : (List)destination$iv$iv) {
            this.nameToVariablesManager.put(script.getName(), script.getStaticManager());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/impl/scripts/ScriptManager$Companion;", "", "<init>", "()V", "KEY_SCRIPT_TIME", "Lcom/intellij/rml/dfa/utils/KeyWithDefault;", "", "getKEY_SCRIPT_TIME", "()Lcom/intellij/rml/dfa/utils/KeyWithDefault;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyWithDefault<String> getKEY_SCRIPT_TIME() {
            return KEY_SCRIPT_TIME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

