/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RootsCalculator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachesHolder {
    @NonNls
    private static final String VCS_CACHE_PATH = "vcsCache";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, ChangesCacheFile> cacheFiles;
    @NotNull
    private final RepositoryLocationCache myLocationCache;

    public CachesHolder(@NotNull Project project, @NotNull RepositoryLocationCache locationCache) {
        if (project == null) {
            CachesHolder.$$$reportNull$$$0(0);
        }
        if (locationCache == null) {
            CachesHolder.$$$reportNull$$$0(1);
        }
        this.cacheFiles = new ConcurrentHashMap<String, ChangesCacheFile>();
        this.myProject = project;
        this.myLocationCache = locationCache;
    }

    @NotNull
    public Map<VirtualFile, RepositoryLocation> getAllRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            CachesHolder.$$$reportNull$$$0(2);
        }
        Map<VirtualFile, RepositoryLocation> map2 = new RootsCalculator(this.myProject, vcs, this.myLocationCache).getRoots();
        if (map2 == null) {
            CachesHolder.$$$reportNull$$$0(3);
        }
        return map2;
    }

    public void iterateAllCaches(@NotNull Processor<? super ChangesCacheFile> processor2) {
        if (processor2 == null) {
            CachesHolder.$$$reportNull$$$0(4);
        }
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            if (!(vcs.getCommittedChangesProvider() instanceof CachingCommittedChangesProvider)) continue;
            for (Map.Entry<VirtualFile, RepositoryLocation> entry : this.getAllRootsUnderVcs(vcs).entrySet()) {
                ChangesCacheFile cacheFile = this.getCacheFile(vcs, entry.getKey(), entry.getValue());
                if (processor2.process((Object)cacheFile)) continue;
                return;
            }
        }
    }

    public void reset() {
        this.cacheFiles.clear();
    }

    public void clearAllCaches() {
        this.cacheFiles.values().forEach(ChangesCacheFile::delete);
        this.reset();
    }

    @NotNull
    public Collection<ChangesCacheFile> getAllCaches() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.iterateAllCaches((Processor<? super ChangesCacheFile>)processor2);
        Collection collection = processor2.getResults();
        if (collection == null) {
            CachesHolder.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public ChangesCacheFile getCacheFile(@NotNull AbstractVcs vcs, @NotNull VirtualFile root, @NotNull RepositoryLocation location) {
        if (vcs == null) {
            CachesHolder.$$$reportNull$$$0(6);
        }
        if (root == null) {
            CachesHolder.$$$reportNull$$$0(7);
        }
        if (location == null) {
            CachesHolder.$$$reportNull$$$0(8);
        }
        ChangesCacheFile changesCacheFile = this.cacheFiles.computeIfAbsent(location.getKey(), key -> new ChangesCacheFile(this.myProject, this.getCachePath(location), vcs, root, location));
        if (changesCacheFile == null) {
            CachesHolder.$$$reportNull$$$0(9);
        }
        return changesCacheFile;
    }

    @NotNull
    public Path getCacheBasePath() {
        Path path = Path.of(PathManager.getSystemPath(), VCS_CACHE_PATH, this.myProject.getLocationHash());
        if (path == null) {
            CachesHolder.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    private Path getCachePath(@NotNull RepositoryLocation location) {
        if (location == null) {
            CachesHolder.$$$reportNull$$$0(11);
        }
        Path file = this.getCacheBasePath();
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Path path = file.resolve(DigestUtilKt.hashToHexString((String)location.getKey(), (MessageDigest)DigestUtil.md5()));
        if (path == null) {
            CachesHolder.$$$reportNull$$$0(12);
        }
        return path;
    }

    @Nullable
    public ChangesCacheFile haveCache(@NotNull RepositoryLocation location) {
        String key;
        ChangesCacheFile result2;
        if (location == null) {
            CachesHolder.$$$reportNull$$$0(13);
        }
        if ((result2 = this.cacheFiles.get(key = location.getKey())) == null) {
            Object keyWithSlash = key.endsWith("/") ? key : key + "/";
            String cachedSimilarKey = (String)ContainerUtil.find(this.cacheFiles.keySet(), arg_0 -> CachesHolder.lambda$haveCache$1((String)keyWithSlash, arg_0));
            result2 = cachedSimilarKey != null ? this.cacheFiles.get(cachedSimilarKey) : null;
        }
        return result2;
    }

    private static /* synthetic */ boolean lambda$haveCache$1(String keyWithSlash, String s) {
        return keyWithSlash.startsWith(s) || s.startsWith(keyWithSlash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationCache";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CachesHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CachesHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootsUnderVcs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCaches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheBasePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllRootsUnderVcs";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterateAllCaches";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCachePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "haveCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

