/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesIndicatorKt;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator;", "Lcom/intellij/openapi/wm/StatusBarWidget;", "Lcom/intellij/openapi/wm/StatusBarWidget$IconPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "isIncomingChangesAvailable", "", "<set-?>", "", "incomingChangesCount", "getIncomingChangesCount", "()I", "setIncomingChangesCount", "(I)V", "incomingChangesCount$delegate", "Lkotlin/properties/ReadWriteProperty;", "ID", "", "getPresentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "getClickConsumer", "Lcom/intellij/util/Consumer;", "Ljava/awt/event/MouseEvent;", "install", "", "dispose", "refresh", "getCachedIncomingChangesCount", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIncomingChangesIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesIndicator.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,110:1\n33#2,3:111\n*S KotlinDebug\n*F\n+ 1 IncomingChangesIndicator.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator\n*L\n56#1:111,3\n*E\n"})
final class IncomingChangesIndicator
implements StatusBarWidget,
StatusBarWidget.IconPresentation {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @Nullable
    private StatusBar statusBar;
    private boolean isIncomingChangesAvailable;
    @NotNull
    private final ReadWriteProperty incomingChangesCount$delegate;

    public IncomingChangesIndicator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = 0;
        boolean $i$f$observable = false;
        this.incomingChangesCount$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ IncomingChangesIndicator this$0;
            {
                this.this$0 = incomingChangesIndicator;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                block0: {
                    void newValue2;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    int n = ((Number)newValue).intValue();
                    ((Number)oldValue).intValue();
                    boolean bl = false;
                    IncomingChangesIndicatorKt.access$getLOG$p().debug("Refreshing indicator: " + (int)newValue2 + " changes");
                    StatusBar statusBar = IncomingChangesIndicator.access$getStatusBar$p(this.this$0);
                    if (statusBar == null) break block0;
                    statusBar.updateWidget(this.this$0.ID());
                }
            }
        };
    }

    private final int getIncomingChangesCount() {
        return ((Number)this.incomingChangesCount$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setIncomingChangesCount(int n) {
        this.incomingChangesCount$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @NotNull
    public String ID() {
        return "IncomingChanges";
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return (StatusBarWidget.WidgetPresentation)this;
    }

    @Nullable
    public Icon getIcon() {
        Icon icon;
        if (!this.isIncomingChangesAvailable) {
            return null;
        }
        if (this.getIncomingChangesCount() > 0) {
            icon = AllIcons.Ide.IncomingChangesOn;
        } else {
            Icon icon2 = AllIcons.Ide.IncomingChangesOn;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IncomingChangesOn");
            icon = IconLoader.getDisabledIcon((Icon)icon2);
        }
        return icon;
    }

    @Nullable
    public String getTooltipText() {
        String string;
        if (!this.isIncomingChangesAvailable) {
            string = null;
        } else if (this.getIncomingChangesCount() > 0) {
            Object[] objectArray = new Object[]{this.getIncomingChangesCount()};
            string = VcsBundle.message((String)"incoming.changes.indicator.tooltip", (Object[])objectArray);
        } else {
            string = VcsBundle.message((String)"changes.no.incoming.changelists.available", (Object[])new Object[0]);
        }
        return string;
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        return arg_0 -> IncomingChangesIndicator.getClickConsumer$lambda$0(this, arg_0);
    }

    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.statusBar = statusBar;
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<CommittedChangesListener> topic = CommittedChangesCache.COMMITTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"COMMITTED_TOPIC");
        busConnection.subscribe(topic, (Object)new CommittedChangesListener(this){
            final /* synthetic */ IncomingChangesIndicator this$0;
            {
                this.this$0 = $receiver;
            }

            public void incomingChangesUpdated(List<? extends CommittedChangeList> receivedChanges) {
                IncomingChangesIndicator.access$refresh(this.this$0);
            }

            public void changesCleared() {
                IncomingChangesIndicator.access$refresh(this.this$0);
            }
        });
        busConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> IncomingChangesIndicator.install$lambda$0(this));
        busConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, () -> IncomingChangesIndicator.install$lambda$1(this));
        this.refresh();
    }

    public void dispose() {
        this.statusBar = null;
    }

    private final void refresh() {
        ActionsKt.runInEdt$default(null, () -> IncomingChangesIndicator.refresh$lambda$0(this), (int)1, null);
    }

    private final int getCachedIncomingChangesCount() {
        List<CommittedChangeList> list = CommittedChangesCache.getInstance(this.project).getCachedIncomingChanges();
        return list != null ? list.size() : 0;
    }

    private static final void getClickConsumer$lambda$0$0(IncomingChangesIndicator this$0) {
        ChangesViewContentManager.Companion.getInstance(this$0.project).selectContent("Incoming");
    }

    private static final void getClickConsumer$lambda$0(IncomingChangesIndicator this$0, MouseEvent it) {
        block0: {
            ToolWindow toolWindow;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Version Control");
            if (toolWindow2 == null) break block0;
            toolWindow2.show(() -> IncomingChangesIndicator.getClickConsumer$lambda$0$0(this$0));
        }
    }

    private static final void install$lambda$0(IncomingChangesIndicator this$0) {
        this$0.refresh();
    }

    private static final void install$lambda$1(IncomingChangesIndicator this$0) {
        this$0.refresh();
    }

    private static final Unit refresh$lambda$0(IncomingChangesIndicator this$0) {
        if (this$0.project.isDisposed() || this$0.statusBar == null) {
            return Unit.INSTANCE;
        }
        this$0.isIncomingChangesAvailable = new IncomingChangesViewProvider.VisibilityPredicate().test(this$0.project);
        this$0.setIncomingChangesCount(this$0.isIncomingChangesAvailable ? this$0.getCachedIncomingChangesCount() : 0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ StatusBar access$getStatusBar$p(IncomingChangesIndicator $this) {
        return $this.statusBar;
    }

    public static final /* synthetic */ void access$refresh(IncomingChangesIndicator $this) {
        $this.refresh();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(IncomingChangesIndicator.class, "incomingChangesCount", "getIncomingChangesCount()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

