/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class InlineWatchesRootNode
extends WatchesRootNode {
    @NotNull
    private final XWatchesView myWatchesView;
    private final XValueGroupNodeImpl myInlinesRootNode;
    private final InlinesGroup myInlinesGroup;

    @Deprecated(forRemoval=true)
    public InlineWatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<XExpression> regularWatchesExpressions, @NotNull List<InlineWatch> inlineWatchesExpressions, @Nullable XStackFrame stackFrame, boolean watchesInVariables) {
        if (tree == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(0);
        }
        if (watchesView == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(1);
        }
        if (regularWatchesExpressions == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(2);
        }
        if (inlineWatchesExpressions == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(3);
        }
        this(tree, watchesView, Objects.requireNonNull(((XVariablesView)((Object)watchesView)).getSession()).getSessionData().getConfigurationName(), stackFrame, watchesInVariables, null);
    }

    public InlineWatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull String configurationName, @Nullable XStackFrame stackFrame, boolean watchesInVariables, XDebuggerTreeState stateToRecover) {
        if (tree == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(4);
        }
        if (watchesView == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(5);
        }
        if (configurationName == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(6);
        }
        super(tree, watchesView, configurationName, stackFrame, watchesInVariables, stateToRecover);
        this.myWatchesView = watchesView;
        this.myInlinesGroup = new InlinesGroup(XDebuggerBundle.message((String)"debugger.inline.watches.group.name", (Object[])new Object[0]), true);
        this.myInlinesRootNode = new XValueGroupNodeImpl(tree, this, this.myInlinesGroup){

            @Override
            @NotNull
            public List<? extends TreeNode> getChildren() {
                List<InlineWatchNodeImpl> list = InlineWatchesRootNode.this.myInlinesGroup.getChildren();
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode$1", "getChildren"));
            }
        };
        List inlineWatches = XDebugManagerProxy.getInstance().getWatchesManager(tree.getProject()).getInlineWatches();
        for (InlineWatch inlineWatch : inlineWatches) {
            this.myInlinesGroup.getChildren().add(new InlineWatchNodeImpl(this.myTree, (XDebuggerTreeNode)this.myInlinesRootNode, inlineWatch, stackFrame));
        }
    }

    public void addInlineWatchExpression(XStackFrame frame, InlineWatch watch, int index, boolean navigateToWatchNode) {
        InlineWatchNodeImpl message = new InlineWatchNodeImpl(this.myTree, (XDebuggerTreeNode)this.myInlinesRootNode, watch, frame);
        if (index == -1) {
            this.myInlinesGroup.getChildren().add(message);
            index = this.myInlinesGroup.getChildren().size() - 1;
        } else {
            this.myInlinesGroup.getChildren().add(index, message);
        }
        if (this.myInlinesGroup.getChildren().size() == 1) {
            this.myTree.getTreeModel().reload();
        }
        this.fireInlineNodeInserted(index);
        message.computePresentationIfNeeded();
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message.getPath());
        }
    }

    public void fireInlineNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this.myInlinesRootNode, new int[]{index});
    }

    public void removeInlineChildren(List<InlineWatchNode> inlines) {
        List<? extends InlineWatchNode> children = this.getInlineWatchChildren();
        int[] indices = inlines.stream().mapToInt(node -> children.indexOf(node)).filter(ind -> ind >= 0).toArray();
        TreeNode[] removed = (TreeNode[])Arrays.stream(indices).mapToObj(ind -> (TreeNode)children.get(ind)).toArray(TreeNode[]::new);
        children.removeAll(inlines);
        if (indices.length > 0) {
            this.inlineNodesRemoved(indices, removed);
        }
        if (children.isEmpty()) {
            this.allChildrenRemoved();
        }
    }

    private void inlineNodesRemoved(int[] indices, TreeNode[] removed) {
        this.myTree.getTreeModel().nodesWereRemoved(this.myInlinesRootNode, indices, removed);
        for (TreeNode node : removed) {
            ((InlineWatchNodeImpl)node).nodeRemoved();
        }
    }

    private void allChildrenRemoved() {
        this.myTree.getTreeModel().nodesWereRemoved(this, new int[]{0}, new XValueGroupNodeImpl[]{this.myInlinesRootNode});
    }

    @Override
    @NotNull
    public @Unmodifiable List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List<? extends XValueContainerNode<?>> children = super.getLoadedChildren();
        if (this.inlinesRootNodeIsShown()) {
            List list = ContainerUtil.prepend(children, (Object[])new XValueContainerNode[]{this.myInlinesRootNode});
            if (list == null) {
                InlineWatchesRootNode.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<? extends XValueContainerNode<?>> list = children;
        if (list == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<? extends TreeNode> getChildren() {
        List<? extends TreeNode> children = super.getChildren();
        if (this.myInlinesRootNode != null && this.inlinesRootNodeIsShown()) {
            List list = ContainerUtil.prepend(children, (Object[])new TreeNode[]{this.myInlinesRootNode});
            if (list == null) {
                InlineWatchesRootNode.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<? extends TreeNode> list = children;
        if (list == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean inlinesRootNodeIsShown() {
        return !this.getInlineWatchChildren().isEmpty();
    }

    @NotNull
    public List<? extends InlineWatchNode> getInlineWatchChildren() {
        List<InlineWatchNodeImpl> list = this.myInlinesGroup.myChildren;
        if (list == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.getInlineWatchChildren().clear();
    }

    @Override
    public void computeWatches() {
        super.computeWatches();
        this.getInlineWatchChildren().forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    @Override
    public int removeChildNode(XDebuggerTreeNode node) {
        if (node instanceof InlineWatchNodeImpl) {
            List<? extends InlineWatchNode> children = this.getInlineWatchChildren();
            int index = children.indexOf(node);
            if (index != -1) {
                children.remove(node);
                this.inlineNodesRemoved(new int[]{index}, new TreeNode[]{node});
            }
            if (children.isEmpty()) {
                this.allChildrenRemoved();
            }
            return index;
        }
        return super.removeChildNode(node);
    }

    @Override
    public void removeAllChildren() {
        this.getInlineWatchChildren().clear();
        this.fireNodeStructureChanged(this.myInlinesRootNode);
        super.removeAllChildren();
    }

    @Override
    public void editWatch(@Nullable WatchNodeImpl node) {
        if (node instanceof InlineWatchNodeImpl) {
            new WatchInplaceEditor(this, this.myWatchesView, node, node).show();
        } else {
            super.editWatch(node);
        }
    }

    @Override
    public int headerNodesCount() {
        return this.inlinesRootNodeIsShown() ? 1 : 0;
    }

    @Override
    public void moveUp(WatchNode node) {
        int index = this.getIndex(node);
        if (this.inlinesRootNodeIsShown()) {
            --index;
        }
        if (index > 0) {
            ContainerUtil.swapElements(this.getWatchChildren(), (int)index, (int)(index - 1));
        }
        this.fireNodeStructureChanged();
        int selectionRow = this.inlinesRootNodeIsShown() ? index : index - 1;
        this.getTree().setSelectionRow(selectionRow);
    }

    @Override
    public void moveDown(WatchNode node) {
        int index = this.getIndex(node);
        if (this.inlinesRootNodeIsShown()) {
            --index;
        }
        if (index < this.getWatchChildren().size() - 1) {
            ContainerUtil.swapElements(this.getWatchChildren(), (int)index, (int)(index + 1));
        }
        this.fireNodeStructureChanged();
        int selectionRow = this.inlinesRootNodeIsShown() ? index + 2 : index + 1;
        this.getTree().setSelectionRow(selectionRow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularWatchesExpressions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineWatchesExpressions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineWatchChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    static class InlinesGroup
    extends XValueGroup {
        private final boolean myInlinesInWatches;
        private final List<InlineWatchNodeImpl> myChildren;

        protected InlinesGroup(@NotNull String name, boolean inlinesInWatches) {
            if (name == null) {
                InlinesGroup.$$$reportNull$$$0(0);
            }
            super(name);
            this.myInlinesInWatches = inlinesInWatches;
            this.myChildren = new ArrayList<InlineWatchNodeImpl>();
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                InlinesGroup.$$$reportNull$$$0(1);
            }
            if (this.myInlinesInWatches) {
                XValueChildrenList list = new XValueChildrenList();
                for (InlineWatchNodeImpl child : this.myChildren) {
                    list.add((XNamedValue)child.getValueContainer());
                }
                node.addChildren(list, true);
            } else {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        List<InlineWatchNodeImpl> getChildren() {
            return this.myChildren;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode$InlinesGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

