/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehavior;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XFetchValueActionBase
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification {
    @ApiStatus.Internal
    @Nullable
    public ActionRemoteBehavior getBehavior() {
        return ActionRemoteBehavior.BackendOnly;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(0);
        }
        for (XValueNodeImpl node : this.getNodes(e)) {
            if (!this.isEnabled(e, node)) continue;
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    @NotNull
    @NotNull List<@NotNull XValueNodeImpl> getNodes(@NotNull AnActionEvent e) {
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(1);
        }
        List<XValueNodeImpl> list = XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext());
        if (list == null) {
            XFetchValueActionBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected boolean isEnabled(@NotNull AnActionEvent event, @NotNull XValueNodeImpl node) {
        if (event == null) {
            XFetchValueActionBase.$$$reportNull$$$0(3);
        }
        if (node == null) {
            XFetchValueActionBase.$$$reportNull$$$0(4);
        }
        if (node instanceof WatchNodeImpl || node.isComputed()) {
            event.getPresentation().setEnabled(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<XValueNodeImpl> nodes;
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(5);
        }
        if ((nodes = this.getNodes(e)).isEmpty()) {
            return;
        }
        ValueCollector valueCollector = this.createCollector(e);
        for (XValueNodeImpl node : nodes) {
            this.addToCollector(nodes, node, valueCollector);
        }
        valueCollector.processed = true;
        valueCollector.finish();
    }

    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode2, @NotNull ValueCollector valueCollector) {
        if (paths == null) {
            XFetchValueActionBase.$$$reportNull$$$0(6);
        }
        if (valueNode2 == null) {
            XFetchValueActionBase.$$$reportNull$$$0(7);
        }
        if (valueCollector == null) {
            XFetchValueActionBase.$$$reportNull$$$0(8);
        }
        if (paths.size() > 1) {
            valueCollector.add(valueNode2.getText().toString(), valueNode2.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode2.getFullValueEvaluator();
            if (fullValueEvaluator == null || !fullValueEvaluator.isShowValuePopup()) {
                valueCollector.add(StringUtil.notNullize((String)DebuggerUIUtil.getNodeRawValue(valueNode2)));
            } else {
                new CopyValueEvaluationCallback(valueNode2, valueCollector).startFetchingValue(fullValueEvaluator);
            }
        }
    }

    @NotNull
    protected ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(9);
        }
        XDebuggerTree tree = XDebuggerTree.getTree(e.getDataContext());
        return new ValueCollector(this, tree, e.getProject());
    }

    @Deprecated
    protected void handle(Project project, String value, XDebuggerTree ignoredTree) {
        this.handle(project, value);
    }

    protected void handle(Project project, String value) {
        throw new AbstractMethodError();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToCollector";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCollector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public class ValueCollector {
        private final List<String> values;
        private final Int2IntMap indents;
        private final Project myProject;
        private volatile boolean processed;
        private XDebuggerTree myTree;
        final /* synthetic */ XFetchValueActionBase this$0;

        @Deprecated
        public ValueCollector(@NotNull XFetchValueActionBase this$0, XDebuggerTree tree) {
            if (tree == null) {
                ValueCollector.$$$reportNull$$$0(0);
            }
            this(this$0, tree.getProject());
            this.myTree = tree;
        }

        ValueCollector(@Nullable XFetchValueActionBase this$0, XDebuggerTree tree, Project project) {
            this(this$0, project);
            this.myTree = tree;
        }

        public ValueCollector(XFetchValueActionBase this$0, Project project) {
            this.this$0 = this$0;
            this.values = new SmartList();
            this.indents = new Int2IntOpenHashMap();
            this.indents.defaultReturnValue(-1);
            this.myProject = project;
        }

        public void add(@NotNull String value) {
            if (value == null) {
                ValueCollector.$$$reportNull$$$0(1);
            }
            this.values.add(value);
        }

        @Deprecated
        @Nullable
        public XDebuggerTree getTree() {
            return this.myTree;
        }

        public void add(@NotNull String value, int indent) {
            if (value == null) {
                ValueCollector.$$$reportNull$$$0(2);
            }
            this.values.add(value);
            this.indents.put(this.values.size() - 1, indent);
        }

        public void finish() {
            if (this.processed && !this.values.contains(null) && !this.myProject.isDisposed()) {
                int minIndent = Integer.MAX_VALUE;
                IntIterator intIterator = this.indents.values().iterator();
                while (intIterator.hasNext()) {
                    int indent = (Integer)intIterator.next();
                    minIndent = Math.min(minIndent, indent);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.values.size(); ++i) {
                    int indent;
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if ((indent = this.indents.get(i)) > 0) {
                        StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)(indent - minIndent));
                    }
                    sb.append(this.values.get(i));
                }
                this.handleInCollector(this.myProject, sb.toString(), this.myTree);
            }
        }

        @Deprecated
        public void handleInCollector(Project project, String value, XDebuggerTree ignoredTree) {
            this.handleInCollector(project, value);
        }

        public void handleInCollector(Project project, String value) {
            this.this$0.handle(project, value, this.myTree);
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(int index, @NotNull String value) {
            if (value == null) {
                ValueCollector.$$$reportNull$$$0(3);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.values.set(index, value);
                this.finish();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluationComplete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CopyValueEvaluationCallback
    extends HeadlessValueEvaluationCallback {
        private final int myValueIndex;
        private final ValueCollector myValueCollector;

        CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, @NotNull ValueCollector valueCollector) {
            if (node == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(0);
            }
            if (valueCollector == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(1);
            }
            super(node);
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
        }

        @Override
        protected void evaluationComplete(@NotNull String value, @NotNull Project project) {
            if (value == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(2);
            }
            if (project == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(3);
            }
            this.myValueCollector.evaluationComplete(this.myValueIndex, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueCollector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluationComplete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

