/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.GrantsHelper;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SizeAndScale;
import com.intellij.database.dialects.base.generator.producers.AlterArgument;
import com.intellij.database.dialects.base.generator.producers.AlterCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.AlterCapableProducer;
import com.intellij.database.dialects.base.generator.producers.AlterCapableProducerKt;
import com.intellij.database.dialects.base.generator.producers.AlterCheck;
import com.intellij.database.dialects.base.generator.producers.AlterData;
import com.intellij.database.dialects.base.generator.producers.AlterDatabase;
import com.intellij.database.dialects.base.generator.producers.AlterForeignKey;
import com.intellij.database.dialects.base.generator.producers.AlterIndex;
import com.intellij.database.dialects.base.generator.producers.AlterKey;
import com.intellij.database.dialects.base.generator.producers.AlterLikeColumn;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.AlterSchema;
import com.intellij.database.dialects.base.generator.producers.AlterSynonym;
import com.intellij.database.dialects.base.generator.producers.AlterTable;
import com.intellij.database.dialects.base.generator.producers.AlterTableColumn;
import com.intellij.database.dialects.base.generator.producers.AlterTrigger;
import com.intellij.database.dialects.base.generator.producers.AlterUnknown;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.BasicElementProducer;
import com.intellij.database.dialects.base.generator.producers.CapabilityInvocator;
import com.intellij.database.dialects.base.generator.producers.CreateCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.CreateCapableProducer;
import com.intellij.database.dialects.base.generator.producers.CreateCheck;
import com.intellij.database.dialects.base.generator.producers.CreateCommentCapable;
import com.intellij.database.dialects.base.generator.producers.CreateData;
import com.intellij.database.dialects.base.generator.producers.CreateForeignKey;
import com.intellij.database.dialects.base.generator.producers.CreateIndex;
import com.intellij.database.dialects.base.generator.producers.CreateKey;
import com.intellij.database.dialects.base.generator.producers.CreateLikeColumn;
import com.intellij.database.dialects.base.generator.producers.CreateMatView;
import com.intellij.database.dialects.base.generator.producers.CreateOther;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.base.generator.producers.CreateSourceAware;
import com.intellij.database.dialects.base.generator.producers.CreateSynonym;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.base.generator.producers.CreateTrigger;
import com.intellij.database.dialects.base.generator.producers.CreateView;
import com.intellij.database.dialects.base.generator.producers.DropCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.DropCapableProducer;
import com.intellij.database.dialects.base.generator.producers.DropData;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.DropUnknown;
import com.intellij.database.dialects.base.generator.producers.ElementData;
import com.intellij.database.dialects.base.generator.producers.FlagValue;
import com.intellij.database.dialects.base.generator.producers.NewProducerUtilsKt;
import com.intellij.database.dialects.base.generator.producers.OldAlterAdapter;
import com.intellij.database.dialects.base.generator.producers.OldCreateAdapter;
import com.intellij.database.dialects.base.generator.producers.OldDropAdapter;
import com.intellij.database.dialects.base.generator.producers.ProducerData;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.base.generator.producers.RecompileProducer;
import com.intellij.database.dialects.base.generator.producers.SearchPathProducer;
import com.intellij.database.dialects.base.generator.producers.SourceAwareProducersKt;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateTable;
import com.intellij.database.dialects.base.generator.producers.UnsupportedCapableInvocator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ElementDeltaKt;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingConstraintContext;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingUtilsKt;
import com.intellij.database.types.DasType;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010,\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J$\u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010!H\u0016J\u0010\u00105\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020)072\u0006\u00108\u001a\u00020\u001aH\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020)072\u0006\u00108\u001a\u00020\u001aH\u0016J!\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0000\u00a2\u0006\u0002\b@J\u0018\u0010A\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u0010B\u001a\u00020CH\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010\"2\u0006\u00100\u001a\u0002012\u0006\u0010B\u001a\u00020CH\u0014J\u000e\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020!2\u0006\u0010F\u001a\u00020GH\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010G2\u0006\u0010F\u001a\u00020GH\u0016J\u0012\u0010L\u001a\u00020!2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0012\u0010O\u001a\u00020!2\b\u0010P\u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010Q\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0014J\"\u0010R\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020T2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u0018\u0010U\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GH\u0014J\"\u0010V\u001a\u00020)2\u0006\u00102\u001a\u0002032\b\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0018\u0010[\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010\\\u001a\u00020ZH\u0016J\u0016\u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010b2\u0006\u0010F\u001a\u00020GH\u0016J\u001a\u0010c\u001a\u0006\u0012\u0002\b\u00030d2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GJ\u001c\u0010e\u001a\u0006\u0012\u0002\b\u00030d2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GH\u0016J\u001a\u0010f\u001a\u0006\u0012\u0002\b\u00030g2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GJ\u001c\u0010h\u001a\u0006\u0012\u0002\b\u00030g2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GH\u0016J\u001e\u0010i\u001a\u0006\u0012\u0002\b\u00030j2\u0006\u00102\u001a\u0002032\n\u0010k\u001a\u0006\u0012\u0002\b\u00030lJ\u0014\u0010m\u001a\u00020n2\n\u0010o\u001a\u0006\u0012\u0002\b\u00030pH\u0014J \u0010q\u001a\u0006\u0012\u0002\b\u00030p2\u0006\u00102\u001a\u0002032\n\u0010k\u001a\u0006\u0012\u0002\b\u00030lH\u0016J\u001c\u0010r\u001a\u0006\u0012\u0002\b\u00030s2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GH\u0016J\u001c\u0010t\u001a\u0006\u0012\u0002\b\u00030u2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020GH\u0016J.\u0010v\u001a\u00020n\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0x2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0zH\u0016J \u0010v\u001a\u00020n\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0pH\u0016J.\u0010{\u001a\u00020n\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0|2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0}H\u0016J.\u0010~\u001a\u00020n\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0|2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0}H\u0002J \u0010{\u001a\u00020n\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0\u007fH\u0016J \u0010\u0080\u0001\u001a\u000f\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u0081\u0001\u0018\u00010\u00192\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J\u0017\u0010\u0084\u0001\u001a\u00020)2\f\u0010\u0085\u0001\u001a\u0007\u0012\u0002\b\u00030\u0081\u0001H\u0016J0\u0010\u0086\u0001\u001a\u00020n2\n\u0010o\u001a\u0006\u0012\u0002\b\u00030p2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u008a\u0001H\u0016J0\u0010\u0086\u0001\u001a\u00020n2\n\u0010y\u001a\u0006\u0012\u0002\b\u00030z2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u008a\u0001H\u0016J\u001d\u0010\u008b\u0001\u001a\u00020n2\n\u0010y\u001a\u0006\u0012\u0002\b\u00030z2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J#\u0010\u008c\u0001\u001a\u000e\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u008e\u00010\u008d\u00012\f\u0010\u008f\u0001\u001a\u0007\u0012\u0002\b\u00030\u0090\u0001H\u0016J\u0015\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u00012\u0007\u0010o\u001a\u00030\u0093\u0001H\u0016J\u001e\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u0006\u00102\u001a\u0002032\b\u0010\u0096\u0001\u001a\u00030\u0092\u0001H\u0016J\u0012\u0010\u0097\u0001\u001a\u00020)2\u0007\u0010\u0098\u0001\u001a\u00020!H\u0016J1\u0010\u0099\u0001\u001a\u00030\u009a\u0001\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0b2\r\u0010y\u001a\t\u0012\u0004\u0012\u0002Hw0\u009b\u0001H\u0016J6\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u0001\"\b\b\u0000\u0010w*\u00020G2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0z2\u0012\u0010\u009e\u0001\u001a\r\u0012\u0004\u0012\u0002Hw\u0012\u0002\b\u00030\u009f\u0001J \u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009d\u00012\n\u0010y\u001a\u0006\u0012\u0002\b\u00030z2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J5\u0010\u00a1\u0001\u001a\u00020)\"\u0005\b\u0000\u0010\u00a2\u00012\u0007\u0010y\u001a\u00030\u00a3\u00012\n\u0010\u00a4\u0001\u001a\u0005\u0018\u0001H\u00a2\u00012\n\u0010\u00a5\u0001\u001a\u0005\u0018\u0001H\u00a2\u0001\u00a2\u0006\u0003\u0010\u00a6\u0001J=\u0010\u00a7\u0001\u001a\b\u0012\u0004\u0012\u00020)07\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0|2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0}2\b\u0010\u009e\u0001\u001a\u00030\u0088\u0001J=\u0010\u00a8\u0001\u001a\b\u0012\u0004\u0012\u00020)07\"\b\b\u0000\u0010w*\u00020G2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002Hw0x2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0z2\b\u0010\u009e\u0001\u001a\u00030\u0088\u0001J\u0012\u0010\u00a9\u0001\u001a\u00020!2\u0007\u0010\u00aa\u0001\u001a\u00020GH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010I\u001a\u00020)8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010+R\u001e\u0010]\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010^X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "sqlLang", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSqlLang", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "sqlLang$delegate", "Lkotlin/Lazy;", "sqlDef", "Lcom/intellij/lang/ParserDefinition;", "getSqlDef", "()Lcom/intellij/lang/ParserDefinition;", "sqlDef$delegate", "namingServiceProvider", "Lcom/intellij/database/script/generator/NamingService$Provider;", "getNamingServiceProvider", "()Lcom/intellij/database/script/generator/NamingService$Provider;", "namingServiceProvider$delegate", "supportsCreateOrReplace", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateOrReplace", "()Ljava/util/Set;", "supportsCreateIfNotExists", "getSupportsCreateIfNotExists", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/dialects/base/generator/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "statementDelimiterStr", "getStatementDelimiterStr", "()Ljava/lang/String;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "script", "d", "Lcom/intellij/database/model/DataType;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "contextSchema", "isMaxForbidden", "canCreateIfNotExists", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "kind", "canCreateOrReplace", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getNamingService$intellij_database_dialects_base", "isDefaultSize", "v", "Lcom/intellij/database/util/Version;", "getDefaultPrimitiveSize", "getObjectPreliminaryOrder", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getObjectPreliminaryOrderPart", "useObjectIdInOrder", "getUseObjectIdInOrder", "qualifier", "getTableTerm", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "commentStr", "comment", "shouldCollectColumnElements", "canGenerateHere", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "canGenerateElementRightNow", "isIndexExplicitFor", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "shouldGenerateOutsideTable", "it", "grantsHelper", "Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "getGrantsHelper", "()Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "getElementProducer", "Lcom/intellij/database/dialects/base/generator/producers/BasicElementProducer;", "createProducer", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "createProducerImpl", "createDropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createDropProducerImpl", "createAlterProducer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "initAlterProducer", "", "producer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "createAlterProducerImpl", "createRecompileProducer", "Lcom/intellij/database/dialects/base/generator/producers/RecompileProducer;", "createTruncateProducer", "Lcom/intellij/database/dialects/base/generator/producers/TruncateProducer;", "produceAlter", "T", "Lcom/intellij/database/dialects/base/generator/producers/AlterCapableProducer;", "data", "Lcom/intellij/database/dialects/base/generator/producers/AlterData;", "produceCreate", "Lcom/intellij/database/dialects/base/generator/producers/CreateCapableProducer;", "Lcom/intellij/database/dialects/base/generator/producers/CreateData;", "produceComments", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "availableOptions", "Lcom/intellij/database/script/generator/ScriptingOption;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "isOptionSupported", "option", "produceAlterFlag", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produced", "", "produceAlterNotSupported", "extraProperties", "", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "requiredSearchPath", "Lcom/intellij/database/util/SearchPath;", "Lcom/intellij/database/dialects/base/generator/Producer;", "createSearchPathGroup", "Lcom/intellij/database/dialects/base/generator/producers/SearchPathProducer;", "path", "isSchemaAlwaysInPath", "sc", "getInvocator", "Lcom/intellij/database/dialects/base/generator/producers/CapabilityInvocator;", "Lcom/intellij/database/dialects/base/generator/producers/ElementData;", "checkAlterPropertyFlag", "Lcom/intellij/database/dialects/base/generator/producers/FlagValue;", "prop", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "checkAlterFakeFlag", "checkAlterValue", "V", "Lcom/intellij/database/dialects/base/generator/producers/ProducerData;", "v1", "v2", "(Lcom/intellij/database/dialects/base/generator/producers/ProducerData;Ljava/lang/Object;Ljava/lang/Object;)Z", "canCreateWith", "canAlter", "scopeResolutionSeparator", "e", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nScriptGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGeneratorHelper.kt\ncom/intellij/database/dialects/base/generator/ScriptGeneratorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,573:1\n1#2:574\n*E\n"})
public abstract class ScriptGeneratorHelper {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Lazy sqlLang$delegate;
    @NotNull
    private final Lazy sqlDef$delegate;
    @NotNull
    private final Lazy namingServiceProvider$delegate;
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private final Set<ObjectKind> supportsCreateIfNotExists;
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;
    @Nullable
    private final GrantsHelper<?, ?> grantsHelper;

    public ScriptGeneratorHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.sqlLang$delegate = LazyKt.lazy(() -> ScriptGeneratorHelper.sqlLang_delegate$lambda$0(this));
        this.sqlDef$delegate = LazyKt.lazy(() -> ScriptGeneratorHelper.sqlDef_delegate$lambda$0(this));
        this.namingServiceProvider$delegate = LazyKt.lazy(() -> ScriptGeneratorHelper.namingServiceProvider_delegate$lambda$0(this));
        this.supportsCreateOrReplace = SetsKt.emptySet();
        this.supportsCreateIfNotExists = SetsKt.emptySet();
        this.defaultPrimitiveSizes = MapsKt.emptyMap();
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @Nullable
    public final SqlLanguageDialect getSqlLang() {
        Lazy lazy = this.sqlLang$delegate;
        return (SqlLanguageDialect)lazy.getValue();
    }

    @Nullable
    public final ParserDefinition getSqlDef() {
        Lazy lazy = this.sqlDef$delegate;
        return (ParserDefinition)lazy.getValue();
    }

    private final NamingService.Provider getNamingServiceProvider() {
        Lazy lazy = this.namingServiceProvider$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (NamingService.Provider)object;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        return this.supportsCreateIfNotExists;
    }

    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    public boolean isNullExplicit(@Nullable BasicLikeColumn column) {
        return false;
    }

    @NotNull
    public String script(@NotNull DataType d, @Nullable ScriptingContext context, @Nullable String contextSchema) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Object specification = null;
        if (!d.custom && !d.sizeUnitExplicit && d.size != -1) {
            ScriptingContext scriptingContext = context;
            if (scriptingContext == null || (scriptingContext = scriptingContext.getTask()) == null || (scriptingContext = scriptingContext.getVersion()) == null) {
                scriptingContext = Version.INFINITY;
            }
            ScriptingContext scriptingContext2 = scriptingContext;
            Intrinsics.checkNotNull((Object)scriptingContext2);
            boolean defaultSize = this.isDefaultSize(d, (Version)scriptingContext2);
            if (defaultSize) {
                specification = d.typeName;
                if (d.suffix != null) {
                    specification = (String)specification + " " + d.suffix;
                }
            }
        }
        String string = specification;
        if (string != null) {
            return string;
        }
        String it = contextSchema;
        boolean bl = false;
        boolean ignoreSchema = it != null && StringsKt.equals((String)it, (String)d.schemaName, (boolean)true);
        String string2 = d.getSpecification(false, this.isMaxForbidden(d), !ignoreSchema);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecification(...)");
        return string2;
    }

    public boolean isMaxForbidden(@NotNull DataType d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return false;
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateIfNotExists(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getSupportsCreateIfNotExists().contains(kind) ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateOrReplace(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getSupportsCreateOrReplace().contains(kind) ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @NotNull
    public final NamingService getNamingService$intellij_database_dialects_base(@Nullable BasicModel model, @Nullable BasicDatabase database) {
        return this.getNamingServiceProvider().getNamingService(model, database);
    }

    public boolean isDefaultSize(@NotNull DataType d, @NotNull Version v) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        SizeAndScale defaults = this.getDefaultPrimitiveSize(d, v);
        return defaults != null && d.size == defaults.getSize() && d.scale == defaults.getScale();
    }

    @Nullable
    protected SizeAndScale getDefaultPrimitiveSize(@NotNull DataType d, @NotNull Version v) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.getDefaultPrimitiveSizes().get(StringUtil.toLowerCase((String)d.typeName));
    }

    @NotNull
    public final String getObjectPreliminaryOrder(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        StringBuilder b = new StringBuilder(60);
        for (BasicElement e = element; e != null; e = e.getParent()) {
            if (((CharSequence)b).length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getObjectPreliminaryOrderPart(e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getObjectPreliminaryOrderPart(BasicElement element) {
        Object object;
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        String kindOrder = ScriptingUtilsKt.orderString((ObjectKind)objectKind);
        if (element instanceof BasicArrangedElement) {
            object = "#" + ScriptingUtilsKt.toFixedOrderString((short)ScriptingUtilsKt.positionSafe((BasicArrangedElement)((BasicArrangedElement)element))) + "#" + element.identity();
        } else if (element instanceof BasicIdentifiedElement && this.getUseObjectIdInOrder()) {
            object = ScriptingUtilsKt.toOrderString((long)((BasicIdentifiedElement)element).getObjectId()) + "#" + element.identity();
        } else if (element instanceof BasicOverloadable) {
            object = "?_" + element.identity();
        } else if (element instanceof BasicNamedElement) {
            String string = ((BasicNamedElement)element).getRealName();
            if (string == null) {
                string = "???";
            }
            object = "?_" + string + "#" + element.identity();
        } else {
            object = "?????";
        }
        String elementOrder = object;
        return kindOrder + (element instanceof BasicKey && ((BasicKey)element).isPrimary() ? "^" : "_") + elementOrder;
    }

    protected boolean getUseObjectIdInOrder() {
        return true;
    }

    @Nullable
    public BasicElement qualifier(@NotNull BasicElement element) {
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement2 = element;
        if (basicElement2 instanceof BasicSchemaObject) {
            basicElement = (BasicElement)((BasicSchemaObject)element).getSchema();
        } else if (basicElement2 instanceof BasicLikeColumn) {
            basicElement = (BasicElement)((BasicLikeColumn)element).getLikeTable();
        } else if (basicElement2 instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)element).getMajorObject();
            basicElement = (BasicElement)(basicMajorObject != null ? basicMajorObject.getSchema() : null);
        } else {
            basicElement = null;
        }
        return basicElement;
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable table) {
        return "table";
    }

    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null) {
            string = "";
        }
        return ScriptGeneratorHelperKt.getSqlString(string);
    }

    protected boolean shouldCollectColumnElements(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN && context.getLocus() == ScriptLocus.IN_TABLE;
    }

    public boolean canGenerateHere(@NotNull ScriptingContext context, @NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locus, (String)"locus");
        return switch (WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1 -> {
                if (!(element instanceof BasicConstraint) || context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (element instanceof BasicTableOrViewColumn || element instanceof BasicConstraint && ((ScriptingConstraintContext)context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (element instanceof BasicConstraint && context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    protected boolean canGenerateElementRightNow(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof BasicMinorObject && context.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
            return ((BasicMinorObject)element).getMajorObject() == null;
        }
        return true;
    }

    public boolean isIndexExplicitFor(@NotNull ScriptingContext context, @Nullable BasicIndex index, @NotNull BasicKey key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return index != null && ScriptGeneratorHelperKt.useName((BasicElement)index, context) && !Intrinsics.areEqual((Object)index.getName(), (Object)key.getName());
    }

    public boolean shouldGenerateOutsideTable(@NotNull ScriptingContext context, @NotNull BasicKey it) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this.isIndexExplicitFor(context, it.getUnderlyingIndex(), it);
    }

    @Nullable
    public GrantsHelper<?, ?> getGrantsHelper() {
        return this.grantsHelper;
    }

    @Nullable
    public BasicElementProducer<?> getElementProducer(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    @NotNull
    public final CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        CreateCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElementProducer<?> basicElementProducer = this.getElementProducer(element);
        CreateCapableProducer createCapableProducer = producer = basicElementProducer instanceof CreateCapableProducer ? (CreateCapableProducer)basicElementProducer : null;
        if (producer != null) {
            CreateData<BasicElement> data = new CreateData<BasicElement>(context, element);
            producer.init((ProducerData)data);
            return new OldCreateAdapter<BasicElement>(producer, data);
        }
        return this.createProducerImpl(context, element);
    }

    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof BasicSequence ? (CreateProducer)new CreateSequence<BasicSequence>(context, (BasicSequence)element) : (basicElement instanceof BasicTable ? (CreateProducer)new CreateTable<BasicTable>(context, (BasicTable)element) : (basicElement instanceof BasicLikeColumn ? (CreateProducer)new CreateLikeColumn<BasicLikeColumn>(context, (BasicLikeColumn)element) : (basicElement instanceof BasicIndex ? (CreateProducer)new CreateIndex<BasicIndex>(context, (BasicIndex)element) : (basicElement instanceof BasicKey ? (CreateProducer)new CreateKey<BasicKey>(context, (BasicKey)element) : (basicElement instanceof BasicForeignKey ? (CreateProducer)new CreateForeignKey<BasicForeignKey>(context, (BasicForeignKey)element) : (basicElement instanceof BasicCheck ? (CreateProducer)new CreateCheck<BasicCheck>(context, (BasicCheck)element) : (basicElement instanceof BasicTrigger ? (CreateProducer)new CreateTrigger<BasicTrigger>(context, (BasicTrigger)element) : (basicElement instanceof BasicMatView ? (CreateProducer)new CreateMatView<BasicMatView>(context, (BasicMatView)element) : (basicElement instanceof BasicView ? (CreateProducer)new CreateView<BasicView>(context, (BasicView)element) : (basicElement instanceof BasicSourceAware ? (CreateProducer)new CreateSourceAware<BasicSourceAware>(context, (BasicSourceAware)element) : (basicElement instanceof BasicSynonym ? (CreateProducer)new CreateSynonym<BasicSynonym>(context, (BasicSynonym)element) : (CreateProducer)new CreateOther(context, element))))))))))));
    }

    @NotNull
    public final DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        DropCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElementProducer<?> basicElementProducer = this.getElementProducer(element);
        DropCapableProducer dropCapableProducer = producer = basicElementProducer instanceof DropCapableProducer ? (DropCapableProducer)basicElementProducer : null;
        if (producer != null) {
            DropData<BasicElement> data = new DropData<BasicElement>(context, element);
            producer.init((ProducerData)data);
            return new OldDropAdapter<BasicElement>(producer, data);
        }
        return this.createDropProducerImpl(context, element);
    }

    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new DropUnknown(context, element);
    }

    @NotNull
    public final AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        AlterCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Object object = this.getElementProducer(ElementDeltaKt.anyElement((ElementDelta)((ElementDelta)elements)));
        AlterCapableProducer alterCapableProducer = producer = object instanceof AlterCapableProducer ? (AlterCapableProducer)object : null;
        if (producer != null) {
            AlterData<BasicElement> data = new AlterData<BasicElement>(context, elements.getSourceElement(), elements.getTargetElement());
            producer.init((ProducerData)data);
            return new OldAlterAdapter<BasicElement>(producer, data);
        }
        Object $this$createAlterProducer_u24lambda_u240 = object = this.createAlterProducerImpl(context, elements);
        boolean bl = false;
        this.initAlterProducer((AlterProducerBase<?>)$this$createAlterProducer_u24lambda_u240);
        return (AlterProducer)object;
    }

    protected void initAlterProducer(@NotNull AlterProducerBase<?> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
    }

    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement it = elements.getSourceElement();
        boolean bl = false;
        BasicElement basicElement = it;
        return basicElement instanceof BasicDatabase ? (AlterProducerBase)new AlterDatabase<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicSchema ? (AlterProducerBase)new AlterSchema<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicTable ? (AlterProducerBase)new AlterTable<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicTableColumn ? (AlterProducerBase)new AlterTableColumn<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicKey ? (AlterProducerBase)new AlterKey<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicIndex ? (AlterProducerBase)new AlterIndex<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicForeignKey ? (AlterProducerBase)new AlterForeignKey<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicCheck ? (AlterProducerBase)new AlterCheck<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicSynonym ? (AlterProducerBase)new AlterSynonym<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicTrigger ? (AlterProducerBase)new AlterTrigger<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicLikeColumn ? (AlterProducerBase)new AlterLikeColumn<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (basicElement instanceof BasicArgument ? (AlterProducerBase)new AlterArgument<BasicElement>(context, BaseProducersKt.cast(elements, it)) : (AlterProducerBase)new AlterUnknown(context, elements))))))))))));
    }

    @NotNull
    public RecompileProducer<?> createRecompileProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new RecompileProducer<BasicElement>(context, element){

            public ScriptingCapabilities.VersionedCapability<Boolean> canRecompile() {
                return AbstractScriptGeneratorKt.getUNSUPPORTED();
            }
        };
    }

    @NotNull
    public TruncateProducer<?> createTruncateProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof BasicTable ? (TruncateProducer)new TruncateTable<BasicLikeTable>(context, (BasicLikeTable)element) : new TruncateProducer(context, element);
    }

    public <T extends BasicElement> void produceAlter(@NotNull AlterCapableProducer<T> producer, @NotNull AlterData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        producer.produceAlter(data);
    }

    public <T extends BasicElement> void produceAlter(@NotNull AlterProducerBase<T> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        producer.produceAlter();
    }

    public <T extends BasicElement> void produceCreate(@NotNull CreateCapableProducer<T> producer, @NotNull CreateData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        producer.produceCreate(data);
        if (data.getContext().getLocus() == ScriptLocus.OUTSIDE && !((Boolean)data.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS)).booleanValue()) {
            this.produceComments(producer, data);
        }
    }

    private final <T extends BasicElement> void produceComments(CreateCapableProducer<T> producer, CreateData<T> data) {
        if (((Boolean)data.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS)).booleanValue()) {
            return;
        }
        if (producer instanceof CreateCommentCapable && ((DasObject)data.getElement()).getComment() != null) {
            ((CreateCommentCapable)producer).produceCommentIfSupported(data, ((DasObject)data.getElement()).getComment());
        }
    }

    public <T extends BasicElement> void produceCreate(@NotNull CreateProducerBase<T> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        producer.produceCreate();
        if (producer.getContext().getLocus() == ScriptLocus.OUTSIDE && !((Boolean)producer.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS)).booleanValue()) {
            producer.produceComments();
        }
    }

    @Nullable
    public Set<ScriptingOption<?>> availableOptions(@NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return WhenMappings.$EnumSwitchMapping$1[task.getCategory().ordinal()] == 1 ? SetsKt.setOf((Object)ScriptingOptionStatic.USE_DELETE) : null;
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.ALLOW_RECREATE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.INCLUDE_NESTED_ELEMENTS) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CONSIDER_SCHEMA_NAME) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IGNORE_CASE_CHANGES) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CASCADE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.RESTART_IDENTITY) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.PURGE_MV_LOG) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.REUSE_STORAGE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.RESTRICT_DELETE_TRIGGERS) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IMMEDIATE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IGNORE_ORDER) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.SKIP_COMMENTS) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.USE_COMPACT_DEFINITION) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.REFORMAT) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CODE_STYLE) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IGNORE_COMPACT) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.DROP_CASCADE) ? true : (Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CONSIDER_TRIGGERS) || Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) ? !Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN) : (Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.RUN_DIAGNOSTIC) ? ApplicationManager.getApplication().isInternal() : (Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.DUMP_TASK) ? Registry.Companion.is("database.script.generator.show.dump.option") || ApplicationManager.getApplication().isInternal() : false)));
    }

    public void produceAlterFlag(@NotNull AlterProducerBase<?> producer, @NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        this.produceAlterFlag(producer.getData(), id, produced);
    }

    public void produceAlterFlag(@NotNull AlterData<?> data, @NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        this.produceAlterNotSupported(data, id);
    }

    public final void produceAlterNotSupported(@NotNull AlterData<?> data, @NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        NewProducerUtilsKt.newCoding(data, (Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> ScriptGeneratorHelper.produceAlterNotSupported$lambda$0(id, arg_0)));
    }

    @NotNull
    public List<BasicMetaPropertyId<?>> extraProperties(@NotNull BasicMetaObject<?> meta) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public SearchPath requiredSearchPath(@NotNull Producer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        return null;
    }

    @Nullable
    public SearchPathProducer createSearchPathGroup(@NotNull ScriptingContext context, @NotNull SearchPath path) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return null;
    }

    public boolean isSchemaAlwaysInPath(@NotNull String sc) {
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        return false;
    }

    @NotNull
    public <T extends BasicElement> CapabilityInvocator getInvocator(@NotNull BasicElementProducer<T> producer, @NotNull ElementData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return AlterCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)AlterCapableInvocator.INSTANCE : (CreateCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)CreateCapableInvocator.INSTANCE : (DropCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)DropCapableInvocator.INSTANCE : (CapabilityInvocator)UnsupportedCapableInvocator.INSTANCE));
    }

    @Nullable
    public final <T extends BasicElement> FlagValue checkAlterPropertyFlag(@NotNull AlterData<T> data, @NotNull BasicMetaProperty<T, ?> prop) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        BasicMetaPropertyId basicMetaPropertyId = prop.id;
        return Intrinsics.areEqual((Object)basicMetaPropertyId, (Object)BasicModNamedElement.NAME) ? FlagValue.Companion.ofChange(ProducerUtilsKt.checkRenameImpl(data.getElement(), data.getTo(), data.getOptions())) : (Intrinsics.areEqual((Object)basicMetaPropertyId, (Object)BasicModNamedElement.NAME_QUOTED) || Intrinsics.areEqual((Object)basicMetaPropertyId, (Object)BasicModNamedElement.NAME_SCRIPTED) || Intrinsics.areEqual((Object)basicMetaPropertyId, (Object)BasicModNamedElement.NAME_SURROGATE) ? FlagValue.IGNORE : null);
    }

    @Nullable
    public final FlagValue checkAlterFakeFlag(@NotNull AlterData<?> data, @NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id, (Object)AlterCapableProducerKt.getTMP_NAME_FLAG_ID()) ? FlagValue.Companion.ofChange(data.getTmpName() != null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> boolean checkAlterValue(@NotNull ProducerData data, @Nullable V v1, @Nullable V v2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        V v = v1;
        if (v instanceof DasType) {
            DasType dasType = (DasType)v2;
            if (SourceAwareProducersKt.areEqual(((DasType)v1).toDataType(), (DataType)(dasType != null ? dasType.toDataType() : null), data.getContext())) return false;
            return true;
        }
        if (v instanceof SequenceIdentity) {
            if (!((SequenceIdentity)v1).equalsIgnoreNext((SequenceIdentity)v2)) return true;
            if ((Boolean)data.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE) == false) return false;
            V v3 = v2;
            if (v3 == null) return false;
            BigInteger bigInteger = ((SequenceIdentity)v3).next;
            if (bigInteger == null) return false;
            V v4 = v2;
            if (Intrinsics.areEqual((Object)((SequenceIdentity)v1).next, (Object)(v4 != null ? ((SequenceIdentity)v4).next : null))) return false;
            return true;
        }
        if (Objects.deepEquals(v1, v2)) return false;
        return true;
    }

    @NotNull
    public final <T extends BasicElement> ScriptingCapabilities.VersionedCapability<Boolean> canCreateWith(@NotNull CreateCapableProducer<T> producer, @NotNull CreateData<T> data, @NotNull BasicMetaId prop) {
        ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        if (Intrinsics.areEqual((Object)prop, (Object)BasicModArrangedElement.POSITION)) {
            versionedCapability = AbstractScriptGeneratorKt.getUNSUPPORTED();
        } else {
            BasicMetaField $this$canCreateWith_u24lambda_u240 = data.getMetaObject().getField(prop);
            boolean bl = false;
            versionedCapability = $this$canCreateWith_u24lambda_u240 == null || $this$canCreateWith_u24lambda_u240.isInternal() || $this$canCreateWith_u24lambda_u240.isAbstract() ? AbstractScriptGeneratorKt.getUNSUPPORTED() : AbstractScriptGeneratorKt.getSUPPORTED();
        }
        return versionedCapability;
    }

    @NotNull
    public final <T extends BasicElement> ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull AlterCapableProducer<T> producer, @NotNull AlterData<T> data, @NotNull BasicMetaId prop) {
        ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        if (Intrinsics.areEqual((Object)basicMetaId, (Object)BasicModNamedElement.NAME_QUOTED) || Intrinsics.areEqual((Object)basicMetaId, (Object)BasicModNamedElement.NAME_SCRIPTED) || Intrinsics.areEqual((Object)basicMetaId, (Object)BasicModNamedElement.NAME_SURROGATE)) {
            BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.NAME;
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"NAME");
            versionedCapability = producer.canAlter(data, (BasicMetaId)basicMetaPropertyId);
        } else if (Intrinsics.areEqual((Object)basicMetaId, (Object)BasicModSourceAware.SOURCE_TEXT)) {
            versionedCapability = AbstractScriptGeneratorKt.getSUPPORTED();
        } else {
            BasicMetaField $this$canAlter_u24lambda_u240 = data.getMetaObject().getField(prop);
            boolean bl = false;
            versionedCapability = $this$canAlter_u24lambda_u240 == null || $this$canAlter_u24lambda_u240.isInternal() || $this$canAlter_u24lambda_u240.isAbstract() ? AbstractScriptGeneratorKt.getUNSUPPORTED() : AbstractScriptGeneratorKt.getSUPPORTED();
        }
        return versionedCapability;
    }

    @NotNull
    public String scopeResolutionSeparator(@NotNull BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ".";
    }

    private static final SqlLanguageDialect sqlLang_delegate$lambda$0(ScriptGeneratorHelper this$0) {
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(this$0.dbms);
    }

    private static final ParserDefinition sqlDef_delegate$lambda$0(ScriptGeneratorHelper this$0) {
        ParserDefinition parserDefinition;
        SqlLanguageDialect sqlLanguageDialect = this$0.getSqlLang();
        if (sqlLanguageDialect != null) {
            SqlLanguageDialect it = sqlLanguageDialect;
            boolean bl = false;
            parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)it);
        } else {
            parserDefinition = null;
        }
        return parserDefinition;
    }

    private static final NamingService.Provider namingServiceProvider_delegate$lambda$0(ScriptGeneratorHelper this$0) {
        return (NamingService.Provider)NamingServices.INSTANCE.forDbms(this$0.dbms);
    }

    private static final Unit produceAlterNotSupported$lambda$0(BasicMetaId $id, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        $this$newCoding.error("Alter " + $id.name + " not supported");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScriptLocus.values().length];
            try {
                nArray[ScriptLocus.OUTSIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptLocus.IN_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptLocus.IN_COLUMN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

