/*
 * Decompiled with CFR 0.152.
 */
package git4idea.applyChanges;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.applyChanges.GitApplyChangesCommitStrategy;
import git4idea.applyChanges.GitApplyChangesCommitStrategyKt;
import git4idea.applyChanges.GitApplyChangesProcess;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016JD\u0010\u001b\u001a\u00020\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006 "}, d2={"Lgit4idea/applyChanges/ChangeListGitApplyChangesCommit;", "Lgit4idea/applyChanges/GitApplyChangesCommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "gitApplyChangesProcess", "Lgit4idea/applyChanges/GitApplyChangesProcess;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitMessage", "", "Lcom/intellij/openapi/util/NlsSafe;", "preserveCommitMetadata", "", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/applyChanges/GitApplyChangesProcess;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;Z)V", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getChangeList", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "setChangeList", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "previousDefaultChangelist", "getPreviousDefaultChangelist", "setPreviousDefaultChangelist", "start", "", "finish", "doUserCommit", "onSuccessfulCommit", "Lkotlin/Function1;", "onSkippedCommit", "onCancelledCommit", "intellij.vcs.git"})
public final class ChangeListGitApplyChangesCommit
extends GitApplyChangesCommitStrategy {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GitApplyChangesProcess gitApplyChangesProcess;
    @NotNull
    private final VcsCommitMetadata commit;
    @NotNull
    private final String commitMessage;
    private final boolean preserveCommitMetadata;
    public LocalChangeList changeList;
    public LocalChangeList previousDefaultChangelist;

    public ChangeListGitApplyChangesCommit(@NotNull GitRepository repository2, @NotNull GitApplyChangesProcess gitApplyChangesProcess, @NotNull VcsCommitMetadata commit, @NotNull String commitMessage, boolean preserveCommitMetadata) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)gitApplyChangesProcess, (String)"gitApplyChangesProcess");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project, null);
        this.repository = repository2;
        this.gitApplyChangesProcess = gitApplyChangesProcess;
        this.commit = commit;
        this.commitMessage = commitMessage;
        this.preserveCommitMetadata = preserveCommitMetadata;
    }

    @NotNull
    public final LocalChangeList getChangeList() {
        LocalChangeList localChangeList = this.changeList;
        if (localChangeList != null) {
            return localChangeList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"changeList");
        return null;
    }

    public final void setChangeList(@NotNull LocalChangeList localChangeList) {
        Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
        this.changeList = localChangeList;
    }

    @NotNull
    public final LocalChangeList getPreviousDefaultChangelist() {
        LocalChangeList localChangeList = this.previousDefaultChangelist;
        if (localChangeList != null) {
            return localChangeList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previousDefaultChangelist");
        return null;
    }

    public final void setPreviousDefaultChangelist(@NotNull LocalChangeList localChangeList) {
        Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
        this.previousDefaultChangelist = localChangeList;
    }

    @Override
    public void start() {
        LocalChangeList localChangeList = this.getChangeListManager().getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        this.setPreviousDefaultChangelist(localChangeList);
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String changeListName = ChangeListUtil.createNameForChangeList((Project)project, (String)this.commitMessage);
        ChangeListData changeListData = this.preserveCommitMetadata ? GitApplyChangesCommitStrategyKt.access$toChangeListData(this.commit) : null;
        LocalChangeList localChangeList2 = this.getChangeListManager().addChangeList(changeListName, this.commitMessage, changeListData);
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList2, (String)"addChangeList(...)");
        this.setChangeList(localChangeList2);
        this.getChangeListManager().setDefaultChangeList(this.getChangeList(), true);
    }

    @Override
    public void finish() {
        this.getChangeListManager().setDefaultChangeList(this.getPreviousDefaultChangelist(), true);
        this.getChangeListManager().scheduleAutomaticEmptyChangeListDeletion(this.getChangeList(), true);
    }

    @Override
    public boolean doUserCommit(@NotNull Function1<? super VcsCommitMetadata, Unit> onSuccessfulCommit, @NotNull Function1<? super VcsCommitMetadata, Unit> onSkippedCommit, @NotNull Function1<? super VcsCommitMetadata, Unit> onCancelledCommit) {
        Intrinsics.checkNotNullParameter(onSuccessfulCommit, (String)"onSuccessfulCommit");
        Intrinsics.checkNotNullParameter(onSkippedCommit, (String)"onSkippedCommit");
        Intrinsics.checkNotNullParameter(onCancelledCommit, (String)"onCancelledCommit");
        ChangeListManagerEx changeListManagerEx = this.getChangeListManager();
        LocalChangeList localChangeList = this.getChangeListManager().getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        return GitApplyChangesCommitStrategyKt.access$commitChangelist(this.repository, this.gitApplyChangesProcess, changeListManagerEx, this.commit, this.commitMessage, localChangeList, this.getVcsHelper(), onSuccessfulCommit, onSkippedCommit, onCancelledCommit);
    }
}

