/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import git4idea.branch.CherryPickedCommitsHighlighter;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HighlightCherryPickedCommitsAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui2 = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui2 == null) {
            return false;
        }
        return CherryPickedCommitsHighlighter.getInstance(project, dataProvider, (VcsLogUi)ui2).hasHighlightingOrInProgress();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        if (e == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui2 = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui2 == null) {
            return;
        }
        CherryPickedCommitsHighlighter highlighter = CherryPickedCommitsHighlighter.getInstance(project, dataProvider, (VcsLogUi)ui2);
        if (selected) {
            VcsLogUsageTriggerCollector.triggerUsage((AnActionEvent)e, (Object)((Object)this));
            VisiblePack dataPack = ui2.getDataPack();
            String singleBranchName = CherryPickedCommitsHighlighter.getComparedBranchFromFilters(ui2.getFilterUi().getFilters(), dataPack.getRefs());
            if (singleBranchName == null) {
                HighlightCherryPickedCommitsAction.selectBranchAndPerformAction((VcsLogUiEx)ui2, e, (Consumer<? super String>)((Consumer)arg_0 -> HighlightCherryPickedCommitsAction.lambda$setSelected$0(ui2, highlighter, (VcsLogDataPack)dataPack, arg_0)), HighlightCherryPickedCommitsAction.getGitRoots(project, (VcsLogUi)ui2));
                return;
            }
            highlighter.startTask((VcsLogDataPack)dataPack, singleBranchName);
        } else {
            highlighter.stopTaskAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogUiEx ui2, @NotNull AnActionEvent event, final @NotNull Consumer<? super String> consumer, @NotNull Collection<? extends VirtualFile> visibleRoots) {
        if (ui2 == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(3);
        }
        if (event == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(5);
        }
        if (visibleRoots == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(6);
        }
        VisiblePack dataPack = ui2.getDataPack();
        ActionGroup actionGroup = new BranchPopupBuilder((VcsLogDataPack)dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull @NlsActions.ActionText String name, @NotNull Collection<? extends VcsRef> refs) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refs == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new DumbAwareAction(name){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        consumer.consume((Object)name);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/HighlightCherryPickedCommitsAction$1$1", "actionPerformed"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "refs";
                        break;
                    }
                }
                objectArray[1] = "git4idea/branch/HighlightCherryPickedCommitsAction$1";
                objectArray[2] = "createAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.build();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(GitBundle.message((String)"git.log.cherry.picked.highlighter.select.branch.popup", (Object[])new Object[0]), actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup.showInCenterOf((Component)VcsLogUiUtil.getComponent((VcsLogUiEx)ui2));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(7);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            Set visibleRoots = VcsLogUtil.getVisibleRoots((VcsLogUi)ui2);
            Set allRoots = visibleRoots;
            if (allRoots.isEmpty()) {
                allRoots = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots(), VcsRoot::getPath);
            }
            e.getPresentation().setEnabled(HighlightCherryPickedCommitsAction.hasGitRoots(project, visibleRoots));
            e.getPresentation().setVisible(HighlightCherryPickedCommitsAction.hasGitRoots(project, allRoots));
        }
    }

    @NotNull
    private static Collection<VirtualFile> getGitRoots(@NotNull Project project, @NotNull VcsLogUi ui2) {
        if (project == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(8);
        }
        if (ui2 == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.filter((Collection)VcsLogUtil.getVisibleRoots((VcsLogUi)ui2), root -> HighlightCherryPickedCommitsAction.isGitRoot(project, root));
        if (list == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots) {
        if (project == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(11);
        }
        if (roots == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(12);
        }
        return ContainerUtil.exists(roots, root -> HighlightCherryPickedCommitsAction.isGitRoot(project, root));
    }

    private static boolean isGitRoot(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(13);
        }
        if (root == null) {
            HighlightCherryPickedCommitsAction.$$$reportNull$$$0(14);
        }
        return GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root) != null;
    }

    private static /* synthetic */ void lambda$setSelected$0(MainVcsLogUi ui2, CherryPickedCommitsHighlighter highlighter, VcsLogDataPack dataPack, String selectedBranch) {
        VcsLogFilterCollection collection = ui2.getFilterUi().getFilters();
        collection = VcsLogFiltersKt.without((VcsLogFilterCollection)collection, VcsLogBranchLikeFilter.class);
        collection = VcsLogFiltersKt.with((VcsLogFilterCollection)collection, (VcsLogFilter)VcsLogFilterObject.fromBranch((String)selectedBranch));
        ui2.getFilterUi().setFilters(collection);
        highlighter.startTask(dataPack, selectedBranch);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/HighlightCherryPickedCommitsAction";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/HighlightCherryPickedCommitsAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectBranchAndPerformAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGitRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

