/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.ReadGpgAgentConfigException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 !2\u00020\u0001:\u0001!B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u001d\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lgit4idea/commit/signing/GpgAgentConfig;", "", "path", "Ljava/nio/file/Path;", "content", "", "", "<init>", "(Ljava/nio/file/Path;Ljava/util/Map;)V", "gpgAgentPaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "existingConfig", "(Lgit4idea/commit/signing/GpgAgentPaths;Lgit4idea/commit/signing/GpgAgentConfig;)V", "getPath", "()Ljava/nio/file/Path;", "getContent", "()Ljava/util/Map;", "pinentryProgram", "getPinentryProgram", "()Ljava/lang/String;", "isIntellijPinentryConfigured", "", "paths", "writeToFile", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGpgAgentConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfig.kt\ngit4idea/commit/signing/GpgAgentConfig\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n129#2:65\n158#2,3:66\n23#3:69\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfig.kt\ngit4idea/commit/signing/GpgAgentConfig\n*L\n29#1:65\n29#1:66,3\n40#1:69\n*E\n"})
public final class GpgAgentConfig {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Path path;
    @NotNull
    private final Map<String, String> content;
    @NotNull
    public static final String PINENTRY_PROGRAM = "pinentry-program";
    @NotNull
    public static final String DEFAULT_CACHE_TTL = "default-cache-ttl";
    @NotNull
    public static final String MAX_CACHE_TTL = "max-cache-ttl";
    @NotNull
    public static final String DEFAULT_CACHE_TTL_CONF_VALUE = "1800";
    @NotNull
    public static final String MAX_CACHE_TTL_CONF_VALUE = "7200";
    @NotNull
    private static final Logger LOG;

    public GpgAgentConfig(@NotNull Path path, @NotNull Map<String, String> content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.path = path;
        this.content = content;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getContent() {
        return this.content;
    }

    @Nullable
    public final String getPinentryProgram() {
        return this.content.get(PINENTRY_PROGRAM);
    }

    /*
     * WARNING - void declaration
     */
    public GpgAgentConfig(@NotNull GpgAgentPaths gpgAgentPaths, @Nullable GpgAgentConfig existingConfig) {
        void $this$_init__u24lambda_u240;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)gpgAgentPaths, (String)"gpgAgentPaths");
        Map map3 = map2 = MapsKt.createMapBuilder();
        Path path = gpgAgentPaths.getGpgAgentConf();
        GpgAgentConfig gpgAgentConfig = this;
        boolean bl = false;
        GpgAgentConfig gpgAgentConfig2 = existingConfig;
        Map map4 = gpgAgentConfig2 != null ? gpgAgentConfig2.content : null;
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        $this$_init__u24lambda_u240.putAll(map4);
        $this$_init__u24lambda_u240.put(DEFAULT_CACHE_TTL, DEFAULT_CACHE_TTL_CONF_VALUE);
        $this$_init__u24lambda_u240.put(MAX_CACHE_TTL, MAX_CACHE_TTL_CONF_VALUE);
        $this$_init__u24lambda_u240.put(PINENTRY_PROGRAM, gpgAgentPaths.getGpgPinentryAppLauncherConfigPath());
        Unit unit = Unit.INSTANCE;
        gpgAgentConfig(path, MapsKt.build((Map)map2));
    }

    public /* synthetic */ GpgAgentConfig(GpgAgentPaths gpgAgentPaths, GpgAgentConfig gpgAgentConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            gpgAgentConfig = null;
        }
        this(gpgAgentPaths, gpgAgentConfig);
    }

    public final boolean isIntellijPinentryConfigured(@NotNull GpgAgentPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        return Intrinsics.areEqual((Object)this.getPinentryProgram(), (Object)paths.getGpgPinentryAppLauncherConfigPath());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeToFile() throws IOException {
        void $this$mapTo$iv$iv;
        LOG.info("Writing gpg agent config to " + this.path);
        Path path = this.path;
        OpenOption[] $this$map$iv = this.content;
        boolean $i$f$map = false;
        OpenOption[] openOptionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(((Object)StringsKt.trimEnd((CharSequence)(key + " " + value))).toString());
        }
        Iterable iterable = (List)destination$iv$iv;
        openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
    }

    @NotNull
    public final Path component1() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.content;
    }

    @NotNull
    public final GpgAgentConfig copy(@NotNull Path path, @NotNull Map<String, String> content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        return new GpgAgentConfig(path, content);
    }

    public static /* synthetic */ GpgAgentConfig copy$default(GpgAgentConfig gpgAgentConfig, Path path, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            path = gpgAgentConfig.path;
        }
        if ((n & 2) != 0) {
            map2 = gpgAgentConfig.content;
        }
        return gpgAgentConfig.copy(path, map2);
    }

    @NotNull
    public String toString() {
        return "GpgAgentConfig(path=" + this.path + ", content=" + this.content + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.path).hashCode();
        result2 = result2 * 31 + ((Object)this.content).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GpgAgentConfig)) {
            return false;
        }
        GpgAgentConfig gpgAgentConfig = (GpgAgentConfig)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)gpgAgentConfig.path)) {
            return false;
        }
        return Intrinsics.areEqual(this.content, gpgAgentConfig.content);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/commit/signing/GpgAgentConfig$Companion;", "", "<init>", "()V", "PINENTRY_PROGRAM", "", "DEFAULT_CACHE_TTL", "MAX_CACHE_TTL", "DEFAULT_CACHE_TTL_CONF_VALUE", "MAX_CACHE_TTL_CONF_VALUE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "readConfig", "Lgit4idea/commit/signing/GpgAgentConfig;", "gpgAgentConf", "Ljava/nio/file/Path;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGpgAgentConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfig.kt\ngit4idea/commit/signing/GpgAgentConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n832#2:65\n862#2,2:66\n1205#2,2:68\n1282#2,2:70\n1285#2:73\n1#3:72\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfig.kt\ngit4idea/commit/signing/GpgAgentConfig$Companion\n*L\n49#1:65\n49#1:66,2\n49#1:68,2\n49#1:70,2\n49#1:73\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final GpgAgentConfig readConfig(@NotNull Path gpgAgentConf) {
            Intrinsics.checkNotNullParameter((Object)gpgAgentConf, (String)"gpgAgentConf");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(gpgAgentConf, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LOG.debug("Cannot find " + gpgAgentConf);
                return null;
            }
            try {
                void $this$associateTo$iv$iv;
                void $this$filterNotTo$iv$iv;
                Path path = gpgAgentConf;
                List<String> list = Files.readAllLines(path, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                Iterable $this$filterNot$iv = list;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Object object;
                    Map map2 = destination$iv$iv2;
                    String line = (String)element$iv$iv;
                    boolean bl = false;
                    char[] cArray = new char[]{' '};
                    List keyValue = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                    String key = (String)keyValue.get(0);
                    int n = 1;
                    List list2 = keyValue;
                    if (n < list2.size()) {
                        object = list2.get(n);
                    } else {
                        int it = n;
                        boolean bl2 = false;
                        object = "";
                    }
                    String value = (String)object;
                    Pair pair = TuplesKt.to((Object)key, (Object)value);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map config = destination$iv$iv2;
                return new GpgAgentConfig(gpgAgentConf, config);
            }
            catch (IOException e) {
                LOG.warn("Failed to read " + gpgAgentConf, (Throwable)e);
                throw new ReadGpgAgentConfigException(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

