/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.merge.CommitMessagePreview;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeDialogCustomizerHelper;
import git4idea.merge.RefInfo;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0003J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer;", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMultipleFileMergeDescription", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "file", "Lcom/intellij/openapi/vcs/FilePath;", "getCherryPickTitleCustomizerList", "repository", "Lgit4idea/repo/GitRepository;", "getFirstBranch", "branches", "", "getMergeTitleCustomizerList", "getRebaseTitleCustomizerList", "loadCherryPickCommitDetails", "Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "CherryPickDetails", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDefaultMergeDialogCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDefaultMergeDialogCustomizer.kt\ngit4idea/merge/GitDefaultMergeDialogCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1#2:431\n1#2:446\n1#2:460\n1#2:474\n777#3:432\n873#3,2:433\n1642#3,10:435\n1915#3:445\n1916#3:447\n1652#3:448\n1642#3,10:449\n1915#3:459\n1916#3:461\n1652#3:462\n1642#3,10:463\n1915#3:473\n1916#3:475\n1652#3:476\n1696#3,8:477\n*S KotlinDebug\n*F\n+ 1 GitDefaultMergeDialogCustomizer.kt\ngit4idea/merge/GitDefaultMergeDialogCustomizer\n*L\n57#1:446\n67#1:460\n80#1:474\n55#1:432\n55#1:433,2\n57#1:435,10\n57#1:445\n57#1:447\n57#1:448\n67#1:449,10\n67#1:459\n67#1:461\n67#1:462\n80#1:463,10\n80#1:473\n80#1:475\n80#1:476\n82#1:477,8\n*E\n"})
public class GitDefaultMergeDialogCustomizer
extends MergeDialogCustomizer {
    @NotNull
    private final Project project;

    public GitDefaultMergeDialogCustomizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        Collection collection;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection collection2 = GitUtil.getRepositoriesForFiles(this.project, files);
        if (collection2.isEmpty()) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Collection<GitRepository> collection3 = GitUtil.getRepositories(this.project);
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"getRepositories(...)");
            Iterable $this$filter$iv = collection3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Iterator element$iv$iv : $this$filterTo$iv$iv) {
                GitRepository it = (GitRepository)((Object)element$iv$iv);
                boolean bl2 = false;
                List<GitConflict> list = it.getStagingAreaHolder().getAllConflicts();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllConflicts(...)");
                boolean bl3 = !((Collection)list).isEmpty();
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = collection2;
        }
        Collection repos = collection;
        Iterable $this$mapNotNull$iv = repos;
        boolean $i$f$mapNotNull2 = false;
        Iterable $i$f$filter = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            String it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            GitRepository it = (GitRepository)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveMergeBranch(it);
            if ((refInfo != null ? refInfo.getPresentable() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set mergeBranches = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)mergeBranches).isEmpty()) {
            Set currentBranches = GitDefaultMergeDialogCustomizerKt.access$getCurrentBranchNameSet(repos);
            Object[] $i$f$mapNotNull2 = new Object[4];
            $i$f$mapNotNull2[0] = mergeBranches.size();
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)this.getFirstBranch(mergeBranches)).bold(), (String)"bold(...)");
            $i$f$mapNotNull2[2] = currentBranches.size();
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)this.getFirstBranch(currentBranches)).bold(), (String)"bold(...)");
            return GitBundleExtensions.html("merge.dialog.description.merge.label.text", $i$f$mapNotNull2);
        }
        Iterable $this$mapNotNull$iv2 = repos;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<RefInfo> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            RefInfo it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            GitRepository it = (GitRepository)element$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it);
            if (GitDefaultMergeDialogCustomizerKt.access$resolveRebaseOntoBranch(it) == null) continue;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List rebaseOntoBranches = (List)destination$iv$iv2;
        if (!((Collection)rebaseOntoBranches).isEmpty()) {
            String singleCurrentBranch = GitDefaultMergeDialogCustomizerKt.getSingleCurrentBranchName(repos);
            RefInfo singleOntoBranch = (RefInfo)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)rebaseOntoBranches));
            GitRepository singleRepo = (GitRepository)CollectionsKt.singleOrNull((Iterable)repos);
            RefInfo refInfo = singleOntoBranch;
            RefInfo refInfo2 = singleOntoBranch;
            return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(singleRepo, singleCurrentBranch, refInfo != null ? refInfo.getBranchName() : null, (Hash)(refInfo2 != null ? refInfo2.getHash() : null));
        }
        Iterable $this$mapNotNull$iv3 = repos;
        boolean $i$f$mapNotNull4 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator element$iv$iv$iv3 = $this$forEach$iv$iv$iv3.iterator();
        while (element$iv$iv$iv3.hasNext()) {
            CherryPickDetails it$iv$iv;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = element$iv$iv$iv3.next();
            boolean bl = false;
            GitRepository it = (GitRepository)element$iv$iv;
            boolean bl8 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.loadCherryPickCommitDetails(it) == null) continue;
            boolean bl9 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List cherryPickCommitDetails = (List)destination$iv$iv3;
        if (!((Collection)cherryPickCommitDetails).isEmpty()) {
            Iterable $this$distinctBy$iv = cherryPickCommitDetails;
            boolean $i$f$distinctBy = false;
            HashSet<CallSite> set$iv = new HashSet<CallSite>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                CherryPickDetails it = (CherryPickDetails)e$iv;
                boolean bl = false;
                String key$iv = it.getAuthorName() + it.getCommitMessage();
                if (!set$iv.add((CallSite)((Object)key$iv))) continue;
                list$iv.add(e$iv);
            }
            CherryPickDetails singleCherryPick = (CherryPickDetails)CollectionsKt.singleOrNull((List)list$iv);
            Object[] objectArray = new Object[5];
            objectArray[0] = cherryPickCommitDetails.size();
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)((CherryPickDetails)CollectionsKt.single((List)cherryPickCommitDetails)).getShortHash()).code(), (String)"code(...)");
            objectArray[2] = GitDefaultMergeDialogCustomizerKt.access$toInt(singleCherryPick != null);
            Object object = singleCherryPick;
            if (object == null || (object = ((CherryPickDetails)object).getAuthorName()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)object), (String)"text(...)");
            HtmlBuilder htmlBuilder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.br());
            Object object2 = singleCherryPick;
            if (object2 == null || (object2 = ((CherryPickDetails)object2).getCommitMessage()) == null) {
                object2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder.append((HtmlChunk)CommitMessagePreview.INSTANCE.asHtmlChunk((String)object2)), (String)"append(...)");
            return GitBundleExtensions.html("merge.dialog.description.cherry.pick.label.text", objectArray);
        }
        return super.getMultipleFileMergeDescription(files);
    }

    @NotNull
    public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
        MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList;
        GitRepository repository2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitRepository gitRepository = repository2 = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFileQuick(file);
        Object object = gitRepository != null ? gitRepository.getState() : null;
        if ((switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> this.getMergeTitleCustomizerList(repository2, file);
            case 2 -> this.getRebaseTitleCustomizerList(repository2, file);
            case 3 -> this.getCherryPickTitleCustomizerList(repository2, file);
            default -> diffEditorTitleCustomizerList = null;
        }) == null) {
            diffEditorTitleCustomizerList = GitMergeDialogCustomizerHelper.INSTANCE.getDefaultCustomizers(this.project, file);
        }
        return diffEditorTitleCustomizerList;
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getCherryPickTitleCustomizerList(GitRepository repository2, FilePath file) {
        String string;
        Hash hash = GitDefaultMergeDialogCustomizerKt.access$tryResolveRef(repository2, "CHERRY_PICK_HEAD");
        if (hash == null) {
            return null;
        }
        Hash cherryPickHead = hash;
        GitRevisionNumber gitRevisionNumber = GitHistoryUtils.getMergeBase(repository2.getProject(), repository2.getRoot(), "CHERRY_PICK_HEAD", "HEAD");
        if (gitRevisionNumber == null || (string = gitRevisionNumber.getRev()) == null) {
            return null;
        }
        String mergeBase = string;
        String string2 = GitBundle.message((String)"merge.dialog.diff.left.title.cherry.pick.label.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(string2, repository2, file, (Pair<String, String>)new Pair((Object)mergeBase, (Object)"HEAD"));
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)cherryPickHead.toShortString(), (String)"toShortString(...)");
        String string3 = GitBundleExtensions.html("merge.dialog.diff.right.title.cherry.pick.label.text", objectArray);
        String string4 = cherryPickHead.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(string3, repository2, file, string4);
        return GitMergeDialogCustomizerHelper.INSTANCE.getCustomizers(this.project, file, leftTitleCustomizer, rightTitleCustomizer);
    }

    @NlsSafe
    private final String getFirstBranch(Collection<String> branches) {
        return (String)CollectionsKt.first((Iterable)branches);
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getMergeTitleCustomizerList(GitRepository repository2, FilePath file) {
        Object[] objectArray;
        Hash hash = GitUtil.getHead(repository2);
        if (hash == null) {
            return null;
        }
        Hash currentBranchHash = hash;
        String string = repository2.getCurrentBranchName();
        if (string == null) {
            String string2 = currentBranchHash.toShortString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toShortString(...)");
        }
        String currentBranchPresentable = string;
        RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveMergeBranch(repository2);
        if (refInfo == null) {
            return null;
        }
        RefInfo mergeBranch = refInfo;
        Hash mergeBranchHash = mergeBranch.getHash();
        GitRevisionNumber gitRevisionNumber = GitHistoryUtils.getMergeBase(repository2.getProject(), repository2.getRoot(), currentBranchHash.asString(), mergeBranchHash.asString());
        if (gitRevisionNumber == null || (objectArray = gitRevisionNumber.getRev()) == null) {
            return null;
        }
        Object[] mergeBase = objectArray;
        objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)currentBranchPresentable).bold(), (String)"bold(...)");
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(GitBundleExtensions.html("merge.dialog.diff.title.changes.from.branch.label.text", objectArray), repository2, file, (Pair<String, String>)new Pair((Object)mergeBase, (Object)currentBranchHash.asString()));
        Object[] objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)mergeBranch.getPresentable()).bold(), (String)"bold(...)");
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(GitBundleExtensions.html("merge.dialog.diff.title.changes.from.branch.label.text", objectArray2), repository2, file, (Pair<String, String>)new Pair((Object)mergeBase, (Object)mergeBranchHash.asString()));
        return GitMergeDialogCustomizerHelper.INSTANCE.getCustomizers(this.project, file, leftTitleCustomizer, rightTitleCustomizer);
    }

    private final MergeDialogCustomizer.DiffEditorTitleCustomizerList getRebaseTitleCustomizerList(GitRepository repository2, FilePath file) {
        String string;
        Object[] objectArray;
        Hash hash = GitUtil.getHead(repository2);
        if (hash == null) {
            return null;
        }
        Hash currentBranchHash = hash;
        String string2 = repository2.getCurrentBranchName();
        if (string2 == null) {
            String string3 = currentBranchHash.toShortString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toShortString(...)");
        }
        String rebasingBranchPresentable = string2;
        RefInfo refInfo = GitDefaultMergeDialogCustomizerKt.access$resolveRebaseOntoBranch(repository2);
        if (refInfo == null) {
            return null;
        }
        RefInfo upstreamBranch = refInfo;
        Hash upstreamBranchHash = upstreamBranch.getHash();
        Hash hash2 = GitDefaultMergeDialogCustomizerKt.access$tryResolveRef(repository2, "REBASE_HEAD");
        if (hash2 == null) {
            return null;
        }
        Hash rebaseHead = hash2;
        GitRevisionNumber gitRevisionNumber = GitHistoryUtils.getMergeBase(repository2.getProject(), repository2.getRoot(), "REBASE_HEAD", upstreamBranchHash.asString());
        if (gitRevisionNumber == null || (objectArray = gitRevisionNumber.getRev()) == null) {
            return null;
        }
        Object[] mergeBase = objectArray;
        objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)rebaseHead.toShortString(), (String)"toShortString(...)");
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)rebasingBranchPresentable).bold(), (String)"bold(...)");
        String leftTitle = GitBundleExtensions.html("merge.dialog.diff.left.title.rebase.label.text", objectArray);
        String string4 = rebaseHead.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
        DiffEditorTitleCustomizer leftTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(leftTitle, repository2, file, string4);
        if (upstreamBranch.getBranchName() != null) {
            Object[] objectArray2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)upstreamBranch.getBranchName()).bold(), (String)"bold(...)");
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.rebase.with.branch.label.text", objectArray2);
        } else {
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.rebase.without.branch.label.text", new Object[0]);
        }
        String rightTitle = string;
        DiffEditorTitleCustomizer rightTitleCustomizer = GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(rightTitle, repository2, file, (Pair<String, String>)new Pair((Object)mergeBase, (Object)"HEAD"));
        return GitMergeDialogCustomizerHelper.INSTANCE.getCustomizers(this.project, file, leftTitleCustomizer, rightTitleCustomizer);
    }

    private final CherryPickDetails loadCherryPickCommitDetails(GitRepository repository2) {
        List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.project, repository2.getRoot(), CollectionsKt.listOf((Object)"CHERRY_PICK_HEAD"));
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectMetadata(...)");
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.singleOrNull(list);
        if (vcsCommitMetadata == null) {
            return null;
        }
        VcsCommitMetadata result2 = vcsCommitMetadata;
        String string = ((Hash)result2.getId()).toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
        String string2 = result2.getAuthor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = result2.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
        return new CherryPickDetails(string, string2, string3);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lgit4idea/merge/GitDefaultMergeDialogCustomizer$CherryPickDetails;", "", "shortHash", "", "authorName", "commitMessage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getShortHash", "()Ljava/lang/String;", "getAuthorName", "getCommitMessage", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class CherryPickDetails {
        @NotNull
        private final String shortHash;
        @NotNull
        private final String authorName;
        @NotNull
        private final String commitMessage;

        public CherryPickDetails(@NlsSafe @NotNull String shortHash, @NlsSafe @NotNull String authorName, @NlsSafe @NotNull String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)shortHash, (String)"shortHash");
            Intrinsics.checkNotNullParameter((Object)authorName, (String)"authorName");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.shortHash = shortHash;
            this.authorName = authorName;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final String getShortHash() {
            return this.shortHash;
        }

        @NotNull
        public final String getAuthorName() {
            return this.authorName;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @NotNull
        public final String component1() {
            return this.shortHash;
        }

        @NotNull
        public final String component2() {
            return this.authorName;
        }

        @NotNull
        public final String component3() {
            return this.commitMessage;
        }

        @NotNull
        public final CherryPickDetails copy(@NlsSafe @NotNull String shortHash, @NlsSafe @NotNull String authorName, @NlsSafe @NotNull String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)shortHash, (String)"shortHash");
            Intrinsics.checkNotNullParameter((Object)authorName, (String)"authorName");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            return new CherryPickDetails(shortHash, authorName, commitMessage);
        }

        public static /* synthetic */ CherryPickDetails copy$default(CherryPickDetails cherryPickDetails, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = cherryPickDetails.shortHash;
            }
            if ((n & 2) != 0) {
                string2 = cherryPickDetails.authorName;
            }
            if ((n & 4) != 0) {
                string3 = cherryPickDetails.commitMessage;
            }
            return cherryPickDetails.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "CherryPickDetails(shortHash=" + this.shortHash + ", authorName=" + this.authorName + ", commitMessage=" + this.commitMessage + ")";
        }

        public int hashCode() {
            int result2 = this.shortHash.hashCode();
            result2 = result2 * 31 + this.authorName.hashCode();
            result2 = result2 * 31 + this.commitMessage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CherryPickDetails)) {
                return false;
            }
            CherryPickDetails cherryPickDetails = (CherryPickDetails)other;
            if (!Intrinsics.areEqual((Object)this.shortHash, (Object)cherryPickDetails.shortHash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authorName, (Object)cherryPickDetails.authorName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commitMessage, (Object)cherryPickDetails.commitMessage);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Repository.State.values().length];
            try {
                nArray[Repository.State.MERGING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REBASING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.GRAFTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

