/*
 * Decompiled with CFR 0.152.
 */
package git4idea.performanceTesting;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import git4idea.performanceTesting.CheckGitLogIndexedCommand;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lgit4idea/performanceTesting/CheckGitLogIndexedCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "assertVcsLogIndexed", "Lcom/jetbrains/performancePlugin/utils/ActionCallbackProfilerStopper;", "Companion", "intellij.vcs.git"})
public final class CheckGitLogIndexedCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%checkGitLogIndexing";

    public CheckGitLogIndexedCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @NotNull
    protected Promise<? super Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper callback = this.assertVcsLogIndexed();
        return Promises.toPromise((ActionCallback)((ActionCallback)callback));
    }

    private final ActionCallbackProfilerStopper assertVcsLogIndexed() {
        ActionCallbackProfilerStopper callback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(callback){
            final /* synthetic */ ActionCallbackProfilerStopper $callback;
            {
                this.$callback = $callback;
            }

            public void projectClosing(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                VcsProjectLog projectLog = (VcsProjectLog)$this$serviceIfCreated$iv.getServiceIfCreated(VcsProjectLog.class);
                if (projectLog == null) {
                    this.$callback.reject("Vcs log was not initialized");
                    return;
                }
                VcsLogManager vcsLogManager = projectLog.getLogManager();
                Intrinsics.checkNotNull((Object)vcsLogManager);
                VcsLogManager projectLogManager = vcsLogManager;
                ApplicationManager.getApplication().invokeAndWait(() -> assertVcsLogIndexed.1.projectClosing$lambda$0(projectLogManager, this.$callback));
                VcsLogIndex index = projectLogManager.getDataManager().getIndex();
                if (index instanceof EmptyIndex) {
                    ActionCallback actionCallback = this.$callback.reject("Empty VCS index; nothing to test");
                    Intrinsics.checkNotNull((Object)actionCallback);
                } else {
                    for (VirtualFile root : index.getIndexingRoots()) {
                        if (!index.isIndexingEnabled(root) || index.isIndexed(root)) continue;
                        this.$callback.reject("Vcs root " + root.getPath() + " does not contain complete git log");
                        return;
                    }
                    this.$callback.setDone();
                }
            }

            private static final void projectClosing$lambda$0(VcsLogManager $projectLogManager, ActionCallbackProfilerStopper $callback) {
                if (!$projectLogManager.isLogUpToDate()) {
                    $callback.reject("Vcs log is not up to date");
                }
            }
        });
        return callback;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/performanceTesting/CheckGitLogIndexedCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

