/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.application.Topics;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.DvcsCloneDialogComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import git4idea.checkout.GitCloneUtils;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableInlineComponent;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersion;
import git4idea.config.InlineErrorNotifier;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitRememberedInputs;
import git4idea.ui.GitCloneDialogMainPanelCustomizer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010+\u001a\u00020,H\u0015J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/ui/GitCloneDialogComponent;", "Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "executableManager", "Lgit4idea/config/GitExecutableManager;", "kotlin.jvm.PlatformType", "getExecutableManager", "()Lgit4idea/config/GitExecutableManager;", "inlineComponent", "Lgit4idea/config/GitExecutableInlineComponent;", "errorNotifier", "Lgit4idea/config/InlineErrorNotifier;", "executableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "checkVersionAlarm", "Lcom/intellij/util/Alarm;", "versionCheckState", "Lgit4idea/ui/GitCloneDialogComponent$VersionCheckState;", "lastVersionCheckForDirectory", "Ljava/nio/file/Path;", "doClone", "", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "onComponentSelected", "scheduleCheckVersion", "checkDirectory", "Lcom/intellij/openapi/ui/ValidationInfo;", "directoryPath", "", "component", "Ljavax/swing/JComponent;", "checkGitVersion", "isOkActionEnabled", "", "notifyCloneError", "VersionCheckState", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCloneDialogComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCloneDialogComponent.kt\ngit4idea/ui/GitCloneDialogComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class GitCloneDialogComponent
extends DvcsCloneDialogComponent {
    @NotNull
    private final ModalityState modalityState;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final GitExecutableInlineComponent inlineComponent;
    @NotNull
    private final InlineErrorNotifier errorNotifier;
    @NotNull
    private final GitExecutableProblemHandler executableProblemHandler;
    @NotNull
    private final Alarm checkVersionAlarm;
    @NotNull
    private VersionCheckState versionCheckState;
    @Nullable
    private Path lastVersionCheckForDirectory;

    public GitCloneDialogComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dvcsRememberedInputs, (String)"getInstance(...)");
        super(project, ".git", dvcsRememberedInputs, dialogStateListener, (DvcsCloneDialogComponent.MainPanelCustomizer)new GitCloneDialogMainPanelCustomizer());
        this.modalityState = modalityState;
        Logger logger = Logger.getInstance(GitCloneDialogComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.inlineComponent = new GitExecutableInlineComponent(this.getErrorComponent(), this.modalityState, (JPanel)this.getMainPanel());
        this.errorNotifier = new InlineErrorNotifier(this.inlineComponent, this.modalityState, (Disposable)this);
        this.executableProblemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(project);
        this.checkVersionAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.versionCheckState = VersionCheckState.NOT_CHECKED;
    }

    private final GitExecutableManager getExecutableManager() {
        return GitExecutableManager.getInstance();
    }

    public void doClone(@NotNull CheckoutProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        String sourceRepositoryURL = this.getUrl();
        String directoryPath = this.getDirectory();
        Project project = this.getProject();
        DvcsCloneDialogComponent.MainPanelCustomizer mainPanelCustomizer = this.getMainPanelCustomizer();
        Intrinsics.checkNotNull((Object)mainPanelCustomizer, (String)"null cannot be cast to non-null type git4idea.ui.GitCloneDialogMainPanelCustomizer");
        GitCloneUtils.INSTANCE.clone(project, sourceRepositoryURL, directoryPath, ((GitCloneDialogMainPanelCustomizer)mainPanelCustomizer).getShallowCloneOptions(), listener2, "git.clone.unable.to.create.destination.dir", "git.clone.unable.to.find.destination.dir");
        Path parent = Paths.get(directoryPath, new String[0]).toAbsolutePath().getParent();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dvcsRememberedInputs, (String)"getInstance(...)");
        DvcsRememberedInputs rememberedInputs = dvcsRememberedInputs;
        rememberedInputs.addUrl(sourceRepositoryURL);
        rememberedInputs.setCloneParentDir(parentDirectory);
    }

    @RequiresEdt
    public void onComponentSelected(@NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this.updateOkActionState(dialogStateListener);
        if (this.versionCheckState == VersionCheckState.NOT_CHECKED) {
            this.versionCheckState = VersionCheckState.IN_PROGRESS;
            this.scheduleCheckVersion(dialogStateListener);
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            Topics.subscribe((Topic)topic, (Disposable)((Disposable)this), (Object)new ApplicationActivationListener(this, dialogStateListener){
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;
                {
                    this.this$0 = $receiver;
                    this.$dialogStateListener = $dialogStateListener;
                }

                public void applicationActivated(IdeFrame ideFrame) {
                    Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                    if (GitCloneDialogComponent.access$getVersionCheckState$p(this.this$0) == VersionCheckState.FAILED) {
                        GitCloneDialogComponent.access$scheduleCheckVersion(this.this$0, this.$dialogStateListener);
                    }
                }
            });
        }
    }

    private final void scheduleCheckVersion(VcsCloneDialogComponentStateListener dialogStateListener) {
        if (!this.errorNotifier.isTaskInProgress()) {
            this.checkVersionAlarm.addRequest(() -> GitCloneDialogComponent.scheduleCheckVersion$lambda$0(this, dialogStateListener), 0);
        }
    }

    @Nullable
    public ValidationInfo checkDirectory(@NotNull String directoryPath, @NotNull JComponent component2, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Path directory;
        Object object;
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        Object object2 = this;
        try {
            GitCloneDialogComponent $this$checkDirectory_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Paths.get($this$checkDirectory_u24lambda_u240.getDirectory(), new String[0]).toAbsolutePath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Path path = directory = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
        Path path2 = this.lastVersionCheckForDirectory;
        if (!Intrinsics.areEqual((Object)(path != null ? EelProviderUtil.getEelDescriptor((Path)path) : null), (Object)(path2 != null ? EelProviderUtil.getEelDescriptor((Path)path2) : null))) {
            this.versionCheckState = VersionCheckState.IN_PROGRESS;
            this.scheduleCheckVersion(dialogStateListener);
        }
        return super.checkDirectory(directoryPath, component2, dialogStateListener);
    }

    private final void checkGitVersion(VcsCloneDialogComponentStateListener dialogStateListener) {
        Path directory;
        Object $this$checkGitVersion_u24lambda_u241;
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, () -> GitCloneDialogComponent.checkGitVersion$lambda$0(this));
        GitCloneDialogComponent gitCloneDialogComponent = this;
        try {
            $this$checkGitVersion_u24lambda_u241 = gitCloneDialogComponent;
            boolean bl = false;
            $this$checkGitVersion_u24lambda_u241 = Result.constructor-impl((Object)Paths.get($this$checkGitVersion_u24lambda_u241.getDirectory(), new String[0]).toAbsolutePath());
        }
        catch (Throwable throwable) {
            $this$checkGitVersion_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        gitCloneDialogComponent = $this$checkGitVersion_u24lambda_u241;
        this.lastVersionCheckForDirectory = directory = (Path)((Object)(Result.isFailure-impl((Object)((Object)gitCloneDialogComponent)) ? null : gitCloneDialogComponent));
        try {
            GitExecutable gitExecutable = this.getExecutableManager().getExecutable(null, directory);
            Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
            GitExecutable executable = gitExecutable;
            GitVersion gitVersion2 = this.getExecutableManager().identifyVersion(this.getProject(), executable);
            Intrinsics.checkNotNullExpressionValue((Object)gitVersion2, (String)"identifyVersion(...)");
            GitVersion gitVersion3 = gitVersion2;
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, () -> GitCloneDialogComponent.checkGitVersion$lambda$2(gitVersion3, this, dialogStateListener));
        }
        catch (Throwable t) {
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, () -> GitCloneDialogComponent.checkGitVersion$lambda$3(this, t, dialogStateListener));
        }
    }

    @RequiresEdt
    protected boolean isOkActionEnabled() {
        return super.isOkActionEnabled() && this.versionCheckState == VersionCheckState.SUCCESS;
    }

    private final void notifyCloneError(Project project) {
        VcsNotifier.getInstance((Project)project).notifyError("git.clone.unable.to.create.destination.dir", VcsBundle.message((String)"clone.dialog.clone.button", (Object[])new Object[0]), VcsBundle.message((String)"clone.dialog.unable.create.destination.error", (Object[])new Object[0]));
    }

    private static final void scheduleCheckVersion$lambda$0(GitCloneDialogComponent this$0, VcsCloneDialogComponentStateListener $dialogStateListener) {
        this$0.checkGitVersion($dialogStateListener);
    }

    private static final Unit checkGitVersion$lambda$3$0(GitCloneDialogComponent this$0, VcsCloneDialogComponentStateListener $dialogStateListener) {
        this$0.versionCheckState = VersionCheckState.SUCCESS;
        this$0.updateOkActionState($dialogStateListener);
        return Unit.INSTANCE;
    }

    private static final ProgressIndicator checkGitVersion$lambda$0(GitCloneDialogComponent this$0) {
        GitExecutableInlineComponent gitExecutableInlineComponent = this$0.inlineComponent;
        String string = GitBundle.message((String)"clone.dialog.checking.git.version", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return gitExecutableInlineComponent.showProgress(string);
    }

    private static final Unit checkGitVersion$lambda$2(GitVersion $gitVersion, GitCloneDialogComponent this$0, VcsCloneDialogComponentStateListener $dialogStateListener) {
        if (!$gitVersion.isSupported()) {
            GitExecutableProblemHandlersKt.showUnsupportedVersionError(this$0.getProject(), $gitVersion, this$0.errorNotifier);
        } else {
            this$0.inlineComponent.hideProgress();
        }
        this$0.versionCheckState = VersionCheckState.SUCCESS;
        this$0.updateOkActionState($dialogStateListener);
        return Unit.INSTANCE;
    }

    private static final Unit checkGitVersion$lambda$3(GitCloneDialogComponent this$0, Throwable $t, VcsCloneDialogComponentStateListener $dialogStateListener) {
        this$0.executableProblemHandler.showError($t, this$0.errorNotifier, (Function0<Unit>)((Function0)() -> GitCloneDialogComponent.checkGitVersion$lambda$3$0(this$0, $dialogStateListener)));
        this$0.versionCheckState = VersionCheckState.FAILED;
        this$0.updateOkActionState($dialogStateListener);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ VersionCheckState access$getVersionCheckState$p(GitCloneDialogComponent $this) {
        return $this.versionCheckState;
    }

    public static final /* synthetic */ void access$scheduleCheckVersion(GitCloneDialogComponent $this, VcsCloneDialogComponentStateListener dialogStateListener) {
        $this.scheduleCheckVersion(dialogStateListener);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/ui/GitCloneDialogComponent$VersionCheckState;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_CHECKED", "SUCCESS", "IN_PROGRESS", "FAILED", "intellij.vcs.git"})
    private static final class VersionCheckState
    extends Enum<VersionCheckState> {
        public static final /* enum */ VersionCheckState NOT_CHECKED = new VersionCheckState();
        public static final /* enum */ VersionCheckState SUCCESS = new VersionCheckState();
        public static final /* enum */ VersionCheckState IN_PROGRESS = new VersionCheckState();
        public static final /* enum */ VersionCheckState FAILED = new VersionCheckState();
        private static final /* synthetic */ VersionCheckState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VersionCheckState[] values() {
            return (VersionCheckState[])$VALUES.clone();
        }

        public static VersionCheckState valueOf(String value) {
            return Enum.valueOf(VersionCheckState.class, value);
        }

        @NotNull
        public static EnumEntries<VersionCheckState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = versionCheckStateArray = new VersionCheckState[]{VersionCheckState.NOT_CHECKED, VersionCheckState.SUCCESS, VersionCheckState.IN_PROGRESS, VersionCheckState.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

